/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.background.filesharing;

import android.content.Context;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.background.filesharing.BaseTaskBundle;
import com.liveperson.messaging.network.http.RestRequestParams;

public class UploadFileTaskBundle
extends BaseTaskBundle {
    protected Uri mFileUri;
    protected String mFilePath;
    private int taskId;
    protected String mFileContentType;
    protected String mFileTypeExtension;
    private MaskedMessage maskedMessage;

    public UploadFileTaskBundle build(int taskId, Context context) {
        this.setTaskID(taskId);
        this.mFilePath = this.mFileUri.getPath();
        String fileExtensionFromUrl = MimeTypeMap.getFileExtensionFromUrl((String)this.mFileUri.toString());
        if (fileExtensionFromUrl != null) {
            this.mFileTypeExtension = fileExtensionFromUrl.toUpperCase();
        }
        if (this.mFileTypeExtension != null) {
            this.mFileContentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(this.mFileTypeExtension.toLowerCase());
        }
        return this;
    }

    @Override
    public UploadFileTaskBundle addBrandId(String brandId) {
        super.addBrandId(brandId);
        return this;
    }

    @Override
    public UploadFileTaskBundle addTargetId(String targetId) {
        super.addTargetId(targetId);
        return this;
    }

    @Override
    public UploadFileTaskBundle addSwiftDomain(String swiftDomain) {
        super.addSwiftDomain(swiftDomain);
        return this;
    }

    @Override
    public UploadFileTaskBundle addRestDomain(RestRequestParams restRequestParams) {
        super.addRestDomain(restRequestParams);
        return this;
    }

    public UploadFileTaskBundle addFileUri(Uri fileUri) {
        this.mFileUri = fileUri;
        return this;
    }

    public UploadFileTaskBundle addMessage(MaskedMessage maskedMessage) {
        this.maskedMessage = maskedMessage;
        return this;
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    protected void setTaskID(int taskId) {
        this.taskId = taskId;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public MaskedMessage getMessage() {
        return this.maskedMessage;
    }

    public String getFileContentType() {
        return this.mFileContentType;
    }

    public String getFileTypeExtension() {
        return this.mFileTypeExtension;
    }

    @Override
    public String getSwiftDomain() {
        return this.mSwiftDomain;
    }

    public RestRequestParams getRestParams() {
        return this.mRestRequestParams;
    }

    public Uri getFileUri() {
        return this.mFileUri;
    }
}

