/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import com.liveperson.api.request.GenerateUploadTokenRequest;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;

public class SendGenerateUploadTokenCommand
implements Command {
    private static final String TAG = "SendGenUploadTokenCmd";
    private String mDialogId;
    private String mFormId;
    private String mInvitationId;
    private String mSocketUrl;
    private ICallback<Object, Throwable> mCallback;

    public SendGenerateUploadTokenCommand(String socketUrl, String formId, String dialogId, String invitationId, ICallback<Object, Throwable> callback) {
        this.mSocketUrl = socketUrl;
        this.mDialogId = dialogId;
        this.mFormId = formId;
        this.mInvitationId = invitationId;
        this.mCallback = callback;
    }

    public void execute() {
        GenerateUploadTokenRequest baseSocketRequest = new GenerateUploadTokenRequest(this.mSocketUrl, this.mDialogId, this.mFormId, this.mInvitationId);
        baseSocketRequest.setResponseCallBack(new ICallback<Object, Throwable>(){

            public void onSuccess(Object value) {
                SendGenerateUploadTokenCommand.this.mCallback.onSuccess(value);
                LPLog.INSTANCE.d(SendGenerateUploadTokenCommand.TAG, "onSuccess with value: " + value);
            }

            public void onError(Throwable exception) {
                LPLog.INSTANCE.w(SendGenerateUploadTokenCommand.TAG, "an error in parsing", exception);
                SendGenerateUploadTokenCommand.this.mCallback.onError(exception);
            }
        });
        SocketManager.getInstance().send((BaseSocketRequest)baseSocketRequest);
    }
}

