/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.DialogType;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.model.MessagingUserProfile;
import com.liveperson.messaging.network.http.AgentProfileRequest;
import com.liveperson.messaging.utils.ClockUtils;

public class DialogUtils {
    private static final String TAG = "DialogUtils";
    protected final Messaging mController;

    public DialogUtils(Messaging controller) {
        this.mController = controller;
    }

    public void addClosedDialogDivider(String brandId, Dialog dialog, String assignedAgentServerId, CloseReason resolvedBy, boolean updateUI, @Nullable ICallback<Void, Exception> callback) {
        this.mController.amsMessages.isResolveMessageForDialogAdded(dialog.getDialogId()).setPostQueryOnBackground(resolveMessageExists -> {
            if (resolveMessageExists.booleanValue()) {
                LPLog.INSTANCE.d(TAG, "resolved divider for dialog: " + dialog.getDialogId() + " already exists!");
                if (callback != null) {
                    callback.onSuccess(null);
                }
            } else {
                Object originatorId = resolvedBy == CloseReason.CONSUMER ? this.mController.getOriginatorId(brandId) : (resolvedBy == CloseReason.TIMEOUT || resolvedBy == CloseReason.SYSTEM ? null : assignedAgentServerId);
                LPLog.INSTANCE.d(TAG, "adding resolved divider for dialog: " + dialog.getDialogId());
                this.addResolvedDivider(dialog, (String)originatorId, resolvedBy, updateUI, callback);
            }
        }).execute();
    }

    private void addResolvedDivider(Dialog dialog, String originatorId, CloseReason resolvedBy, boolean updateUI, @Nullable ICallback<Void, Exception> callback) {
        long timestamp = ClockUtils.addDiffToTimestamp(dialog.getEndTimestamp());
        if (dialog.getDialogType() == DialogType.MAIN) {
            if (resolvedBy == CloseReason.TIMEOUT || resolvedBy == CloseReason.SYSTEM) {
                LPLog.INSTANCE.d(TAG, "This conversation was Auto closed - Don't add Resolved message");
                if (callback != null) {
                    callback.onError((Throwable)new Exception("This conversation timed out or Auto closed"));
                }
            } else {
                this.addResolveMessage(dialog.getDialogId(), timestamp, "", originatorId, updateUI, MessagingChatMessage.MessageType.SYSTEM_RESOLVED, callback);
            }
        } else {
            this.addResolveMessage(dialog.getDialogId(), timestamp, "dialog closed", originatorId, updateUI, MessagingChatMessage.MessageType.SYSTEM_DIALOG_RESOLVED, callback);
        }
    }

    private void addResolveMessage(String dialogId, long timestamp, String message, String originatorId, boolean updateUI, MessagingChatMessage.MessageType messageType, ICallback<Void, Exception> callback) {
        LPLog.INSTANCE.d(TAG, "creating message resolve at time: " + timestamp + " timestamp: " + timestamp);
        String eventId = timestamp + "_" + -2;
        MessagingChatMessage systemResolved = new MessagingChatMessage(originatorId, message, timestamp, dialogId, eventId, messageType, MessagingChatMessage.MessageState.RECEIVED, EncryptionVersion.NONE);
        systemResolved.setServerSequence(-2);
        this.mController.amsMessages.addMessage(systemResolved, updateUI).setPostQueryOnBackground(data -> {
            if (callback != null) {
                callback.onSuccess(null);
            }
        }).execute();
    }

    public void updateParticipants(String targetId, String[] participants, UserProfile.UserType userType, String dialogId, boolean updateUI, boolean forceUpdate) {
        this.updateParticipants(targetId, participants, userType, dialogId, updateUI, forceUpdate, null);
    }

    public void updateParticipants(String targetId, String[] participants, UserProfile.UserType userType, String dialogId, boolean updateUI, boolean forceUpdate, ICallback<MessagingUserProfile, Exception> callback) {
        for (String userId : participants) {
            if (!TextUtils.isEmpty((CharSequence)userId)) {
                this.mController.amsUsers.getUserById(userId).setPostQueryOnBackground(userProfile -> {
                    if (userProfile == null) {
                        userProfile = new MessagingUserProfile("", "", userType);
                        userProfile.setOriginatorID(userId);
                        this.mController.amsUsers.updateUserProfile((MessagingUserProfile)userProfile);
                        LPLog.INSTANCE.i(TAG, "First time bringing information for another participant that joined dialog " + dialogId);
                        this.sendUpdateUserRequest(targetId, userId, dialogId, updateUI, callback);
                    } else if (userProfile.isEmptyUser() || forceUpdate) {
                        this.sendUpdateUserRequest(targetId, userId, dialogId, updateUI, callback);
                    } else if (callback != null) {
                        callback.onSuccess(userProfile);
                    }
                }).execute();
                continue;
            }
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000075, "Missing agent ID!");
        }
    }

    private void sendUpdateUserRequest(String targetId, String userId, String dialogId, boolean shouldUpdateUi, ICallback<MessagingUserProfile, Exception> callback) {
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            new AgentProfileRequest(this.mController, targetId, userId, dialogId, shouldUpdateUi).setCallback(callback).execute();
        } else {
            if (TextUtils.isEmpty((CharSequence)dialogId)) {
                LPLog.INSTANCE.d(TAG, "sendUpdateUserRequest: no dialog id");
                return;
            }
            this.mController.amsDialogs.queryDialogById(dialogId).setPostQueryOnBackground(dialog -> {
                LPLog.INSTANCE.d(TAG, "onResult: Calling agent details callback with null agent");
                this.mController.onAgentDetailsChanged(null, dialog.isOpen());
            }).execute();
        }
    }
}

