/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.structuredcontent.model.elements.basic;

import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import com.liveperson.infra.utils.LpColorParseUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ElementStyle {
    private boolean mBold = false;
    private boolean mItalic = false;
    @ColorInt
    private Integer mTextColor = null;
    private ElementSize mSize;
    @ColorInt
    private Integer mBackgroundColor;
    @ColorInt
    private Integer mBorderColor;
    private Integer mBorderRadius;

    public ElementStyle(JSONObject style) {
        this.setDefaultValues();
        if (style != null) {
            this.mBold = style.optBoolean("bold", false);
            this.mItalic = style.optBoolean("italic", false);
            try {
                String color = style.getString("color");
                this.mTextColor = LpColorParseUtils.parseColor((String)color);
            }
            catch (JSONException color) {
                // empty catch block
            }
            try {
                String backgroundColor = style.getString("background-color");
                this.mBackgroundColor = LpColorParseUtils.parseColor((String)backgroundColor);
            }
            catch (JSONException backgroundColor) {
                // empty catch block
            }
            try {
                String borderColor = style.getString("border-color");
                this.mBorderColor = LpColorParseUtils.parseColor((String)borderColor);
            }
            catch (JSONException borderColor) {
                // empty catch block
            }
            try {
                this.mBorderRadius = style.getInt("border-radius");
            }
            catch (JSONException borderColor) {
                // empty catch block
            }
            try {
                String size = style.getString("size");
                this.mSize = ElementSize.valueOf(size.toLowerCase());
            }
            catch (IllegalArgumentException | JSONException e) {
                this.mSize = ElementSize.small;
            }
        }
    }

    protected void setDefaultValues() {
        this.mBold = false;
        this.mItalic = false;
        this.mBackgroundColor = null;
        this.mBorderColor = null;
        this.mSize = ElementSize.small;
        this.mBorderRadius = null;
    }

    public boolean isBold() {
        return this.mBold;
    }

    public boolean isItalic() {
        return this.mItalic;
    }

    @Nullable
    public Integer getTextColor() {
        return this.mTextColor;
    }

    public ElementSize getSize() {
        return this.mSize;
    }

    @Nullable
    public Integer getBackgroundColor() {
        return this.mBackgroundColor;
    }

    @Nullable
    public Integer getBorderColor() {
        return this.mBorderColor;
    }

    @Nullable
    public Integer getBorderRadius() {
        return this.mBorderRadius;
    }

    public static enum ElementSize {
        small,
        medium,
        large;

    }
}

