/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import androidx.annotation.NonNull;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.ResendMessageCommand;
import com.liveperson.messaging.network.socket.requests.SendMessageRequest;
import org.json.JSONObject;

public class ResendURLMessageCommand
extends ResendMessageCommand {
    private static final String TAG = "ResendURLMessageCommand";
    private static final String KEY_JSON_HEADER = "message_with_url";
    private static final String KEY_JSON_TAG_MESSAGE = "original_message";

    public ResendURLMessageCommand(Messaging controller, String eventId, String targetId, String brandId, MaskedMessage message) {
        super(controller, eventId, targetId, brandId, message);
    }

    @Override
    @NonNull
    protected SendMessageRequest createMessageRequest(Messaging mController, String mEventId, String mTargetId, String mBrandId, String dialogId, String conversationId) {
        SendMessageRequest sendMessageRequest = new SendMessageRequest(mController, mEventId, mTargetId, mBrandId, dialogId, conversationId);
        sendMessageRequest.setMessageContent(this.getMessage(this.mMessage.getServerMessage()));
        return sendMessageRequest;
    }

    private String getMessage(String text) {
        try {
            JSONObject object = new JSONObject(text);
            JSONObject messageWithUrl = object.getJSONObject(KEY_JSON_HEADER);
            return messageWithUrl.getString(KEY_JSON_TAG_MESSAGE);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000D5, " cannot parse json " + LPLog.INSTANCE.mask((Object)text), (Throwable)e);
            return text;
        }
    }
}

