/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.pusher;

import com.liveperson.infra.Infra;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.model.Consumer;
import com.liveperson.messaging.Messaging;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\rJ\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003J\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcom/liveperson/messaging/commands/pusher/PusherHelper;", "", "brandId", "", "messagingController", "Lcom/liveperson/messaging/Messaging;", "(Ljava/lang/String;Lcom/liveperson/messaging/Messaging;)V", "getBrandId", "()Ljava/lang/String;", "getMessagingController", "()Lcom/liveperson/messaging/Messaging;", "getAuthToken", "getCertificatePinningKeys", "", "getConsumerId", "getPusherDomain", "messaging_release"})
public final class PusherHelper {
    @NotNull
    private final String brandId;
    @NotNull
    private final Messaging messagingController;

    @Nullable
    public final String getPusherDomain() {
        String pusherDomain = this.messagingController.mAccountsController.getServiceUrl(this.brandId, "pusher");
        CharSequence charSequence = pusherDomain;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || charSequence.length() == 0) {
            pusherDomain = PreferenceManager.getInstance().getStringValue("pusher", this.brandId, null);
        }
        return pusherDomain;
    }

    @Nullable
    public final String getConsumerId() {
        String consumerId = this.messagingController.amsUsers.getConsumerId(this.brandId);
        CharSequence charSequence = consumerId;
        boolean bl = false;
        boolean bl2 = false;
        if ((charSequence == null || charSequence.length() == 0) && Infra.instance.getConsumerManager().hasActiveConsumer()) {
            Consumer consumer = Infra.instance.getConsumerManager().getActiveConsumer();
            consumerId = consumer != null ? consumer.getConsumerId() : null;
        }
        return consumerId;
    }

    @Nullable
    public final String getAuthToken() {
        String token = this.messagingController.mAccountsController.getToken(this.brandId);
        CharSequence charSequence = token;
        boolean bl = false;
        boolean bl2 = false;
        if ((charSequence == null || charSequence.length() == 0) && Infra.instance.getConsumerManager().hasActiveConsumer()) {
            Consumer consumer = Infra.instance.getConsumerManager().getActiveConsumer();
            token = consumer != null ? consumer.getLpToken() : null;
        }
        return token;
    }

    @Nullable
    public final List<String> getCertificatePinningKeys() {
        List certificates = this.messagingController.mAccountsController.getCertificatePinningKeys(this.brandId);
        Collection collection = certificates;
        boolean bl = false;
        boolean bl2 = false;
        if ((collection == null || collection.isEmpty()) && Infra.instance.getConsumerManager().hasActiveConsumer()) {
            LPAuthenticationParams lpAuthenticationParams;
            Consumer consumer = Infra.instance.getConsumerManager().getActiveConsumer();
            LPAuthenticationParams lPAuthenticationParams = lpAuthenticationParams = consumer != null ? consumer.getLpAuthenticationParams() : null;
            certificates = lPAuthenticationParams != null ? lPAuthenticationParams.getCertificatePinningKeys() : null;
        }
        return certificates;
    }

    @NotNull
    public final String getBrandId() {
        return this.brandId;
    }

    @NotNull
    public final Messaging getMessagingController() {
        return this.messagingController;
    }

    public PusherHelper(@NotNull String brandId, @NotNull Messaging messagingController) {
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        Intrinsics.checkParameterIsNotNull((Object)messagingController, (String)"messagingController");
        this.brandId = brandId;
        this.messagingController = messagingController;
    }
}

