package com.liveperson.messaging.network.socket.requests

import com.liveperson.api.request.BaseAMSSocketRequest
import com.liveperson.api.request.SubscribeMessagingEvents
import com.liveperson.infra.log.LPLog
import com.liveperson.infra.network.socket.BaseResponseHandler
import com.liveperson.messaging.commands.tasks.MessagingEventSubscriptionManager
import org.json.JSONObject

/**
 * Created by shiranr on 1/31/18.
 */
class SubscribeMessagingEventsRequest(socketUrl : String, val conversationId : String, val dialogId: String, private val fromSeq : Int? = 0) : BaseAMSSocketRequest<SubscribeMessagingEvents.Response, SubscribeMessagingEventsRequest> (socketUrl) {

    companion object {
        private const val TAG = "SubMsgingEventsRequest"
        private const val SUBSCRIBE_MESSAGING_EVENTS_TYPE = "ms.SubscribeMessagingEvents"
    }

    override fun getData(): String = SubscribeMessagingEvents(conversationId, dialogId, fromSeq).toJsonString(requestId)


    override fun getRequestName(): String = SUBSCRIBE_MESSAGING_EVENTS_TYPE

    override fun getResponseHandler(): BaseResponseHandler<SubscribeMessagingEvents.Response,SubscribeMessagingEventsRequest> {
       return SubscribeMessagingEventsResponseHandler(dialogId)
    }
}

class SubscribeMessagingEventsResponseHandler(private val dialogId: String) : BaseResponseHandler<SubscribeMessagingEvents.Response,SubscribeMessagingEventsRequest> () {

    companion object {
        private const val TAG = "SubMsgingEventsResponse"
        private const val SUBSCRIBE_MESSAGING_EVENTS_RESPONSE_TYPE = "GenericSubscribeResponse"
    }

    override fun parse(jsonObject: JSONObject?): SubscribeMessagingEvents.Response = SubscribeMessagingEvents.Response(jsonObject!!)

    override fun handle(data: SubscribeMessagingEvents.Response?): Boolean {
        val serverError = 500
        val code = data?.code ?: serverError // Using Elvis operator, from: https://android.jlelse.eu/a-few-ways-to-implement-a-swift-like-guard-in-kotlin-ffd94027864e

        if (code > 201) {
            MessagingEventSubscriptionManager.onError(dialogId)
        } else {
            val body = data?.obj?.optJSONObject("body") ?: return true

            if (body.has("subscriptionId")) {
                val subscriptionId = body.getString("subscriptionId")
                LPLog.d(TAG, "'subscriptionId' == $subscriptionId. Please review task LE-87598 !")
            } else {
                // Running with the old UMS
                LPLog.w(TAG, "'subscriptionId' doesn't exist! please review task LE-87598 !")
            }
        }

        return true
    }

    override fun getAPIResponseType(): String = SUBSCRIBE_MESSAGING_EVENTS_RESPONSE_TYPE
}
