package com.liveperson.messaging.structuredcontent.model.elements.basic;

import com.liveperson.messaging.structuredcontent.model.elements.ActionableElement;
import com.liveperson.messaging.structuredcontent.parsers.ElementType;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by nirni on 2/2/17.
 * Image element. Holds the URL of the image (mandatory) and the image caption (not mandatory)
 */
public class ImageElement extends ActionableElement {

	/**
	 * The URL of the image
	 */
	private String mUrl;

	/**
	 * The image caption
	 */
	private String mCaption;


	public ImageElement() {
		super(ElementType.IMAGE);
	}

	/**
	 * This sets text body from the given json.

	 * @param jsonObject
	 * @throws JSONException
	 */
	public ImageElement(JSONObject jsonObject) throws JSONException {
		super(jsonObject);
		mUrl = jsonObject.getString(ElementType.URL);
		mCaption = jsonObject.optString(ElementType.CAPTION); // Caption is not mandatory
	}


	@Override
	public String toString() {

		StringBuilder sb = new StringBuilder();
		sb.append(getClass().getSimpleName() + " - Caption:" + mCaption + ", Url: " + mUrl);

		return sb.toString();
	}

	@Override
	public void accept(ElementVisitor visitor) {
		visitor.visit(this);
	}

	public String getUrl() {
		return mUrl;
	}

	public String getCaption() {
		return mCaption;
	}
}
