/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.pusher;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.PushUnregisterType;
import com.liveperson.infra.auth.LPAuthenticationType;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.http.requests.UnregisterPushRequest;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.commands.pusher.PusherHelper;
import com.liveperson.messaging.model.AmsUsers;
import com.liveperson.messaging.model.SynchronizedInternetConnectionCallback;
import java.util.List;
import java.util.Objects;

public class UnregisterPusherCommand
implements Command {
    private static final String TAG = "UnregisterPusherCommand";
    private static final String PUSHER_UNREGISTER_URL = "https://%s/api/account/%s/device/unregister?v=2.0";
    private static final String UN_AUTH_PUSHER_UNREGISTER_URL = "https://%s/api/account/%s/device/unregister";
    private static final int MAX_RETRY_NUMBER = 3;
    private final Messaging mMessagingController;
    private final AmsUsers mAmsUsers;
    private String mBrandId;
    private String mAppId;
    private String pusherURL;
    private String consumerId;
    @Nullable
    private ICallback<Void, Exception> listener;
    private boolean isFullLogout;
    private PushUnregisterType unregisterType;
    private int logoutRetry;
    private PusherHelper pusherHelper;
    private ICallback<Void, Exception> requestCallback = new ICallback<Void, Exception>(){

        public void onSuccess(Void value) {
            PreferenceManager.getInstance().setBooleanValue("IS_PUSHER_REGISTERED_PREFERENCE_KEY", UnregisterPusherCommand.this.mBrandId, false);
            PreferenceManager.getInstance().remove("CONSUMER_UNREGISTER_PUSHER_PREFERENCE_KEY", UnregisterPusherCommand.this.mBrandId);
            if (UnregisterPusherCommand.this.listener != null) {
                UnregisterPusherCommand.this.listener.onSuccess((Object)value);
            }
        }

        public void onError(Exception exception) {
            if (UnregisterPusherCommand.this.isFullLogout && UnregisterPusherCommand.this.logoutRetry < 3) {
                UnregisterPusherCommand.this.logoutRetry++;
                LPLog.INSTANCE.w(UnregisterPusherCommand.TAG, "Unregister pusher retry #: " + UnregisterPusherCommand.this.logoutRetry, (Throwable)exception);
                UnregisterPusherCommand.this.runUnregisterPush();
            } else {
                LPLog.INSTANCE.e(UnregisterPusherCommand.TAG, ErrorCode.ERR_00000148, "Failed to unregister pusher", (Throwable)exception);
                if (UnregisterPusherCommand.this.listener != null) {
                    UnregisterPusherCommand.this.listener.onError((Throwable)exception);
                }
            }
        }
    };

    public UnregisterPusherCommand(Messaging messagingController, AmsUsers amsUsers, String brandId, String consumerId) {
        this(messagingController, amsUsers, brandId, "", null, null, false);
        this.consumerId = consumerId;
    }

    public UnregisterPusherCommand(Messaging messagingController, AmsUsers amsUsers, String brandId, String appId, PushUnregisterType type, @Nullable ICallback<Void, Exception> listener, boolean isFullLogout) {
        this.mMessagingController = messagingController;
        this.mAmsUsers = amsUsers;
        this.mBrandId = brandId;
        this.mAppId = appId;
        this.listener = listener;
        this.isFullLogout = isFullLogout;
        this.unregisterType = type;
        this.logoutRetry = 0;
    }

    public void execute() {
        this.pusherHelper = new PusherHelper(this.mBrandId, this.mMessagingController);
        if (!PreferenceManager.getInstance().getBooleanValue("IS_PUSHER_REGISTERED_PREFERENCE_KEY", this.mBrandId, false) || this.unregisterType == PushUnregisterType.NONE && Objects.equals(this.pusherHelper.getAuthType(), LPAuthenticationType.AUTH.name())) {
            this.notifySuccess();
            return;
        }
        LPLog.INSTANCE.i(TAG, "execute unregister for brandId " + this.mBrandId);
        String pusherDomain = this.pusherHelper.getPusherDomain();
        if (TextUtils.isEmpty((CharSequence)pusherDomain)) {
            LPLog.INSTANCE.w(TAG, "pusherDomain does not exists. Quit unregister push");
            this.notifySuccess();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mAppId) && !TextUtils.isEmpty((CharSequence)this.consumerId)) {
            this.mAppId = PreferenceManager.getInstance().getStringValue("APP_ID_PREFERENCE_KEY", this.mBrandId, "");
            PreferenceManager.getInstance().setStringValue("CONSUMER_UNREGISTER_PUSHER_PREFERENCE_KEY", this.mBrandId, this.consumerId);
        } else {
            PreferenceManager.getInstance().setStringValue("APP_ID_PREFERENCE_KEY", this.mBrandId, this.mAppId);
        }
        this.pusherURL = this.isFullLogout && this.mMessagingController.mAccountsController.getAccount(this.mBrandId) != null && !this.mMessagingController.mAccountsController.getAccount(this.mBrandId).isAuthenticated() ? String.format(UN_AUTH_PUSHER_UNREGISTER_URL, pusherDomain, this.mBrandId) : String.format(PUSHER_UNREGISTER_URL, pusherDomain, this.mBrandId);
        if (TextUtils.isEmpty((CharSequence)this.consumerId)) {
            this.consumerId = this.pusherHelper.getConsumerId();
        }
        if (TextUtils.isEmpty((CharSequence)this.consumerId)) {
            LPLog.INSTANCE.w(TAG, "onResult: Cannot get consumerId. Quit unregister push");
            if (this.listener != null && this.isFullLogout) {
                this.listener.onSuccess(null);
            }
        } else {
            this.runUnregisterPush();
        }
    }

    private void notifySuccess() {
        if (this.listener != null) {
            this.listener.onSuccess(null);
        }
    }

    private void runUnregisterPush() {
        List<String> certificates = this.pusherHelper.getCertificatePinningKeys();
        if (this.isFullLogout) {
            LPLog.INSTANCE.d(TAG, "run: Unregister push immediately");
            if (InternetConnectionService.isNetworkAvailable()) {
                new UnregisterPushRequest(this.pusherURL, this.consumerId, this.mAppId, this.pusherHelper.getAuthType(), certificates).setUnregisterType(this.unregisterType).setCallback(this.requestCallback).execute();
            } else if (this.listener != null) {
                this.listener.onError((Throwable)new Exception("No network available"));
            }
        } else {
            new SynchronizedInternetConnectionCallback(() -> {
                LPLog.INSTANCE.d(TAG, "run: Unregister push for consumerId: " + LPLog.INSTANCE.mask((Object)this.consumerId));
                new UnregisterPushRequest(this.pusherURL, this.consumerId, this.mAppId, this.pusherHelper.getAuthType(), certificates).setUnregisterType(this.unregisterType).setCallback(this.requestCallback).execute();
            }).execute();
        }
    }
}

