/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.structuredcontent.model.elements.basic;

import com.liveperson.messaging.structuredcontent.model.elements.ActionableElement;
import com.liveperson.messaging.structuredcontent.model.elements.basic.ElementStyle;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ButtonElement
extends ActionableElement {
    private ElementStyle mStyle;
    private String mTitle;
    private boolean isLink;

    public ButtonElement(JSONObject jsonObject) throws JSONException {
        super(jsonObject);
        JSONArray actionArray;
        this.mTitle = (String)jsonObject.get("title");
        JSONObject style = jsonObject.optJSONObject("style");
        this.mStyle = new ElementStyle(style);
        JSONObject clickObject = jsonObject.optJSONObject("click");
        if (clickObject != null && (actionArray = clickObject.optJSONArray("actions")) != null) {
            for (int i = 0; i < actionArray.length(); ++i) {
                JSONObject actionObject = actionArray.getJSONObject(i);
                if (!"link".equals(actionObject.getString("type"))) continue;
                this.isLink = true;
                break;
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + " - " + this.mTitle + "\n");
        return sb.toString();
    }

    @Override
    public void accept(ElementVisitor visitor) {
        visitor.visit(this);
    }

    public String getTitle() {
        return this.mTitle;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public ElementStyle getStyle() {
        return this.mStyle;
    }

    public boolean isLink() {
        return this.isLink;
    }
}

