/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.structuredcontent.model.elements.basic;

import com.liveperson.infra.utils.Utils;
import com.liveperson.messaging.structuredcontent.model.elements.ActionableElement;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;
import org.json.JSONException;
import org.json.JSONObject;

public class MapElement
extends ActionableElement {
    private float mLatitude;
    private float mLongitude;

    public MapElement() {
        super("map");
    }

    public MapElement(JSONObject jsonObject) throws JSONException {
        super(jsonObject);
        String latitude = jsonObject.getString("la");
        String longitude = jsonObject.getString("lo");
        this.mLatitude = Utils.tryParse((Object)latitude, (float)0.0f);
        this.mLongitude = Utils.tryParse((Object)longitude, (float)0.0f);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + " - " + this.mLatitude + " : " + this.mLongitude + " \n");
        return sb.toString();
    }

    @Override
    public void accept(ElementVisitor visitor) {
        visitor.visit(this);
    }

    public float getLongitude() {
        return this.mLongitude;
    }

    public float getLatitude() {
        return this.mLatitude;
    }
}

