package com.liveperson.messaging.commands;

import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.MessagingChatMessage;

/**
 * A command for sending message
 */
public class ReSendImageCommand extends SendImageCommand {

    private long mFileRowId;

    /**
     * Creates a command for sending messages
     */
    public ReSendImageCommand(Messaging controller, String targetId, String brandId, String contentType, String thumbnailPath, String imagePath,
                              String fileExtension, String eventId,  MaskedMessage message,long fileRowId) {
        super(controller, targetId, brandId, contentType, thumbnailPath, imagePath, fileExtension, message);
        mFileRowId = fileRowId;
        mEventId = eventId;
    }

    @Override
    protected void addMessageToDBAndSend(String conversationId, MaskedMessage message) {
        mController.amsMessages.updateMessageState(mEventId, MessagingChatMessage.MessageState.QUEUED);
        mController.amsMessages.getRowIdByEventId(mEventId).setPostQueryOnBackground(data -> {
            mMessageRowId = data;
            if (mCallback != null) {
                mCallback.onFileAddedToDB(mMessageRowId,mFileRowId);
            }
        }).execute();
    }
}