package com.liveperson.messaging.structuredcontent.model.elements.complex;

import com.liveperson.messaging.structuredcontent.model.elements.BaseElement;
import com.liveperson.messaging.structuredcontent.parsers.ElementType;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by nirni on 2/2/17.
 * Layout complex element. This element can hold other elements as children. The layout has orientation
 * that is set according to the given json.
 * Also it holds a list of BaseElements
 */
public class LayoutElement extends ComplexElement {

	/**
	 * The orientation fo this layout element. <i>true</i> - vertical orientation, otherwise landscape
	 */
	private boolean mVerticalOrientation;


	/**
	 * Construct an empty layout
	 * @param type
	 * @param verticalOrientation
	 */
	public LayoutElement(String type, boolean verticalOrientation) {
		super(type);
		this.mVerticalOrientation = verticalOrientation;
	}

	/**
	 * Build the whole layout tree from the given json
	 * @param layout
	 * @throws JSONException
	 */
	public LayoutElement(JSONObject layout) throws JSONException {
		super(layout);

		// Set the orientation
		mVerticalOrientation = mType.equals(ElementType.VERTICAL);

	}



	public boolean isVerticalOrientation() {
		return mVerticalOrientation;
	}


	@Override
	public void accept(ElementVisitor visitor) {
		visitor.visit(this);
	}

	@Override
	public String toString() {

		StringBuilder sb = new StringBuilder();
		sb.append(getClass().getSimpleName() + "{\n");
		sb.append("Elements[\n");
		if( mElementList != null ) {
			for (BaseElement baseElement : mElementList) {
				sb.append(baseElement.toString());
			}
		}
		sb.append("]\n");
		sb.append("}\n");
		return sb.toString();
	}
}
