package com.liveperson.messaging.structuredcontent.visitor;


import com.liveperson.messaging.structuredcontent.model.elements.basic.ButtonElement;
import com.liveperson.messaging.structuredcontent.model.elements.basic.ImageElement;
import com.liveperson.messaging.structuredcontent.model.elements.basic.MapElement;
import com.liveperson.messaging.structuredcontent.model.elements.basic.TextElement;
import com.liveperson.messaging.structuredcontent.model.elements.complex.CarouselElement;
import com.liveperson.messaging.structuredcontent.model.elements.complex.LayoutElement;
import com.liveperson.messaging.structuredcontent.model.elements.complex.QuickRepliesElement;

/**
 * Created by nirni on 2/8/17.
 * An interface for a visitor on the structured content elements
 */
public interface ElementVisitor {

	void visit(LayoutElement layoutElement);

	void visit(TextElement textElement);

	void visit(ButtonElement buttonElement);

	void visit(ImageElement imageElement);

	void visit(MapElement mapElement);

	void visit(CarouselElement carouselElement);

	void visit(QuickRepliesElement quickRepliesElement);
}
