/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.request;

import android.text.TextUtils;
import com.liveperson.api.request.AbstractRequest;
import com.liveperson.api.response.AbstractResponse;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SubscribeExConversations
extends AbstractRequest {
    private static final String SUBSCRIBE_EX_CONVERSATIONS_TYPE = "cqm.SubscribeExConversations";
    private static final String BODY_MAX_LAST_UPDATE_TIME = "maxLastUpdatedTime";
    private static final String BODY_MIN_LAST_UPDATE_TIME = "minLastUpdatedTime";
    private static final String BODY_AGENT_IDS = "agentIds";
    private static final String BODY_CONSUMER_ID = "consumerId";
    private static final String BODY_BRAND_ID = "brandId";
    private static final String BODY_MAX_TTR = "maxETTR";
    private static final String BODY_CONV_STATE = "convState";
    private static final String BODY_CONV_STAGE = "stage";
    private String consumerId;
    private long maxLastUpdatedTime;
    private long minLastUpdatedTime;
    private String[] agentIds;
    private String brandId;
    private int maxETTR;
    private String[] convStage;

    public SubscribeExConversations(String consumerId, long maxLastUpdatedTime, long minLastUpdatedTime, String[] agentIds, String brandId, int maxETTR, String[] conversationStages) {
        this.consumerId = consumerId;
        this.maxLastUpdatedTime = maxLastUpdatedTime;
        this.minLastUpdatedTime = minLastUpdatedTime;
        this.agentIds = agentIds;
        this.brandId = brandId;
        this.maxETTR = maxETTR;
        this.convStage = conversationStages;
    }

    @Override
    public String getMessageType() {
        return SUBSCRIBE_EX_CONVERSATIONS_TYPE;
    }

    @Override
    protected void toJson(JSONObject json) throws JSONException {
        this.body.put(BODY_MAX_LAST_UPDATE_TIME, this.maxLastUpdatedTime != -1L ? Long.valueOf(this.maxLastUpdatedTime) : JSONObject.NULL);
        this.body.put(BODY_MIN_LAST_UPDATE_TIME, this.minLastUpdatedTime != -1L ? Long.valueOf(this.minLastUpdatedTime) : JSONObject.NULL);
        JSONArray jsonArray = new JSONArray();
        for (String agentId : this.agentIds) {
            jsonArray.put((Object)agentId);
        }
        this.body.put(BODY_AGENT_IDS, (Object)jsonArray);
        this.body.put(BODY_CONSUMER_ID, (Object)this.consumerId);
        this.body.put(BODY_BRAND_ID, (Object)this.brandId);
        this.body.put(BODY_MAX_TTR, this.maxETTR > 0 ? Integer.valueOf(this.maxETTR) : JSONObject.NULL);
        jsonArray = new JSONArray();
        for (String s : this.convStage) {
            jsonArray.put((Object)s);
        }
        this.body.put(BODY_CONV_STATE, (Object)jsonArray);
        this.body.put(BODY_CONV_STAGE, (Object)jsonArray);
        json.put("body", (Object)this.body);
    }

    public static class Response
    extends AbstractResponse {
        private static final String SUBSCRIPTION_ID = "subscriptionId";
        public static final String SUBSCRIBE_EX_CONVERSATIONS_RESPONSE_TYPE = "cqm.SubscribeExConversationsResponse";
        Body body = new Body();

        public Response(JSONObject obj) throws JSONException {
            super(obj);
            JSONObject innerBody = obj.getJSONObject("body");
            this.body.subscriptionId = innerBody.getString(SUBSCRIPTION_ID);
            if (TextUtils.isEmpty((CharSequence)this.body.subscriptionId)) {
                throw new JSONException("no subscription id");
            }
        }

        public Object getBody() {
            return this.body;
        }

        public static class Body {
            public String subscriptionId;
        }
    }
}

