/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging;

import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.liveperson.api.LivePersonCallback;
import com.liveperson.api.response.model.DeliveryStatusUpdateInfo;
import com.liveperson.infra.ConversationViewParams;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.PushType;
import com.liveperson.infra.PushUnregisterType;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.callbacks.InitLivePersonCallBack;
import com.liveperson.infra.model.types.ChatState;
import com.liveperson.infra.statemachine.InitProcess;
import com.liveperson.infra.statemachine.LogoutProcess;
import com.liveperson.infra.statemachine.ShutDownProcess;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.ActionFailureReason;
import com.liveperson.messaging.MessagingInitData;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import com.liveperson.messaging.model.AgentData;
import com.liveperson.messaging.model.MessagingChatMessage;
import com.liveperson.messaging.model.UserProfile;

public interface IMessaging {
    public void init(Context var1, MessagingInitData var2, InitLivePersonCallBack var3);

    public void init(Context var1, MessagingInitData var2, InitProcess var3);

    public void clearAllConversationData(String var1);

    public void shutDown(ShutDownProcess var1);

    public void liteLogout(String var1, String var2, String var3);

    public void logout(Context var1, MessagingInitData var2, boolean var3, PushUnregisterType var4, LogoutProcess var5);

    public boolean isInitialized();

    public void sendMessage(String var1, String var2, String var3, @Nullable DeliveryStatusUpdateInfo var4);

    public void sendMessageWithURL(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8);

    public void sendFormSubmissionMessageCommand(String var1);

    public int resendMessage(String var1, String var2, MessagingChatMessage.MessageType var3);

    public int resendMessage(String var1, String var2, long var3, MessagingChatMessage.MessageType var5);

    public void updateMessage(String var1, String var2, MessagingChatMessage.MessageType var3, MessagingChatMessage.MessageState var4);

    public void registerPusher(String var1, String var2, String var3, PushType var4, LPAuthenticationParams var5, ICallback<Void, Exception> var6);

    public void unregisterPusherOnLiteLogout(String var1, String var2);

    public void unregisterPusher(String var1, String var2, PushUnregisterType var3, ICallback<Void, Exception> var4, boolean var5);

    public void updateTokenInBackground(String var1, LPAuthenticationParams var2);

    public ActionFailureReason changeChatState(String var1, String var2, ChatState var3);

    public ActionFailureReason closeDialog(String var1);

    public ActionFailureReason markConversationAsUrgent(String var1, String var2);

    public ActionFailureReason markConversationAsNormal(String var1, String var2);

    public void sendCSAT(String var1, String var2, int var3, int var4);

    public void sendUserProfile(String var1, UserProfile var2);

    public void setCallback(LivePersonCallback var1);

    public void removeCallback();

    public void checkActiveConversation(String var1, ICallback<Boolean, Exception> var2);

    public void checkConversationIsMarkedAsUrgent(String var1, ICallback<Boolean, Exception> var2);

    public void checkAgentID(String var1, ICallback<AgentData, Exception> var2);

    public boolean clearHistory(String var1);

    public MaskedMessage getMaskedMessage(String var1, String var2);

    public void generateUploadToken(String var1, String var2, String var3);

    public void sendFileMessage(FileSharingType var1, String var2, String var3, String var4, String var5, boolean var6);

    public void downloadFile(FileSharingType var1, String var2, String var3, String var4, long var5, long var7, String var9);

    public void removeMultipleOlderImages(String var1);

    public boolean isSocketOpen(String var1);

    public void connect(String var1, LPAuthenticationParams var2, ConversationViewParams var3, boolean var4);

    public void connect(String var1, LPAuthenticationParams var2, ConversationViewParams var3);

    public void reconnect(String var1, LPAuthenticationParams var2);

    public void moveToBackground(String var1, long var2);

    public void moveToForeground(String var1, LPAuthenticationParams var2, ConversationViewParams var3);

    public void serviceStarted(String var1);

    public void serviceStopped(String var1);

    public void getUnreadMessagesCount(String var1, String var2, LPAuthenticationParams var3, ICallback<Integer, Exception> var4);

    public void getNumUnreadMessages(String var1, String var2, ICallback<Integer, Exception> var3);

    public void isPusherRegistered(String var1, String var2, String var3, LPAuthenticationParams var4, @NonNull ICallback<Boolean, Exception> var5);
}

