/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands.pusher;

import android.text.TextUtils;
import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.Infra;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.http.HttpHandler;
import com.liveperson.infra.network.http.request.HttpGetRequest;
import com.liveperson.infra.network.http.request.HttpRequest;
import com.liveperson.messaging.LpError;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.TaskType;
import com.liveperson.messaging.commands.pusher.PusherHelper;
import com.liveperson.messaging.model.SynchronizedAuthenticationCompletedCallback;
import com.liveperson.messaging.model.SynchronizedInternetConnectionCallback;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bBG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u00060\rj\u0002`\u000e0\u000b\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u0014\u0010\u0015\u001a\u00020\u00132\n\u0010\u0016\u001a\u00060\rj\u0002`\u000eH\u0002J\u001a\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0002J\b\u0010\u001a\u001a\u00020\u0013H\u0002R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f\u0012\b\u0012\u00060\rj\u0002`\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/liveperson/messaging/commands/pusher/GetIsPusherRegisteredCommand;", "Lcom/liveperson/infra/Command;", "controller", "Lcom/liveperson/messaging/Messaging;", "brandId", "", "deviceToken", "appId", "authenticationParams", "Lcom/liveperson/infra/auth/LPAuthenticationParams;", "callback", "Lcom/liveperson/infra/ICallback;", "", "Ljava/lang/Exception;", "Lkotlin/Exception;", "(Lcom/liveperson/messaging/Messaging;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/liveperson/infra/auth/LPAuthenticationParams;Lcom/liveperson/infra/ICallback;)V", "pusherHelper", "Lcom/liveperson/messaging/commands/pusher/PusherHelper;", "authorizeAndSendRequest", "", "execute", "notifyError", "exception", "sendRequest", "requestURL", "token", "validateNetworkState", "Companion", "messaging_release"})
public final class GetIsPusherRegisteredCommand
implements Command {
    private PusherHelper pusherHelper;
    private final Messaging controller;
    private final String brandId;
    private final String deviceToken;
    private final String appId;
    private final LPAuthenticationParams authenticationParams;
    private final ICallback<Boolean, Exception> callback;
    private static final String TAG = "GetIsPusherRegisteredCommand";
    private static final String URL = "https://%s/api/account/%s/device/isRegistered?appId=%s&consumerId=%s";
    public static final Companion Companion = new Companion(null);

    public void execute() {
        if (TextUtils.isEmpty((CharSequence)this.appId)) {
            this.callback.onError((Throwable)new Exception("Unable to make request. Error: Missing appID"));
            this.notifyError(new Exception("Unable to make request. Error: Missing appID"));
            return;
        }
        this.pusherHelper = new PusherHelper(this.brandId, this.controller);
        this.validateNetworkState();
    }

    private final void validateNetworkState() {
        if (InternetConnectionService.isNetworkAvailable()) {
            this.authorizeAndSendRequest();
        } else {
            new SynchronizedInternetConnectionCallback(new Runnable(this){
                final /* synthetic */ GetIsPusherRegisteredCommand this$0;

                public final void run() {
                    GetIsPusherRegisteredCommand.access$authorizeAndSendRequest(this.this$0);
                }
                {
                    this.this$0 = getIsPusherRegisteredCommand;
                }
            }).execute();
        }
    }

    private final void authorizeAndSendRequest() {
        boolean isExecuting2 = new SynchronizedAuthenticationCompletedCallback(this.controller.mAccountsController, this.brandId, (ICallback<Void, Exception>)((ICallback)new ICallback<Void, Exception>(this){
            final /* synthetic */ GetIsPusherRegisteredCommand this$0;

            public void onSuccess(@Nullable Void value) {
                try {
                    String consumerId;
                    String pusherDomain;
                    PusherHelper pusherHelper = GetIsPusherRegisteredCommand.access$getPusherHelper$p(this.this$0);
                    String string2 = pusherDomain = pusherHelper != null ? pusherHelper.getPusherDomain() : null;
                    if (TextUtils.isEmpty((CharSequence)pusherDomain)) {
                        GetIsPusherRegisteredCommand.access$notifyError(this.this$0, new Exception("Error: Missing Domain"));
                        return;
                    }
                    PusherHelper pusherHelper2 = GetIsPusherRegisteredCommand.access$getPusherHelper$p(this.this$0);
                    String string3 = consumerId = pusherHelper2 != null ? pusherHelper2.getConsumerId() : null;
                    if (TextUtils.isEmpty((CharSequence)consumerId)) {
                        GetIsPusherRegisteredCommand.access$notifyError(this.this$0, new Exception("Error: Missing consumerID"));
                        return;
                    }
                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                    String string4 = "https://%s/api/account/%s/device/isRegistered?appId=%s&consumerId=%s";
                    Object[] objectArray = new Object[]{pusherDomain, GetIsPusherRegisteredCommand.access$getBrandId$p(this.this$0), GetIsPusherRegisteredCommand.access$getAppId$p(this.this$0), consumerId};
                    boolean bl = false;
                    String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(format, *args)");
                    String url = string5;
                    PusherHelper pusherHelper3 = GetIsPusherRegisteredCommand.access$getPusherHelper$p(this.this$0);
                    String token = pusherHelper3 != null ? pusherHelper3.getAuthToken() : null;
                    GetIsPusherRegisteredCommand.access$sendRequest(this.this$0, url, token);
                }
                catch (Exception error) {
                    LPLog.INSTANCE.e("GetIsPusherRegisteredCommand", ErrorCode.ERR_00000054, "sendRequest: Failed to obtain domain/consumerId/token to make request ", (Throwable)error);
                }
            }

            public void onError(@Nullable Exception exception) {
                block0: {
                    Exception exception2 = exception;
                    if (exception2 == null) break block0;
                    Exception exception3 = exception2;
                    boolean bl = false;
                    boolean bl2 = false;
                    Exception it = exception3;
                    boolean bl3 = false;
                    LPLog.INSTANCE.e("GetIsPusherRegisteredCommand", ErrorCode.ERR_00000055, "authorizeAndSendRequest: Failed to authorize ", (Throwable)it);
                    GetIsPusherRegisteredCommand.access$notifyError(this.this$0, it);
                }
            }
            {
                this.this$0 = $outer;
            }
        })).executeWithReturnValue();
        if (!isExecuting2) {
            this.controller.connect(this.brandId, this.authenticationParams, null, true);
        }
    }

    private final void sendRequest(String requestURL, String token) {
        PusherHelper pusherHelper = this.pusherHelper;
        List<String> certificates = pusherHelper != null ? pusherHelper.getCertificatePinningKeys() : null;
        HttpGetRequest request = new HttpGetRequest(requestURL);
        request.addHeader("authorization", "bearer " + token);
        request.setCertificatePinningKeys(certificates);
        request.setCallback((ICallback)new ICallback<String, Exception>(this){
            final /* synthetic */ GetIsPusherRegisteredCommand this$0;

            public void onSuccess(@NotNull String response) {
                Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
                JSONObject jsonResponse = new JSONObject(response);
                boolean isRegistered = jsonResponse.getBoolean("isRegistered");
                String registeredDeviceToken = jsonResponse.getString("deviceToken");
                if (isRegistered && Intrinsics.areEqual((Object)GetIsPusherRegisteredCommand.access$getDeviceToken$p(this.this$0), (Object)registeredDeviceToken)) {
                    PreferenceManager.getInstance().setBooleanValue("IS_PUSHER_REGISTERED_PREFERENCE_KEY", GetIsPusherRegisteredCommand.access$getBrandId$p(this.this$0), true);
                    GetIsPusherRegisteredCommand.access$getCallback$p(this.this$0).onSuccess((Object)true);
                } else {
                    PreferenceManager.getInstance().setBooleanValue("IS_PUSHER_REGISTERED_PREFERENCE_KEY", GetIsPusherRegisteredCommand.access$getBrandId$p(this.this$0), false);
                    GetIsPusherRegisteredCommand.access$getCallback$p(this.this$0).onSuccess((Object)false);
                }
            }

            public void onError(@Nullable Exception exception) {
                GetIsPusherRegisteredCommand.access$getCallback$p(this.this$0).onError((Throwable)exception);
            }
            {
                this.this$0 = $outer;
            }
        });
        HttpHandler.execute((HttpRequest)((HttpRequest)request));
    }

    private final void notifyError(Exception exception) {
        Infra.instance.postOnMainThread(new Runnable(this, exception){
            final /* synthetic */ GetIsPusherRegisteredCommand this$0;
            final /* synthetic */ Exception $exception;

            public final void run() {
                if (this.$exception instanceof SSLPeerUnverifiedException) {
                    GetIsPusherRegisteredCommand.access$getController$p((GetIsPusherRegisteredCommand)this.this$0).mEventsProxy.onError(TaskType.INVALID_CERTIFICATE, this.$exception.getMessage());
                    GetIsPusherRegisteredCommand.access$getController$p((GetIsPusherRegisteredCommand)this.this$0).mEventsProxy.onError(LpError.INVALID_CERTIFICATE, this.$exception.getMessage());
                }
                GetIsPusherRegisteredCommand.access$getCallback$p(this.this$0).onError((Throwable)this.$exception);
            }
            {
                this.this$0 = getIsPusherRegisteredCommand;
                this.$exception = exception;
            }
        });
    }

    public GetIsPusherRegisteredCommand(@NotNull Messaging controller, @NotNull String brandId, @NotNull String deviceToken, @NotNull String appId, @Nullable LPAuthenticationParams authenticationParams, @NotNull ICallback<Boolean, Exception> callback) {
        Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
        Intrinsics.checkParameterIsNotNull((Object)brandId, (String)"brandId");
        Intrinsics.checkParameterIsNotNull((Object)deviceToken, (String)"deviceToken");
        Intrinsics.checkParameterIsNotNull((Object)appId, (String)"appId");
        Intrinsics.checkParameterIsNotNull(callback, (String)"callback");
        this.controller = controller;
        this.brandId = brandId;
        this.deviceToken = deviceToken;
        this.appId = appId;
        this.authenticationParams = authenticationParams;
        this.callback = callback;
    }

    public static final /* synthetic */ void access$authorizeAndSendRequest(GetIsPusherRegisteredCommand $this) {
        $this.authorizeAndSendRequest();
    }

    public static final /* synthetic */ PusherHelper access$getPusherHelper$p(GetIsPusherRegisteredCommand $this) {
        return $this.pusherHelper;
    }

    public static final /* synthetic */ void access$setPusherHelper$p(GetIsPusherRegisteredCommand $this, PusherHelper pusherHelper) {
        $this.pusherHelper = pusherHelper;
    }

    public static final /* synthetic */ void access$notifyError(GetIsPusherRegisteredCommand $this, Exception exception) {
        $this.notifyError(exception);
    }

    public static final /* synthetic */ String access$getBrandId$p(GetIsPusherRegisteredCommand $this) {
        return $this.brandId;
    }

    public static final /* synthetic */ String access$getAppId$p(GetIsPusherRegisteredCommand $this) {
        return $this.appId;
    }

    public static final /* synthetic */ void access$sendRequest(GetIsPusherRegisteredCommand $this, String requestURL, String token) {
        $this.sendRequest(requestURL, token);
    }

    public static final /* synthetic */ String access$getDeviceToken$p(GetIsPusherRegisteredCommand $this) {
        return $this.deviceToken;
    }

    public static final /* synthetic */ ICallback access$getCallback$p(GetIsPusherRegisteredCommand $this) {
        return $this.callback;
    }

    public static final /* synthetic */ Messaging access$getController$p(GetIsPusherRegisteredCommand $this) {
        return $this.controller;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/liveperson/messaging/commands/pusher/GetIsPusherRegisteredCommand$Companion;", "", "()V", "TAG", "", "URL", "messaging_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

