/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.structuredcontent.model.actions;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.structuredcontent.model.actions.BaseAction;
import com.liveperson.messaging.structuredcontent.model.actions.OnActionClickListener;
import com.liveperson.messaging.structuredcontent.visitor.ElementVisitor;
import org.json.JSONException;
import org.json.JSONObject;

public class LinkAction
extends BaseAction {
    private static final String TAG = "LinkAction";
    private String mUri;

    public LinkAction(JSONObject jsonObject) throws JSONException {
        super(jsonObject);
        JSONObject androidObject = jsonObject.optJSONObject("android");
        this.mUri = androidObject != null ? androidObject.getString("uri") : jsonObject.getString("uri");
    }

    @Override
    public OnActionClickListener getOnClickListener(Context context, String brandId) {
        return () -> {
            if (!TextUtils.isEmpty((CharSequence)this.mUri)) {
                if (Configuration.getBoolean((int)R.bool.structured_content_link_as_callback)) {
                    MessagingFactory.getInstance().getController().mEventsProxy.onStructuredContentLinkClicked(this.mUri);
                } else {
                    LPLog.INSTANCE.d(TAG, "onClick: activating link to: " + this.mUri);
                    Intent i = new Intent("android.intent.action.VIEW", Uri.parse((String)this.mUri));
                    PackageManager packageManager = context.getPackageManager();
                    if (i.resolveActivity(packageManager) != null) {
                        context.startActivity(i);
                    } else {
                        LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000156, "Failed to resolve Activity");
                    }
                }
            }
        };
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName() + "(\n");
        return sb.toString();
    }

    @Override
    public void accept(ElementVisitor visitor) {
    }

    @VisibleForTesting
    public String getUri() {
        return this.mUri;
    }
}

