package com.liveperson.api.sdk;

import android.os.Parcel;
import android.os.Parcelable;

import com.liveperson.api.response.types.CloseReason;

/**
 * Created by ofira on 3/27/17.
 *
 * Meta-data of the conversation
 */
public class LPConversationData implements Parcelable {

    private String mId;
    private CloseReason mCloseReason;

    public LPConversationData(String conversationId){
        mId = conversationId;
    }


    protected LPConversationData(Parcel in) {
        mId = in.readString();
        mCloseReason = CloseReason.values()[in.readInt()];
    }

    /**
     * Close reason - {@link CloseReason}
     * @return - in case of conversation resolved it's one of the following: {@link CloseReason#AGENT}
     *           {@link CloseReason#CONSUMER}
     *           {@link CloseReason#TIMEOUT}.
     *           null otherwise
     */
    public CloseReason getCloseReason() {
        return mCloseReason;
    }

    /**
     * Setting the close reason of the conversation
     * @param closeReason
     */
    public void setCloseReason(CloseReason closeReason) {
        mCloseReason = closeReason;
    }

    /**
     * Get conversation ID
     * @return - conversation ID
     */
    public String getId() {
        return mId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(mId);
        dest.writeInt(mCloseReason.ordinal());
    }


    public static final Creator<LPConversationData> CREATOR = new Creator<LPConversationData>() {
        @Override
        public LPConversationData createFromParcel(Parcel in) {
            return new LPConversationData(in);
        }

        @Override
        public LPConversationData[] newArray(int size) {
            return new LPConversationData[size];
        }
    };
}
