package com.liveperson.messaging.background.filesharing.image;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.webkit.MimeTypeMap;

import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.background.filesharing.UploadFileTaskBundle;
import com.liveperson.messaging.network.http.RestRequestParams;

/**
 * Created by shiranr on 7/24/16.
 */
public class UploadImageTaskBundle extends UploadFileTaskBundle {

	private boolean mImageFromCamera;

	public UploadImageTaskBundle addBrandId(String brandId) {
		super.addBrandId(brandId);
        return this;
    }

    public UploadImageTaskBundle addTargetId(String targetId) {
		super.addTargetId(targetId);
        return this;
    }

	public UploadImageTaskBundle addSwiftDomain(String swiftDomain) {
		super.addSwiftDomain(swiftDomain);
		return this;
	}

	public UploadImageTaskBundle addRestDomain(RestRequestParams restRequestParams) {
		super.addRestDomain(restRequestParams);
		return this;
	}

	public UploadImageTaskBundle addFileUri(Uri fileUri) {
		super.addFileUri(fileUri);
        return this;
    }

    public UploadImageTaskBundle addMessage(MaskedMessage maskedMessage) {
		super.addMessage(maskedMessage);
        return this;
    }


	public UploadImageTaskBundle addImageFromCamera(boolean imageFromCamera) {
		mImageFromCamera = imageFromCamera;
		return this;
	}

	public UploadImageTaskBundle build(int taskId, Context context){
        setTaskID(taskId);

        mFilePath = ImageUtils.getImagePath(context, mFileUri);

		// If the scheme of the file is 'content' (e.g. content://... - usually from gallery) we get the info from the content resolver
		if (ContentResolver.SCHEME_CONTENT.equals(mFileUri.getScheme())) {
			ContentResolver cR = context.getContentResolver();
			MimeTypeMap mime = MimeTypeMap.getSingleton();
			mFileContentType = cR.getType(mFileUri);
			if (mFileContentType != null) {
				String extensionFromMimeType = mime.getExtensionFromMimeType(mFileContentType);
				if (extensionFromMimeType != null) {
					mFileTypeExtension = extensionFromMimeType.toUpperCase();
				}
			}
		}
		else{ // The scheme is NOT 'content'. It means we have a file:// scheme (usually from camera) so we get the info from the file

			String fileExtensionFromUrl = MimeTypeMap.getFileExtensionFromUrl(mFileUri.toString());
			if (fileExtensionFromUrl != null) {
				mFileTypeExtension = fileExtensionFromUrl.toUpperCase();
			}

			if (mFileTypeExtension != null) {
				mFileContentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(mFileTypeExtension.toLowerCase());
			}
		}

		// We support only JPG and PNG image types, so if the imageTypeExtension is not one of those we change it to jpg
		if (!ImageUtils.JPG.equalsIgnoreCase(mFileTypeExtension) && !ImageUtils.PNG.equalsIgnoreCase(mFileTypeExtension)) {
			mFileTypeExtension = ImageUtils.JPG.toUpperCase();
		}
		if (ImageUtils.FILE_MIME_TYPE_GIF.equals(mFileContentType)) {
			mFileContentType = ImageUtils.FILE_MIME_TYPE_JPG;
		}

		return this;
	}

	public boolean isImageFromCamera() {
		return mImageFromCamera;
	}

}
