package com.liveperson.messaging.background.filesharing.voice;

import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.DownloadFileTask;
import com.liveperson.messaging.background.filesharing.DownloadFileTaskBundle;

public class DownloadVoiceTask extends DownloadFileTask {

	/**
	 * creating bitmaps (thumbnail and full size)
	 *
	 * @param params
	 */
	public DownloadVoiceTask(DownloadFileTaskBundle params) {
		super(params);
	}

	/**
	 * Save the voice file (given byteArray) to disk
	 * @param byteArray
	 * @return
	 */
	@Override
	protected String saveFileToDisk(byte[] byteArray) {

		return MessagingFactory.getInstance().getController().getAudioUtils().saveByteArrayToDisk(byteArray);
	}
}
