package com.liveperson.messaging.commands;

import androidx.annotation.NonNull;

import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.MessagingChatMessage;

public class SendDocumentCommand extends SendFileCommand {

    private String mPreviewContentType;
    /**
     * Creates a command for sending messages
     *
     * @param controller
     * @param targetId
     * @param brandId
     * @param contentType
     * @param thumbnailPath
     * @param filePath
     * @param fileTypeExtension
     * @param message
     */
    public SendDocumentCommand(Messaging controller, String targetId, String brandId, String contentType, String thumbnailPath, String filePath, String fileTypeExtension, MaskedMessage message, String previewContentType) {
        super(controller, targetId, brandId, contentType, thumbnailPath, filePath, fileTypeExtension, message);
        mPreviewContentType = previewContentType;
    }

    @NonNull
    protected MessagingChatMessage.MessageType getMessageType(MaskedMessage message) {
        return MessagingChatMessage.MessageType.CONSUMER_DOCUMENT;
    }

    public void setFileDetails(String relativePath, String fileType, String previewBase64){

        super.setFileDetails(relativePath, fileType, previewBase64);

        this.mPreview = "data:" + mPreviewContentType + ";base64,"+ previewBase64;

    }

}
