package com.liveperson.messaging.commands.tasks;

import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.model.SocketConnectionParams;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.controller.AccountsController;
import com.liveperson.messaging.controller.ClientProperties;
import com.liveperson.messaging.controller.ConnectionsController;
import com.liveperson.messaging.model.AmsConnection;
import com.liveperson.messaging.model.AmsConnectionAnalytics;

import java.util.List;

/**
 * Created by Ilya Gazman on 11/16/2015.
 * <p/>
 * Base connection task for opening socket connection
 */
public class OpenSocketTask extends BaseAmsAccountConnectionTask {

    public static final String AUTHORIZATION = "Authorization";
    private static final String TAG = "OpenSocketTask";
    private static final int SOCKET_TIMEOUT = 30000;
    public static final String CLIENT_PROPERTIES = "Client-Properties";
    public static final String JWT = "jwt %1$s";

    private final AccountsController mAccountsController;
    private final ConnectionsController mConnectionController;

    public OpenSocketTask(AccountsController accountsController, ConnectionsController connectionController) {
        mAccountsController = accountsController;
        mConnectionController = connectionController;
    }

    @Override
    public boolean requireSDKinForeground() {
        return true;
    }

    @Override
    public void execute() {

        AmsConnectionAnalytics.openSocketTaskStart();

        final String connectionUrl = mAccountsController.getConnectionUrl(mBrandId);
        final List<String> certificates = mAccountsController.getCertificatePinningKeys(mBrandId);
        final String token = mAccountsController.getToken(mBrandId);
        final ClientProperties clientProperties = mAccountsController.getClientProperties();

	    LPLog.INSTANCE.d(TAG, "Running open socket task. url = " + connectionUrl);

        AmsConnection.AmsSocketState socketState = mConnectionController.registerSocket(mBrandId);
        socketState.setCallback(mCallback);

       /* SocketManager.getInstance().registerToSocketState(connectionUrl, new SocketStateAdapter() {
            @Override
            public void onStateChanged(SocketStateManager.SocketState state) {
                LPMobileLog.i(TAG, "new socket state:" + state.name());
                switch (state) {
                    //TODO: other states?
                    case ERROR:
                    case CLOSED:
                        SocketManager.getInstance().unregisterFromSocketState(connectionUrl, this);
                        mConnectionController.unregisterSocketListener(mBrandId);
                        mCallback.onTaskError(TaskType.OPEN_SOCKET, new Exception("Dialog INIT"));
                        break;
                    case OPEN:
                        SocketManager.getInstance().unregisterFromSocketState(connectionUrl, this);
                        mCallback.onTaskSuccess();
                        break;
                }
            }
        });*/

        SocketConnectionParams connectionParams = new SocketConnectionParams(connectionUrl,SOCKET_TIMEOUT, certificates);
        connectionParams.addHeader(AUTHORIZATION, String.format(JWT, token)); //token
        connectionParams.addHeader(CLIENT_PROPERTIES, clientProperties.getJsonString(mAccountsController.isInUnAuthMode(mBrandId))); //clientProperties
        // connectionParams.addHeader("User-Agent", "Android"); // user-agent header
        //
        // User-Agent header was added due to internal request. However, it breaks client property
        // reporting desired by customers. If and when an internal request to re-include this header
        // comes in again, please make the requester define -exactly- what this header should look
        // like so as not to break the osVersion clientProperty included above.

		LPLog.INSTANCE.d(TAG, "execute: connectionParams headers: " + connectionParams.getHeaders());

		SocketManager.getInstance().connect(connectionParams);
    }

    @Override
    public String getName() {
        return TAG;
    }
}
