package com.liveperson.messaging.commands.tasks;

import android.text.TextUtils;

import com.liveperson.api.request.SubscribeExConversations;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.ResponseCallback;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.network.socket.requests.SubscribeExConversationsRequest;

/**
 * Created by shiranr on 19/11/2015.
 */
public class SubscribeExConversationsTask extends BaseAmsSocketConnectionTask {

    private static final String TAG = "SubscribeExConversationsTask";
    protected final Messaging mController;

    public SubscribeExConversationsTask(Messaging controller) {
        mController = controller;
    }

    @Override
    public void execute() {
        LPLog.INSTANCE.i(TAG, "Running SubscribeExConversation task...");

        String originatorId = mController.getOriginatorId(mBrandId);
        if(!TextUtils.isEmpty(originatorId)){

            long lastUpdateTime = mController.mConnectionController.getLastUpdateTime(mBrandId);
            long clockDiff = mController.mConnectionController.getClockDiff(mBrandId);

            long minLastUpdatedTime = lastUpdateTime == 0 ? 0 : (lastUpdateTime - clockDiff);

            SubscribeExConversationsRequest baseSocketRequest = new SubscribeExConversationsRequest(mController.mConnectionController, minLastUpdatedTime, mBrandId, mController.mAccountsController.getConnectionUrl(mBrandId), originatorId);
            baseSocketRequest.addCallback(new ResponseCallback<SubscribeExConversations.Response>() {
                @Override
                public void onSuccess(SubscribeExConversations.Response data) {
                    mCallback.onTaskSuccess();
                }

                @Override
                public void onError() {
                    mCallback.onTaskError(SocketTaskType.SUBSCRIBE, new Exception(TAG));
                }
            });
            SocketManager.getInstance().send(baseSocketRequest);
        }
    }
}
