package com.liveperson.messaging.network.socket.requests;

import android.text.TextUtils;

import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.GetUserProfile;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.MessagingUserProfile;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by Ilya Gazman on 11/10/2015.
 * <p/>
 * Request for creating or getting user profile
 */
public class GetUserProfileRequest extends BaseAMSSocketRequest<GetUserProfile.Response, GetUserProfileRequest> {

    private static final String TAG = "GetUserProfile";
    private final String mBrandId;
    private final Messaging mController;
    private String mUserId = "";
    private UserProfile.UserType mType;
    private String serverConversationId = "";

    public GetUserProfileRequest(Messaging controller, String brandId, UserProfile.UserType type) {
        super(controller.mAccountsController.getConnectionUrl(brandId));
        mController = controller;
        mBrandId = brandId;
        mType = type;
    }

    @Override
    protected String getData() {
        return new GetUserProfile(mUserId).toJsonString(getRequestId());
    }


    @Override
    protected String getRequestName() {
        return TAG;
    }


    @Override
    protected BaseResponseHandler<GetUserProfile.Response, GetUserProfileRequest> getResponseHandler() {
        return new BaseResponseHandler<GetUserProfile.Response, GetUserProfileRequest>() {

            @Override
            public String getAPIResponseType() {
                return GetUserProfile.Response.GET_USER_PROFILE_RESPONSE_TYPE;
            }

            @Override
            protected GetUserProfile.Response parse(JSONObject jsonObject) throws JSONException {
                return new GetUserProfile.Response(jsonObject);
            }

            @Override
            protected boolean handle(GetUserProfile.Response data) {
                data.getBody().setUserType(mType);
                //will send intent to update ui
                final MessagingUserProfile userProfile = new MessagingUserProfile(data.getBody());
                userProfile.setBrandID(mBrandId);
                mController.amsUsers.updateUserProfile(userProfile);

                if (mType == UserProfile.UserType.AGENT) {
                    mController.amsDialogs.queryDialogById(serverConversationId)
                            .setPostQueryOnBackground(data1 -> {
                                if (TextUtils.equals(data1.getAssignedAgentId(), mUserId) && data1.getState() == DialogState.OPEN) {
	                                LPLog.INSTANCE.d(TAG, "onResult: Calling agent details callback");
                                    mController.onAgentDetailsChanged(userProfile, data1.isOpen());
                                }
                                //update all massages that filtered by brand id.
                                //if we have open conversation with the assigned agent that we just got his profile -
                                //update also messages that filtered by conversationID.
	                            LPLog.INSTANCE.d(TAG, "got user details (" + LPLog.INSTANCE.mask(mUserId) + ") related to conversation: " + serverConversationId);
                                mController.amsMessages.updateAgentDetailsUpdated(serverConversationId);
                            }).execute();
                }
                return true;
            }
        };
    }
}
