/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.response.model;

import android.text.TextUtils;
import com.liveperson.api.response.model.CobrowseDialogData;
import com.liveperson.api.response.model.DialogData;
import org.json.JSONObject;

public abstract class MultiDialog {
    public ChannelType channelType = ChannelType.MESSAGING;

    protected MultiDialog() {
    }

    protected MultiDialog(JSONObject jsonObject) {
        ChannelType jsonChannelType = ChannelType.parse(jsonObject.optString("channelType"));
        if (ChannelType.COBROWSE == jsonChannelType) {
            this.channelType = ChannelType.COBROWSE;
        }
    }

    public ChannelType getType() {
        return this.channelType;
    }

    public static DialogData create(JSONObject jsonObject, String conversationId) {
        ChannelType jsonChannelType = ChannelType.parse(jsonObject.optString("channelType"));
        if (ChannelType.COBROWSE == jsonChannelType) {
            return new CobrowseDialogData(jsonObject, conversationId);
        }
        return new DialogData(jsonObject, conversationId);
    }

    public static DialogData create(JSONObject jsonObject) {
        return MultiDialog.create(jsonObject, null);
    }

    public static enum ChannelType {
        MESSAGING,
        COBROWSE;


        public static ChannelType parse(String channelTypeString) {
            ChannelType result = MESSAGING;
            if (!TextUtils.isEmpty((CharSequence)channelTypeString)) {
                ChannelType[] values;
                for (ChannelType dialogState : values = ChannelType.values()) {
                    if (!dialogState.name().equalsIgnoreCase(channelTypeString)) continue;
                    result = dialogState;
                }
            }
            return result;
        }
    }
}

