/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.content.ContentValues;
import android.database.Cursor;
import androidx.annotation.Nullable;
import com.liveperson.infra.database.BaseDBRepository;
import com.liveperson.infra.database.DataBaseCommand;
import com.liveperson.infra.database.DataBaseExecutor;
import com.liveperson.infra.database.tables.FilesTable;
import com.liveperson.infra.log.LPLog;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.model.FileMessage;
import java.util.ArrayList;

public class AmsFiles
extends BaseDBRepository {
    private static final String TAG = "AmsFiles";

    public AmsFiles() {
        super("files");
    }

    public DataBaseCommand<Long> addFile(long messageRowId, FileMessage fileMessage) {
        return new DataBaseCommand(() -> {
            LPLog.INSTANCE.d(TAG, "Adding file: " + fileMessage.getLocalUrl() + " type: " + fileMessage.getFileType());
            ContentValues filesValues = new ContentValues();
            filesValues.put("preview", fileMessage.getPreview());
            if (fileMessage.getLocalUrl() != null) {
                filesValues.put("localUrl", fileMessage.getLocalUrl());
                filesValues.put("localUrlTimestamp", Long.valueOf(System.currentTimeMillis()));
            }
            filesValues.put("fileType", fileMessage.getFileType());
            filesValues.put("loadStatus", Integer.valueOf(fileMessage.getLoadStatus().ordinal()));
            filesValues.put("swiftPath", fileMessage.getSwiftPath());
            filesValues.put("relatedMessageRowID", Long.valueOf(messageRowId));
            return this.getDB().insert(filesValues);
        });
    }

    public void updateRelativePath(Long fileRowId, String relativePath) {
        DataBaseExecutor.execute(() -> {
            ContentValues filesValues = new ContentValues();
            filesValues.put("swiftPath", relativePath);
            this.getDB().update(filesValues, "_id =? ", new String[]{String.valueOf(fileRowId)});
        });
    }

    public void updateStatus(long fileRowId, FilesTable.LoadStatus status) {
        DataBaseExecutor.execute(() -> {
            ContentValues filesValues = new ContentValues();
            filesValues.put("loadStatus", Integer.valueOf(status.ordinal()));
            this.getDB().update(filesValues, "_id =? ", new String[]{String.valueOf(fileRowId)});
            LPLog.INSTANCE.d(TAG, "updateStatus :" + status + " file:" + fileRowId);
        });
    }

    public DataBaseCommand<Void> updateLocalPath(long fileRowId, String path) {
        return new DataBaseCommand(() -> {
            ContentValues filesValues = new ContentValues();
            filesValues.put("localUrl", path);
            filesValues.put("localUrlTimestamp", Long.valueOf(System.currentTimeMillis()));
            this.getDB().update(filesValues, "_id =? ", new String[]{String.valueOf(fileRowId)});
            return null;
        });
    }

    public DataBaseCommand<ArrayList<String>> getMultipleOldestLocalPathFromDB(String targetId, int limit, @Nullable String fileTypesString) {
        return new DataBaseCommand(() -> {
            ArrayList<String> oldFileList = new ArrayList<String>();
            StringBuilder sb = new StringBuilder();
            sb.append("select ").append("localUrl").append(" from ").append("files").append(", ").append("messages").append(", ").append("dialogs").append(" where ").append("dialogs").append(".").append("target_id").append("=").append("'").append(targetId).append("'").append(" and ").append("localUrl").append(" <> '' ");
            if (fileTypesString != null) {
                sb.append(" and LOWER(").append("files").append(".").append("fileType").append(") in (").append(fileTypesString).append(") ");
            }
            sb.append(" and ").append("dialogs").append(".").append("dialog_id").append("=").append("messages").append(".").append("dialogId").append(" and ").append("files").append(".").append("relatedMessageRowID").append("=").append("messages").append(".").append("_id").append(" order by ").append("localUrlTimestamp").append(" limit ").append(limit).append(";");
            String sql = sb.toString();
            LPLog.INSTANCE.d(TAG, "query: " + sql);
            Cursor cursor = this.getDB().rawQuery(sql, new Object[0]);
            if (cursor != null) {
                try {
                    if (cursor.moveToFirst()) {
                        do {
                            String localUrl = cursor.getString(0);
                            LPLog.INSTANCE.d(TAG, "getMultipleOldestLocalPathFromDB: Add to list old file with local url: " + localUrl);
                            oldFileList.add(localUrl);
                        } while (cursor.moveToNext());
                    }
                }
                finally {
                    cursor.close();
                }
            }
            return oldFileList;
        });
    }

    public DataBaseCommand<Integer> removeLocalPathFromDB(String localUrl) {
        return new DataBaseCommand(() -> {
            LPLog.INSTANCE.d(TAG, "query: searching and removing localUrl: " + localUrl);
            ContentValues localPathValues = new ContentValues();
            localPathValues.put("localUrl", "");
            localPathValues.put("loadStatus", Integer.valueOf(FilesTable.LoadStatus.NOT_STARTED.ordinal()));
            FileMessage fileByLocalUrl = this.getFileByLocalUrl(localUrl);
            long messageRelatedRowId = -1L;
            if (fileByLocalUrl != null) {
                messageRelatedRowId = fileByLocalUrl.getRelatedMessageRowID();
            }
            int numOfRowsAffected = this.getDB().update(localPathValues, "localUrl=?", new String[]{localUrl});
            MessagingFactory.getInstance().getController().amsMessages.updateMessageFileChanged(messageRelatedRowId);
            LPLog.INSTANCE.d(TAG, "query: removed " + numOfRowsAffected + " records");
            return numOfRowsAffected;
        });
    }

    public DataBaseCommand<Integer> getNumOfLocalPathFromDB(String targetId, @Nullable String fileTypesString) {
        return new DataBaseCommand(() -> {
            int count = 0;
            StringBuilder sb = new StringBuilder();
            sb.append("select count(*) from ").append("files").append(", ").append("messages").append(", ").append("dialogs").append(" where ").append("dialogs").append(".").append("target_id").append("=").append("'").append(targetId).append("'").append(" and ").append("localUrl").append(" <> '' ");
            if (fileTypesString != null) {
                sb.append(" and LOWER(").append("files").append(".").append("fileType").append(") in (").append(fileTypesString).append(") ");
            }
            sb.append(" and ").append("dialogs").append(".").append("dialog_id").append("=").append("messages").append(".").append("dialogId").append(" and ").append("files").append(".").append("relatedMessageRowID").append("=").append("messages").append(".").append("_id");
            String sql = sb.toString();
            Cursor cursor = this.getDB().rawQuery(sql, new Object[0]);
            if (cursor != null) {
                try {
                    if (cursor.moveToFirst()) {
                        count = cursor.getInt(0);
                        LPLog.INSTANCE.d(TAG, "query: number of records with localUrl: " + count);
                    }
                }
                finally {
                    cursor.close();
                }
            }
            return count;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileMessage getFileByFileRowIdOnDbThread(long fileRowId) {
        Cursor cursor = this.getDB().rawQuery("SELECT * FROM files WHERE _id=? ", new Object[]{String.valueOf(fileRowId)});
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    FileMessage fileMessage = FileMessage.fromCursor(cursor);
                    return fileMessage;
                }
            }
            finally {
                cursor.close();
            }
        }
        return null;
    }

    public DataBaseCommand<FileMessage> getFileByFileRowId(long fileRowId) {
        return new DataBaseCommand(() -> this.getFileByFileRowIdOnDbThread(fileRowId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileMessage getFileByMessageRowId(long messageRowId) {
        Cursor cursor = this.getDB().rawQuery("SELECT * FROM files WHERE relatedMessageRowID=? ", new Object[]{String.valueOf(messageRowId)});
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    FileMessage fileMessage = FileMessage.fromCursor(cursor);
                    return fileMessage;
                }
            }
            finally {
                cursor.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileMessage getFileByLocalUrl(String localUrl) {
        Cursor cursor = this.getDB().query(null, "localUrl=? ", new String[]{localUrl}, null, null, null);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    FileMessage fileMessage = FileMessage.fromCursor(cursor);
                    return fileMessage;
                }
            }
            finally {
                cursor.close();
            }
        }
        return null;
    }
}

