/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import com.liveperson.api.response.types.DialogType;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.Infra;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDown;
import com.liveperson.infra.utils.LocalBroadcast;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.model.TimeBundle;

public class TTRManager
implements ShutDown,
Clearable {
    private static final String TAG = "TTRManager";
    private static final int MINIMUM_TIME = 60000;
    private static final String TILL_WHEN_OFF_HOURS = "TILL_WHEN_OFF_HOURS";
    private static final String TTR_VALUE = "TTR_VALUE";
    private static final String MANUAL_TTR = "MANUAL_TTR";
    private static final String EFFECTIVE_TTR = "EFFECTIVE_TTR";
    private static final String DELAY_TILL_WHEN = "DELAY_TILL_WHEN";
    private boolean firstTTRShown = false;
    private int mTtrFistTimeDelay;
    private long mNextTTRUpdate;
    private UpdateTTRRunnable updateTTRRunnable;
    private long mTillWhenOffHours;
    private int mTTRFrequency;
    private long mTTRValue;
    private long mManualTTR;
    private long mDelayTillWhen;
    private long mClockDiff;
    private String mTargetId;
    private long mEffectiveTTR;

    public TTRManager(String targetId) {
        this.mTargetId = targetId;
        this.mTillWhenOffHours = PreferenceManager.getInstance().getLongValue(TILL_WHEN_OFF_HOURS, targetId, -1L);
        this.mTTRValue = PreferenceManager.getInstance().getLongValue(TTR_VALUE, targetId, -1L);
        this.mDelayTillWhen = PreferenceManager.getInstance().getLongValue(DELAY_TILL_WHEN, targetId, -1L);
        this.mEffectiveTTR = PreferenceManager.getInstance().getLongValue(EFFECTIVE_TTR, targetId, -1L);
        this.mManualTTR = PreferenceManager.getInstance().getLongValue(MANUAL_TTR, targetId, -1L);
        LPLog.INSTANCE.d(TAG, "TTRManager: loaded data from preferences. ttrValue=" + this.mTTRValue + ", tillWhenOffHours=" + this.mTillWhenOffHours + ", delayTillWhen=" + this.mDelayTillWhen + ", effectiveTTR=" + this.mEffectiveTTR + ", manualTTR=" + this.mManualTTR);
        this.mTtrFistTimeDelay = Configuration.getInteger((int)R.integer.ttrFirstTimeDelaySeconds) * 1000;
        int ttrFrequencySeconds = Configuration.getInteger((int)R.integer.ttrShowFrequencyInSeconds);
        this.mTTRFrequency = ttrFrequencySeconds * 1000;
        LPLog.INSTANCE.d(TAG, "TTRManager: TTR frequency is: " + this.mTTRFrequency);
    }

    public long calculateEffectiveTTR(String targetId, long ttrValue, long manualTTR, long delayTillWhen, long clockDiff) {
        LPLog.INSTANCE.d(TAG, "calculateEffectiveTTR: targetId=" + targetId + ", ttrValue=" + ttrValue + ", manualTTR=" + manualTTR + " ,delayTillWhen=" + delayTillWhen + ", clockDiff=" + clockDiff);
        if (this.mEffectiveTTR > 0L && this.mManualTTR == manualTTR && this.mTTRValue == ttrValue && this.mDelayTillWhen == delayTillWhen) {
            return this.mEffectiveTTR;
        }
        this.mTTRValue = ttrValue;
        this.mManualTTR = manualTTR;
        this.mDelayTillWhen = delayTillWhen;
        this.mClockDiff = clockDiff;
        PreferenceManager.getInstance().setLongValue(TTR_VALUE, targetId, ttrValue);
        PreferenceManager.getInstance().setLongValue(MANUAL_TTR, targetId, manualTTR);
        PreferenceManager.getInstance().setLongValue(DELAY_TILL_WHEN, targetId, delayTillWhen);
        return this.calculateEffectiveTTR();
    }

    private long calculateEffectiveTTR() {
        LPLog.INSTANCE.d(TAG, "calculateEffectiveTTR: TTR updated, set to show TTR");
        long currentTime = System.currentTimeMillis();
        LPLog.INSTANCE.d(TAG, "calculateEffectiveTTR: currentTime: " + currentTime + ", clockDiff: " + this.mClockDiff);
        if (this.mManualTTR != -1L) {
            long calculatedManualTTR = this.mManualTTR + this.mClockDiff;
            LPLog.INSTANCE.d(TAG, "calculateEffectiveTTR: manualETTR is on (" + this.mManualTTR + "), return it + clockDiff: " + calculatedManualTTR);
            return calculatedManualTTR;
        }
        if (this.mTTRValue == -1L) {
            LPLog.INSTANCE.d(TAG, "calculateEffectiveTTR: ttrValue is -1");
            return -1L;
        }
        long delay = currentTime;
        if (this.mDelayTillWhen > 0L && this.mDelayTillWhen > currentTime) {
            delay = this.mDelayTillWhen + this.mClockDiff;
        }
        LPLog.INSTANCE.d(TAG, "calculateEffectiveTTR: ttrValue: " + this.mTTRValue + ", delay: " + delay + ". Total effectiveTTR: " + this.mTTRValue + delay);
        return this.mTTRValue + delay;
    }

    public void resetEffectiveTTR() {
        LPLog.INSTANCE.d(TAG, "resetEffectiveTTR: reset the effective TTR");
        this.mEffectiveTTR = -1L;
        PreferenceManager.getInstance().setLongValue(EFFECTIVE_TTR, this.mTargetId, -1L);
    }

    public void updateTTR(String targetId, long effectiveTTR) {
        if (this.isAutoMessagesEnabled(targetId)) {
            return;
        }
        if (this.isDuringPostSurveyDialog()) {
            return;
        }
        if (this.handleOffHours(targetId, this.mDelayTillWhen)) {
            LPLog.INSTANCE.d(TAG, "showTTR: we're in off hours");
        } else if (effectiveTTR > 0L && this.mEffectiveTTR != effectiveTTR) {
            this.mEffectiveTTR = effectiveTTR;
            PreferenceManager.getInstance().setLongValue(EFFECTIVE_TTR, targetId, effectiveTTR);
            long ttrDisplayDelay = this.getTTRDisplayDelayTime();
            LPLog.INSTANCE.d(TAG, "ttrDisplayDelay " + ttrDisplayDelay);
            if (ttrDisplayDelay >= 0L) {
                this.removeLastTTRCallback();
                this.updateTTRRunnable = new UpdateTTRRunnable(effectiveTTR, this.mClockDiff, targetId);
                Infra.instance.getApplicationHandler().postDelayed((Runnable)this.updateTTRRunnable, ttrDisplayDelay);
            }
        }
    }

    public void showTTR(String targetId) {
        LPLog.INSTANCE.d(TAG, "showTTR: start");
        if (this.isAutoMessagesEnabled(targetId)) {
            return;
        }
        if (this.isDuringPostSurveyDialog()) {
            return;
        }
        if (this.handleOffHours(targetId, this.mDelayTillWhen)) {
            LPLog.INSTANCE.d(TAG, "showTTR: we're in off hours");
        } else {
            LPLog.INSTANCE.d(TAG, "showTTR: showing TTR");
            if (this.mEffectiveTTR <= 0L) {
                LPLog.INSTANCE.d(TAG, "showTTR: effectiveTTR is < 0. Recalculate");
                this.mEffectiveTTR = this.calculateEffectiveTTR();
            }
            LPLog.INSTANCE.d(TAG, "showTTR: effectiveTTR = " + this.mEffectiveTTR);
            if (this.mEffectiveTTR > 0L) {
                long ttrDisplayDelay = this.getTTRDisplayDelayTime();
                LPLog.INSTANCE.d(TAG, "ttrDisplayDelay " + ttrDisplayDelay);
                if (ttrDisplayDelay >= 0L) {
                    this.removeLastTTRCallback();
                    this.updateTTRRunnable = new UpdateTTRRunnable(this.mEffectiveTTR, this.mClockDiff, targetId);
                    Infra.instance.getApplicationHandler().postDelayed((Runnable)this.updateTTRRunnable, ttrDisplayDelay);
                }
            }
        }
    }

    private boolean isAutoMessagesEnabled(String targetId) {
        if (MessagingFactory.getInstance().getController().mAccountsController.isAutoMessagesEnabled(targetId)) {
            LPLog.INSTANCE.d(TAG, "updateTTR: AutoMessages is enabled on this account (" + targetId + "). Disabling TTR and OfflineHours banner");
            return true;
        }
        return false;
    }

    private boolean isDuringPostSurveyDialog() {
        if (MessagingFactory.getInstance().getController().amsDialogs.getActiveDialog() != null && MessagingFactory.getInstance().getController().amsDialogs.getActiveDialog().getDialogType() == DialogType.POST_SURVEY) {
            LPLog.INSTANCE.d(TAG, "This is a post survey dialog. Disabling TTR and OfflineHours banner");
            return true;
        }
        return false;
    }

    private void removeLastTTRCallback() {
        Handler applicationHandler = Infra.instance.getApplicationHandler();
        if (applicationHandler != null) {
            applicationHandler.removeCallbacks((Runnable)this.updateTTRRunnable);
        }
    }

    private boolean handleOffHours(String targetId, long delayTillWhen) {
        boolean isInOffHours = false;
        long now = System.currentTimeMillis();
        if (delayTillWhen <= 0L || delayTillWhen < now) {
            if (this.inOffHours()) {
                LPLog.INSTANCE.d(TAG, "handleOffHours: not in off hours, delayTillWhen = " + delayTillWhen);
                this.mTillWhenOffHours = -1L;
                PreferenceManager.getInstance().setLongValue(TILL_WHEN_OFF_HOURS, targetId, -1L);
                this.cancelOffHours(targetId);
            }
        } else {
            LPLog.INSTANCE.d(TAG, "handleOffHours: in off hours, delayTillWhen = " + delayTillWhen + ", mTillWhenOffHours = " + this.mTillWhenOffHours);
            isInOffHours = true;
            boolean dateChanged = this.mTillWhenOffHours != delayTillWhen;
            this.mTillWhenOffHours = delayTillWhen;
            PreferenceManager.getInstance().setLongValue(TILL_WHEN_OFF_HOURS, targetId, delayTillWhen);
            this.sendUpdateIntent(targetId, delayTillWhen, dateChanged);
            if (!this.inOffHours()) {
                MessagingFactory.getInstance().getController().mEventsProxy.onOfflineHoursChanges(true);
            }
        }
        return isInOffHours;
    }

    private boolean inOffHours() {
        return this.mTillWhenOffHours > 0L;
    }

    public void updateIfOffHours(String targetId) {
        long tillWhenOffHours = PreferenceManager.getInstance().getLongValue(TILL_WHEN_OFF_HOURS, targetId, -1L);
        this.handleOffHours(targetId, tillWhenOffHours);
    }

    private void cancelOffHours(String targetId) {
        this.sendUpdateIntent(targetId, -1L, false);
        MessagingFactory.getInstance().getController().mEventsProxy.onOfflineHoursChanges(false);
    }

    private void sendUpdateIntent(String targetId, long realDelayTTR, boolean dateChanged) {
        Bundle bundle = new Bundle();
        bundle.putString("CONVERSATION_TARGET_ID", targetId);
        bundle.putLong(DELAY_TILL_WHEN, realDelayTTR);
        bundle.putBoolean("DELAY_TILL_WHEN_CHANGED", dateChanged);
        LocalBroadcast.sendBroadcast((String)"BROADCAST_UPDATE_CONVERSATION_OFF_HOURS", (Bundle)bundle);
    }

    private TimeBundle getTimeToRespondMilliseconds(long effectiveTTR, long clockDiff) {
        if ((effectiveTTR += clockDiff - System.currentTimeMillis()) < 60000L) {
            return null;
        }
        return new TimeBundle(effectiveTTR);
    }

    private long getTTRDisplayDelayTime() {
        long nextDelay;
        if (!this.firstTTRShown) {
            LPLog.INSTANCE.d(TAG, "TTR First message in the session");
            this.firstTTRShown = true;
            long startTime = System.currentTimeMillis();
            this.mNextTTRUpdate = startTime + (long)this.mTtrFistTimeDelay;
            nextDelay = this.mTtrFistTimeDelay;
        } else {
            nextDelay = -1L;
            long endTime = System.currentTimeMillis();
            long elapsedTime = endTime - this.mNextTTRUpdate;
            if (elapsedTime > 0L) {
                nextDelay = 0L;
                if (elapsedTime < (long)this.mTTRFrequency) {
                    return -1L;
                }
                this.mNextTTRUpdate = endTime;
            }
        }
        LPLog.INSTANCE.d(TAG, "TTR delay " + nextDelay);
        return nextDelay;
    }

    public void cancelAll() {
        this.removeLastTTRCallback();
        this.resetEffectiveTTR();
    }

    public void clear() {
        PreferenceManager.getInstance().setLongValue(TILL_WHEN_OFF_HOURS, this.mTargetId, -1L);
        PreferenceManager.getInstance().setLongValue(TTR_VALUE, this.mTargetId, -1L);
        PreferenceManager.getInstance().setLongValue(DELAY_TILL_WHEN, this.mTargetId, -1L);
        PreferenceManager.getInstance().setLongValue(EFFECTIVE_TTR, this.mTargetId, -1L);
        PreferenceManager.getInstance().setLongValue(MANUAL_TTR, this.mTargetId, -1L);
    }

    public void shutDown() {
        this.cancelAll();
    }

    private class UpdateTTRRunnable
    implements Runnable {
        private final long effectiveTTR;
        private final long clockDiff;
        private final String targetId;

        public UpdateTTRRunnable(long effectiveTTR, long clockDiff, String targetId) {
            this.effectiveTTR = effectiveTTR;
            this.clockDiff = clockDiff;
            this.targetId = targetId;
        }

        @Override
        public void run() {
            TimeBundle ttrBundle = TTRManager.this.getTimeToRespondMilliseconds(this.effectiveTTR, this.clockDiff);
            if (ttrBundle != null) {
                LPLog.INSTANCE.d(TTRManager.TAG, "TTR Days " + ttrBundle.diffDays);
                LPLog.INSTANCE.d(TTRManager.TAG, "TTR Hours " + ttrBundle.diffHours);
                LPLog.INSTANCE.d(TTRManager.TAG, "TTR Minutes " + ttrBundle.diffMinutes);
                Bundle bundle = new Bundle();
                bundle.putParcelable("CONVERSATION_TTR_TIME", (Parcelable)ttrBundle);
                bundle.putString("CONVERSATION_TARGET_ID", this.targetId);
                LocalBroadcast.sendBroadcast((String)"BROADCAST_UPDATE_CONVERSATION_TTR", (Bundle)bundle);
            } else {
                LPLog.INSTANCE.d(TTRManager.TAG, "Don't show TTR time is less than a minute");
            }
        }
    }
}

