/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket;

import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import com.liveperson.api.response.events.ExConversationChangeNotification;
import com.liveperson.api.response.model.Change;
import com.liveperson.api.response.model.CobrowseDialogData;
import com.liveperson.api.response.model.ConversationINCADetails;
import com.liveperson.api.response.model.ConversationUMSDetails;
import com.liveperson.api.response.model.DialogData;
import com.liveperson.api.response.model.MultiDialog;
import com.liveperson.api.response.model.Result;
import com.liveperson.api.response.model.UserProfile;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.api.sdk.LPConversationData;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.managers.PreferenceManager;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.infra.network.socket.BaseSocketRequest;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.infra.utils.DateUtils;
import com.liveperson.infra.utils.LocalBroadcast;
import com.liveperson.infra.utils.ThreadPoolExecutor;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.background.CoBrowseManager;
import com.liveperson.messaging.commands.BasicQueryMessagesCommand;
import com.liveperson.messaging.commands.QueryMessagesUMSCommand;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionCallback;
import com.liveperson.messaging.commands.tasks.FetchConversationManager;
import com.liveperson.messaging.model.AmsDialogs;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.model.ConversationData;
import com.liveperson.messaging.model.ConversationUtils;
import com.liveperson.messaging.model.Dialog;
import com.liveperson.messaging.model.DialogUtils;
import com.liveperson.messaging.network.MessageTimeoutQueue;
import com.liveperson.messaging.network.http.IncaGetConversationsListRequest;
import com.liveperson.messaging.network.http.QueryMessagesINCACommand;
import com.liveperson.messaging.network.socket.requests.SendMessageRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class ExConversationChangeNotificationResponseHandler
extends BaseResponseHandler<List<ConversationData>, BaseSocketRequest> {
    private static final String TAG = "ExConversationChangeNotificationResponseHandler";
    public static final String PREF_HIDE_CLOSED_CONVERSATIONS = "hide_closed_conversations";
    protected final Messaging mController;
    private ConversationUtils mConversationUtils;
    private DialogUtils mDialogUtils;
    private int mNumOpenConversations = 0;
    private int mNumCloseConversations = 0;
    private int mNumOfUpdatedConversations = 0;
    private boolean isFirstNotificationForBrand;
    private boolean isFirstNotificationAfterSubscribe;
    private String mBrandID;
    private String mSubscriptionId;
    private int queryMessageRequestCounter = 0;
    private boolean firstClosedConversation = true;
    private long mLastUpdateTime = 0L;

    public ExConversationChangeNotificationResponseHandler(Messaging messaging) {
        this.mController = messaging;
        this.init();
    }

    public String getAPIResponseType() {
        return "cqm.ExConversationChangeNotification";
    }

    protected void init() {
        this.mConversationUtils = new ConversationUtils(this.mController);
        this.mDialogUtils = new DialogUtils(this.mController);
    }

    protected List<ConversationData> parse(JSONObject jsonObject) {
        ExConversationChangeNotification responseBody = null;
        try {
            responseBody = new ExConversationChangeNotification(jsonObject);
        }
        catch (JSONException e) {
            LPLog.INSTANCE.d(TAG, "Exception parsing JSON: ", (Throwable)e);
        }
        ArrayList<ConversationData> conversations = new ArrayList<ConversationData>();
        if (responseBody != null) {
            this.mSubscriptionId = responseBody.notificationBody.getSubscriptionId();
            this.isFirstNotificationForBrand = this.mController.mConnectionController.isLastUpdateTimeExists(this.mSubscriptionId);
            this.mBrandID = this.mController.mConnectionController.getBrandIDForSubscription(responseBody.notificationBody.getSubscriptionId());
            this.mLastUpdateTime = this.mController.mConnectionController.getLastUpdateTime(this.mBrandID);
            this.mController.mConnectionController.setLastUpdateTime(responseBody.notificationBody.getSubscriptionId(), System.currentTimeMillis());
            this.isFirstNotificationAfterSubscribe = this.mController.mConnectionController.isFirstNotificationAfterSubscribe(this.mBrandID);
            this.mController.mConnectionController.setFirstNotificationAfterSubscribe(this.mBrandID, false);
            for (Change change : responseBody.notificationBody.getChanges()) {
                this.notifyDialogsStateChanges(change.result.conversationDetails);
                if (!this.isValidResponse(change.result) || !TextUtils.equals((CharSequence)"UPSERT", (CharSequence)change.type) && !TextUtils.equals((CharSequence)"DELETE", (CharSequence)change.type)) continue;
                Result result = change.result;
                if (result.conversationDetails.getState() == null) continue;
                ConversationState conversationState = result.conversationDetails.getState();
                switch (conversationState) {
                    case OPEN: {
                        ++this.mNumOpenConversations;
                        break;
                    }
                    case LOCKED: {
                        conversationState = ConversationState.CLOSE;
                    }
                    case CLOSE: {
                        if (TextUtils.equals((CharSequence)"DELETE", (CharSequence)change.type)) {
                            LPLog.INSTANCE.d(TAG, "Parsing CLOSE event with type DELETE - Setting PREF_HIDE_CLOSED_CONVERSATIONS shared preferences key to TRUE");
                            PreferenceManager.getInstance().setBooleanValue(PREF_HIDE_CLOSED_CONVERSATIONS, this.mBrandID, true);
                        } else if (TextUtils.equals((CharSequence)"UPSERT", (CharSequence)change.type) && PreferenceManager.getInstance().contains(PREF_HIDE_CLOSED_CONVERSATIONS, this.mBrandID)) {
                            LPLog.INSTANCE.d(TAG, "Parsing CLOSE event with type UPSERT - Clearing PREF_HIDE_CLOSED_CONVERSATIONS key from shared preferences");
                            PreferenceManager.getInstance().remove(PREF_HIDE_CLOSED_CONVERSATIONS, this.mBrandID);
                        }
                        ++this.mNumCloseConversations;
                    }
                }
                ConversationData conversationData = new ConversationData(conversationState, result, this.mBrandID);
                conversations.add(conversationData);
                for (DialogData dialog : conversationData.dialogs) {
                    if (dialog.channelType != MultiDialog.ChannelType.COBROWSE) continue;
                    CoBrowseManager.instance.cobrowseMessageReceived(this.mBrandID, this.mController, dialog, result, conversationData.getAssignedAgentId());
                }
            }
            Collections.sort(conversations);
        }
        return conversations;
    }

    private boolean isValidResponse(Result res) {
        return res != null && res.conversationDetails != null && !TextUtils.isEmpty((CharSequence)res.conversationId);
    }

    protected boolean handle(final List<ConversationData> umsConversations) {
        long startTo;
        if (this.mBrandID == null || this.mController.mConnectionController.getConnection(this.mBrandID) == null) {
            LPLog.INSTANCE.w(TAG, "handle: Cannot get connection for brand " + this.mBrandID + ". Exit handle");
            return true;
        }
        this.mNumOfUpdatedConversations = umsConversations.size();
        LPLog.INSTANCE.d(TAG, "umsConversations: " + umsConversations.toString());
        Conversation newestClosedConversation = this.mController.amsConversations.getNewestClosedConversation(this.mBrandID);
        long mostUpdatedDBTimeTS = newestClosedConversation == null ? this.mLastUpdateTime : newestClosedConversation.getEndTimestamp();
        long startFrom = newestClosedConversation == null ? 0L : newestClosedConversation.getStartTimestamp();
        long l = startTo = umsConversations.isEmpty() ? System.currentTimeMillis() : umsConversations.get((int)0).startTs;
        if (this.isFirstNotificationAfterSubscribe && !DateUtils.isInTheLast24hours((long)mostUpdatedDBTimeTS)) {
            for (ConversationData conv : umsConversations) {
                LPLog.INSTANCE.d("ums conversation list: ", conv.conversationId + " startTs: " + new Date(conv.startTs) + " ,  endTs: " + new Date(conv.endTs));
            }
            IncaGetConversationsListRequest moreConv = new IncaGetConversationsListRequest(this.mController, this.mBrandID, startFrom, startTo, 0L, new ICallback<ArrayList<ConversationINCADetails>, Exception>(){
                private static final String TAG = "IncaGetConversationsListRequest::ICallback";

                public void onSuccess(ArrayList<ConversationINCADetails> conversationHistoryResponse) {
                    ThreadPoolExecutor.execute(() -> {
                        ArrayList<ConversationData> incaConversations = new ArrayList<ConversationData>(conversationHistoryResponse.size());
                        for (ConversationINCADetails conv : conversationHistoryResponse) {
                            LPLog.INSTANCE.d(TAG, conv.conversationId + " startTs: " + new Date(conv.startTs) + " ,  endTs: " + new Date(conv.endTs));
                            ConversationData conversationData = new ConversationData(conv, ExConversationChangeNotificationResponseHandler.this.mBrandID);
                            incaConversations.add(conversationData);
                        }
                        LPLog.INSTANCE.d(TAG, "incaConversations: " + incaConversations);
                        ExConversationChangeNotificationResponseHandler.this.mNumOfUpdatedConversations = umsConversations.size() + incaConversations.size();
                        ExConversationChangeNotificationResponseHandler.this.fetchHistoryMessages(umsConversations, incaConversations);
                    });
                }

                public void onError(Exception exception) {
                    ThreadPoolExecutor.execute(() -> {
                        LPLog.INSTANCE.w(TAG, "Error while trying to receive conversation list from INCA. error: ", (Throwable)exception);
                        ExConversationChangeNotificationResponseHandler.this.fetchHistoryMessages(umsConversations, null);
                    });
                }
            });
            moreConv.execute();
        } else {
            this.fetchHistoryMessages(umsConversations, null);
        }
        return true;
    }

    private void fetchHistoryMessages(List<ConversationData> conversationsFromUMS, List<ConversationData> conversationsFromInca) {
        if (this.mBrandID == null || this.mController.mConnectionController.getConnection(this.mBrandID) == null) {
            LPLog.INSTANCE.w(TAG, "fetchHistoryMessages: Cannot get connection for brand " + this.mBrandID + ". Exit handle");
            return;
        }
        if (this.isFirstNotificationForBrand) {
            LPLog.INSTANCE.d(TAG, "Start FetchConversationManager - Got " + this.mNumOfUpdatedConversations + " conversations");
            this.getFetchConversationManager().fetchConversationsFirstTime(this.mBrandID, conversationsFromUMS, conversationsFromInca);
            this.saveLastUpdateTime();
        } else {
            LPLog.INSTANCE.d(TAG, "Start updateConversations - Got " + this.mNumOfUpdatedConversations + " conversations");
            if (this.mNumOfUpdatedConversations == 0) {
                this.onHandleConversationCompleted();
            } else {
                for (ConversationData conversationData : conversationsFromUMS) {
                    this.updateConversationAndDialogs(conversationData);
                }
                if (conversationsFromInca != null) {
                    for (ConversationData conversationData : conversationsFromInca) {
                        this.updateConversationAndDialogs(conversationData);
                    }
                }
            }
            this.subscribeToCurrentOpenDialogIfExists();
            if (conversationsFromUMS.size() == 0) {
                MessagingFactory.getInstance().getController().amsConversations.notifyOffHoursStatus(this.mBrandID);
            }
        }
    }

    private void subscribeToCurrentOpenDialogIfExists() {
        MessagingFactory.getInstance().getController().amsDialogs.queryActiveDialog(this.mBrandID).setPostQueryOnBackground(data -> {
            if (data != null) {
                int lastCurrentSequence = data.getLastServerSequence();
                if (lastCurrentSequence == -1) {
                    lastCurrentSequence = 0;
                }
                this.mController.getMessagingEventSubscriptionManager().addSubscription(this.mController, this.mBrandID, data.getConversationId(), data.getDialogId(), lastCurrentSequence, true);
            }
        }).execute();
    }

    private void notifyDialogsStateChanges(ConversationUMSDetails details) {
        if (details != null) {
            for (DialogData dialog : details.dialogs) {
                if (!MultiDialog.ChannelType.COBROWSE.equals((Object)dialog.getType())) continue;
                Bundle bundle = new Bundle();
                bundle.putString("message", ((CobrowseDialogData)dialog).metaData);
                LocalBroadcast.sendBroadcast((String)"LPMessagingDialog\\COBROWSE", (Bundle)bundle);
            }
        }
    }

    @NonNull
    private FetchConversationManager getFetchConversationManager() {
        return new FetchConversationManager(this.mController);
    }

    private void updateConversationAndDialogs(ConversationData data) {
        Dialog currentDialog = null;
        switch (data.state) {
            case CLOSE: {
                currentDialog = this.mController.amsDialogs.getActiveDialog();
                LPLog.INSTANCE.d(TAG, "Closing conversation : " + data.conversationId + ", firstClosedConversation = " + this.firstClosedConversation + ", mNumCloseConversations = " + this.mNumCloseConversations + ", mNumOpenConversations = " + this.mNumOpenConversations);
                boolean shouldUpdateUI = false;
                if (this.firstClosedConversation) {
                    this.firstClosedConversation = false;
                    shouldUpdateUI = true;
                }
                this.updateClosedConversation(data, shouldUpdateUI);
                break;
            }
            case OPEN: {
                currentDialog = this.mController.amsDialogs.getActiveDialog();
                ArrayList<Dialog> umsDialogs = AmsDialogs.extractDialogs(data);
                if (currentDialog != null && data.conversationId.equals(currentDialog.getConversationId())) {
                    Dialog dialogToOpen = null;
                    block8: for (Dialog umsDialog : umsDialogs) {
                        DialogState umsDialogState = umsDialog.getState();
                        Dialog localDialog = this.mController.amsDialogs.getDialogById(umsDialog.getDialogId());
                        if (localDialog == null && umsDialogState == DialogState.OPEN) {
                            if (dialogToOpen != null) {
                                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000BD, "Can't be! There are too many open dialogs in the same conversation");
                            }
                            dialogToOpen = umsDialog;
                        }
                        if (localDialog == null || localDialog.getState() == umsDialogState) continue;
                        switch (umsDialogState) {
                            case CLOSE: {
                                this.updateClosedDialog(data, umsDialog, !this.firstClosedConversation);
                                continue block8;
                            }
                            case OPEN: {
                                if (dialogToOpen != null) {
                                    LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000BE, "Can't be! There are too many open dialogs in the same conversation");
                                }
                                dialogToOpen = umsDialog;
                                continue block8;
                            }
                        }
                        LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000BF, "This scenario can't occur! conversation data: " + LPLog.INSTANCE.mask((Object)data));
                    }
                    if (dialogToOpen != null) {
                        if (dialogToOpen.getChannelType().equals((Object)MultiDialog.ChannelType.COBROWSE)) {
                            dialogToOpen.setState(DialogState.CLOSE);
                        }
                        this.openDialog(dialogToOpen, data.source);
                        this.mController.amsDialogs.setActiveDialog(dialogToOpen);
                    }
                    LPLog.INSTANCE.d(TAG, "Updating current conversation TTR In DB . conversation id = " + data.conversationId);
                    this.queryMessages(currentDialog, data.source);
                    this.checkUpdatedOnAssignedAgent(data, currentDialog);
                    this.mController.amsConversations.updateCurrentConversation(data);
                    this.mController.amsDialogs.updateDialogs(data);
                    long effectiveTTR = this.mConversationUtils.calculateEffectiveTTR(data.brandId, data.ttrValue, data.manualTTR, data.delayTillWhen);
                    this.mConversationUtils.updateTTR(data.conversationTTRType, effectiveTTR, data.targetId);
                    break;
                }
                LPLog.INSTANCE.i(TAG, "New conversation! id = " + data.conversationId + ", time = " + data.startTs);
                this.createNewConversation(data);
            }
        }
        if (currentDialog == null) {
            currentDialog = this.mController.amsDialogs.getActiveDialog();
        }
        if (currentDialog != null) {
            String dialogId = currentDialog.getDialogId();
            this.mDialogUtils.updateParticipants(data.targetId, data.participants.ASSIGNED_AGENT, UserProfile.UserType.AGENT, dialogId, true, false);
            this.mDialogUtils.updateParticipants(data.targetId, data.participants.AGENTS, UserProfile.UserType.AGENT, dialogId, true, false);
            this.mDialogUtils.updateParticipants(data.targetId, data.participants.MANAGER, UserProfile.UserType.AGENT, dialogId, true, false);
            this.mDialogUtils.updateParticipants(data.targetId, data.participants.READER, UserProfile.UserType.AGENT, dialogId, true, false);
            this.mDialogUtils.updateParticipants(data.targetId, data.participants.CONTROLLER, UserProfile.UserType.CONTROLLER, dialogId, true, false);
        } else {
            String conversationId = data.conversationId;
            this.mConversationUtils.updateParticipants(data.targetId, data.participants.ASSIGNED_AGENT, UserProfile.UserType.AGENT, conversationId, true, false);
            this.mConversationUtils.updateParticipants(data.targetId, data.participants.AGENTS, UserProfile.UserType.AGENT, conversationId, true, false);
            this.mConversationUtils.updateParticipants(data.targetId, data.participants.MANAGER, UserProfile.UserType.AGENT, conversationId, true, false);
            this.mConversationUtils.updateParticipants(data.targetId, data.participants.READER, UserProfile.UserType.AGENT, conversationId, true, false);
            this.mConversationUtils.updateParticipants(data.targetId, data.participants.CONTROLLER, UserProfile.UserType.CONTROLLER, conversationId, true, false);
        }
    }

    private void openDialog(Dialog dialogToOpen, FetchConversationManager.DATA_SOURCE dataSource) {
        this.mDialogUtils.updateParticipants(dialogToOpen.getTargetId(), new String[]{dialogToOpen.getAssignedAgentId()}, UserProfile.UserType.AGENT, dialogToOpen.getDialogId(), true, true);
        this.mController.amsDialogs.createNewCurrentDialog(dialogToOpen);
        this.queryMessages(dialogToOpen, dataSource);
    }

    private void onHandleConversationCompleted() {
        --this.mNumOfUpdatedConversations;
        LPLog.INSTANCE.d(TAG, "onHandleConversationCompleted, mNumOfUpdatedConversations = " + this.mNumOfUpdatedConversations + ", queryMessageRequestCounter:" + this.queryMessageRequestCounter);
        if (this.mNumOfUpdatedConversations <= 0) {
            this.saveLastUpdateTime();
            if (this.queryMessageRequestCounter == 0) {
                this.updateHandledExConversationCompleted();
            }
        }
    }

    private void updateHandledExConversationCompleted() {
        this.mController.mConnectionController.getConnection(this.mBrandID).setIsUpdated(true);
        this.mController.amsMessages.updateHandledExConversation(this.mNumOfUpdatedConversations <= 0);
    }

    private void saveLastUpdateTime() {
        LPLog.INSTANCE.d(TAG, "Saving last notification update for mSubscriptionId:" + this.mSubscriptionId);
        this.mController.mConnectionController.setLastUpdateTime(this.mSubscriptionId, System.currentTimeMillis());
    }

    private void createNewConversation(ConversationData data) {
        Long requestId = this.mController.amsConversations.dequeuePendingConversationRequestId();
        if (requestId != null) {
            ConversationData conversationData = new ConversationData();
            conversationData.requestId = requestId;
            conversationData.conversationId = data.conversationId;
            conversationData.targetId = data.targetId;
            conversationData.conversationTTRType = data.conversationTTRType;
            conversationData.state = ConversationState.OPEN;
            if (data.dialogs[0] != null) {
                conversationData.startTs = data.dialogs[0].creationTs;
            }
            LPLog.INSTANCE.d(TAG, "new conversation created. " + conversationData.conversationId);
            this.mController.amsConversations.updateCurrentConversationServerID(conversationData).setPostQueryOnBackground(conversation -> {
                this.mController.amsConversations.deleteTempConversationServerID().executeSynchronously();
                Dialog dialog = (Dialog)this.mController.amsDialogs.updateCurrentDialogServerId(conversationData).executeSynchronously();
                String dialogId = dialog.getDialogId();
                String conversationId = dialog.getConversationId();
                this.mController.amsMessages.updateMessagesDialogServerID(dialogId).executeSynchronously();
                this.mController.amsDialogs.deleteDialogById().executeSynchronously();
                LPLog.INSTANCE.d(TAG, "Finished updating messages with server id");
                for (SendMessageRequest sendMessageRequest : dialog.getPendingData().getPendingMessages()) {
                    LPLog.INSTANCE.d(TAG, "Finished updating messages with server id, message: " + LPLog.INSTANCE.mask((Object)sendMessageRequest));
                    sendMessageRequest.setDialogId(dialogId).setConversationId(conversationId);
                    SocketManager.getInstance().send((BaseSocketRequest)sendMessageRequest);
                    this.mController.amsMessages.mMessageTimeoutQueue.add(MessageTimeoutQueue.MessageType.PUBLISH, (int)sendMessageRequest.getRequestId(), this.mBrandID, dialogId, sendMessageRequest.getEventId());
                }
            }).execute();
            LPConversationData convData = new LPConversationData(conversationData.conversationId);
            convData.setCloseReason(null);
            this.mController.mEventsProxy.onConversationStarted(convData);
        } else {
            ArrayList<Dialog> dialogs;
            Conversation conversation2 = this.mController.amsConversations.createNewCurrentConversation(data);
            LPLog.INSTANCE.d(TAG, "We have new Current Dialog! " + conversation2.getConversationId() + ". Sending request to query messages and update assigned agent details");
            if (!TextUtils.isEmpty((CharSequence)data.getAssignedAgentId())) {
                this.mConversationUtils.updateParticipants(data.targetId, new String[]{data.getAssignedAgentId()}, UserProfile.UserType.AGENT, conversation2.getConversationId(), true, true);
            }
            if (!(dialogs = AmsDialogs.extractDialogs(data)).isEmpty()) {
                for (Dialog dialog : dialogs) {
                    this.openDialog(dialog, data.source);
                }
                Dialog openDialog = AmsDialogs.getOpenDialog(dialogs);
                if (openDialog != null) {
                    this.mController.amsDialogs.setActiveDialog(openDialog);
                }
            } else {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000C0, "Conversation data has no dialogs!  conversationData: " + LPLog.INSTANCE.mask((Object)data));
            }
            long effectiveTTR = this.mConversationUtils.calculateEffectiveTTR(data.brandId, data.ttrValue, data.manualTTR, data.delayTillWhen);
            this.mConversationUtils.updateTTR(data.conversationTTRType, effectiveTTR, data.targetId);
            LPConversationData convData = new LPConversationData(data.conversationId);
            convData.setCloseReason(null);
            this.mController.mEventsProxy.onConversationStarted(convData);
        }
    }

    private void updateClosedConversation(ConversationData data, boolean shouldUpdateUI) {
        String assignedAgentId = data.getAssignedAgentId();
        ArrayList dialogs = new ArrayList();
        Dialog activeDialog = this.mController.amsDialogs.getActiveDialog();
        if (activeDialog != null && activeDialog.getConversationId().equals(data.conversationId)) {
            this.mController.amsDialogs.closeActiveDialog();
        }
        HashMap<String, Dialog> dialogsFromData = AmsDialogs.extractDialogsToMap(data);
        this.mController.amsConversations.updateClosedConversation(data, shouldUpdateUI).setPreQueryOnBackground(() -> {
            ArrayList _dialogs = (ArrayList)this.mController.amsDialogs.queryDialogsByConversationId(data.conversationId).executeSynchronously();
            dialogs.addAll(_dialogs);
            for (Dialog dialog : dialogsFromData.values()) {
                if (dialogs.contains(dialog)) continue;
                dialogs.add(dialog);
                dialog.setState(DialogState.OPEN);
            }
            for (Dialog dialog : dialogs) {
                this.checkUpdatedOnAssignedAgent(data, dialog);
            }
        }).setPostQueryOnBackground(conversation -> {
            if (conversation != null) {
                for (Dialog dialog : dialogs) {
                    if (dialog.getState() == DialogState.CLOSE) continue;
                    Dialog dialogFromData = (Dialog)dialogsFromData.get(dialog.getDialogId());
                    if (dialogFromData != null && dialogFromData != dialog) {
                        dialog.setEndTimestamp(dialogFromData.getEndTimestamp());
                        dialog.setCloseReason(dialogFromData.getCloseReason());
                    }
                    dialog.setAssignedAgentId(assignedAgentId);
                    Dialog dialogResult = (Dialog)this.mController.amsDialogs.updateClosedDialog(data, dialog, shouldUpdateUI).executeSynchronously();
                    LPLog.INSTANCE.d(TAG, "Updated closed dialog: " + dialogResult.getDialogId());
                    this.queryMessages(dialog, data.source);
                    this.getFetchConversationManager().refreshPendingConversation(dialog.getConversationId());
                    this.mDialogUtils.addClosedDialogDivider(data.brandId, dialog, assignedAgentId, data.closeReason, true, null);
                }
                String assignedAgentId1 = data.getAssignedAgentId();
                this.mConversationUtils.updateParticipants(data.targetId, new String[]{assignedAgentId1}, UserProfile.UserType.AGENT, data.conversationId, true, false);
            } else {
                this.onHandleConversationCompleted();
            }
        }).setPostQueryOnUI(dialog -> {
            Conversation conversation;
            if (dialog != null && (conversation = (Conversation)this.mController.amsConversations.getConversationById(dialog.getBrandId(), dialog.getConversationId()).executeSynchronously()) != null && conversation.getState() == ConversationState.CLOSE) {
                LPConversationData convData = new LPConversationData(dialog.getConversationId());
                convData.setCloseReason(dialog.getCloseReason());
                this.mController.mEventsProxy.onConversationResolved(convData);
            }
        }).execute();
    }

    private void updateClosedDialog(ConversationData data, Dialog dialog, boolean shouldUpdateUI) {
        if (dialog.isOpen() || dialog.getChannelType() == MultiDialog.ChannelType.COBROWSE) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000C1, "Cannot close a closed dialog");
            return;
        }
        String assignedAgentId = dialog.getAssignedAgentId();
        this.mController.amsDialogs.updateClosedDialog(data, dialog, shouldUpdateUI).setPreQueryOnBackground(() -> this.checkUpdatedOnAssignedAgent(data, dialog)).setPostQueryOnBackground(queryDialogResult -> {
            if (queryDialogResult != null) {
                dialog.setAssignedAgentId(assignedAgentId);
                LPLog.INSTANCE.d(TAG, "Updating closed dialog. " + queryDialogResult.getDialogId());
                this.queryMessages((Dialog)queryDialogResult, data.source);
                this.mDialogUtils.addClosedDialogDivider(data.targetId, (Dialog)queryDialogResult, assignedAgentId, dialog.getCloseReason(), true, null);
                this.mDialogUtils.updateParticipants(data.targetId, new String[]{assignedAgentId}, UserProfile.UserType.AGENT, data.conversationId, true, false);
            } else {
                this.onHandleConversationCompleted();
            }
        }).setPostQueryOnUI(dialog1 -> {
            Conversation conversation;
            if (dialog1 != null && (conversation = (Conversation)this.mController.amsConversations.getConversationById(dialog1.getBrandId(), dialog1.getConversationId()).executeSynchronously()) != null && conversation.getState() == ConversationState.CLOSE) {
                LPConversationData convData = new LPConversationData(dialog1.getConversationId());
                convData.setCloseReason(dialog1.getCloseReason());
                this.mController.mEventsProxy.onConversationResolved(convData);
            }
        }).execute();
    }

    private void queryMessages(Dialog dialog, FetchConversationManager.DATA_SOURCE source) {
        LPLog.INSTANCE.d(TAG, "There are some unread messages for conversationId " + dialog.getConversationId() + ", dialogId: " + dialog.getDialogId() + " Current last message sequence in db = " + dialog.getLastServerSequence());
        LPLog.INSTANCE.d(TAG, "Sending request to query unread messages... newer than sequence: " + dialog.getLastServerSequence() + " source = " + (Object)((Object)source));
        BasicQueryMessagesCommand command = null;
        switch (source) {
            case UMS: {
                LPLog.INSTANCE.d(TAG, "queryMessages UMS: query for dialogId: " + dialog.getDialogId() + ", conversationId: " + dialog.getConversationId());
                command = new QueryMessagesUMSCommand(this.mController, this.mBrandID, dialog.getConversationId(), dialog.getDialogId(), dialog.getLastServerSequence(), true);
                break;
            }
            case INCA: {
                LPLog.INSTANCE.d(TAG, "queryMessages INCA: query for dialogId: " + dialog.getDialogId() + ", conversationId: " + dialog.getConversationId());
                command = new QueryMessagesINCACommand(this.mController, dialog.getBrandId(), dialog.getConversationId(), dialog.getDialogId(), true);
            }
        }
        ++this.queryMessageRequestCounter;
        command.setResponseCallBack(new BaseAmsSocketConnectionCallback(){

            @Override
            public void onTaskSuccess() {
                ExConversationChangeNotificationResponseHandler.this.queryMessageRequestCounter--;
                ExConversationChangeNotificationResponseHandler.this.onHandleConversationCompleted();
            }

            @Override
            public void onTaskError(SocketTaskType type, Throwable exception) {
            }
        });
        command.execute();
    }

    private void checkUpdatedOnAssignedAgent(ConversationData data, Dialog currentDialog) {
        if (this.isNewAssignedAgent(data, currentDialog) || this.isNewEmptyAssignedAgent(data, currentDialog) || this.isReplaceAssignedAgent(data, currentDialog)) {
            String assignedAgent;
            String assignedAgentId = data.getAssignedAgentId();
            if (TextUtils.isEmpty((CharSequence)assignedAgentId)) {
                LPLog.INSTANCE.i(TAG, "Assigned agent for conversation " + data.conversationId + " was cleared");
                assignedAgent = null;
            } else {
                LPLog.INSTANCE.i(TAG, "new Assigned agent for conversation " + data.conversationId);
                assignedAgent = assignedAgentId;
            }
            this.mDialogUtils.updateParticipants(data.targetId, new String[]{assignedAgent}, UserProfile.UserType.AGENT, currentDialog.getDialogId(), true, true);
        }
    }

    private boolean isNewAssignedAgent(ConversationData data, Dialog currentDialog) {
        return TextUtils.isEmpty((CharSequence)data.getAssignedAgentId()) && !TextUtils.isEmpty((CharSequence)currentDialog.getAssignedAgentId());
    }

    private boolean isNewEmptyAssignedAgent(ConversationData data, Dialog currentDialog) {
        return !TextUtils.isEmpty((CharSequence)data.getAssignedAgentId()) && TextUtils.isEmpty((CharSequence)currentDialog.getAssignedAgentId());
    }

    private boolean isReplaceAssignedAgent(ConversationData data, Dialog currentDialog) {
        return currentDialog.getAssignedAgentId() != null && data.getAssignedAgentId() != null && !currentDialog.getAssignedAgentId().equals(data.getAssignedAgentId());
    }
}

