package com.liveperson.messaging.background;

import android.graphics.Bitmap;
import androidx.annotation.NonNull;

import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.filesharing.image.ReUploadImageTaskBundle;
import com.liveperson.messaging.commands.ReSendImageCommand;
import com.liveperson.messaging.exception.FileSharingException;

/**
 * Created by shiranr on 7/24/16.
 */
public class ReUploadImageTask extends UploadImageTask {

    private static final String TAG = "ReUploadImageTask";

    /**
     * creating bitmaps (thumbnail and full size)
     *
     * @param params
     */
    public ReUploadImageTask(ReUploadImageTaskBundle params, Integer uploadTimeout) throws FileSharingException {
        super(params, uploadTimeout);

        mFileRowId = params.getFileRowId();
        LPLog.INSTANCE.d(TAG + Thread.currentThread(), "imageTypeExtension = " + uploadImageTaskParams.getFileTypeExtension() + ", imageContentType = " + uploadImageTaskParams.getFileContentType());
    }

    @NonNull
    @Override
    protected Bitmap processOriginalImage(int orientation, boolean fromCamera) {
        Bitmap originalBitmap = ImageUtils.getBitmap(uploadImageTaskParams.getFilePath());
        LPLog.INSTANCE.d(TAG + Thread.currentThread(), "originalBitmap size (w, h): " + originalBitmap.getWidth() + ", " + originalBitmap.getHeight());
        return originalBitmap;
    }

    @NonNull
    @Override
    protected String saveOriginalImage(Bitmap originalBitmap) {
        // Create a byte array of the image. If the image is NOT from the camera, save it to local folder
        createOriginalImageByteArray(originalBitmap, uploadImageTaskParams.getFileTypeExtension());
        return uploadImageTaskParams.getFilePath();
    }

    @NonNull
    @Override
    protected Bitmap processThumbnailImage(int orientation, boolean fromCamera) {
        return ImageUtils.getBitmap(((ReUploadImageTaskBundle) uploadImageTaskParams).getThumbnailLocalPath());
    }

    @NonNull
    @Override
    protected String saveThumbnailImage(Bitmap thumbnailBitmap) {

        byte [] thumbnailByteArray = ImageUtils.getOutputStreamFromBitmap(thumbnailBitmap, 100, uploadImageTaskParams.getFileTypeExtension());
        // If thumbnail was not created successfully return null
        if (thumbnailByteArray == null) {
            return null;
            //TODO: investigate is it possible to return null.
        }
        // Encode thumbnail's base64 string
        mBase64 = ImageUtils.bitmapToBase64(thumbnailByteArray);
        LPLog.INSTANCE.d(TAG + Thread.currentThread(), "processThumbnailImage: Thumbnail Base64: " + mBase64);
        return ((ReUploadImageTaskBundle) uploadImageTaskParams).getThumbnailLocalPath();
    }

    protected void createSendMessageCommand(String thumbnailPath, String fullImagePath)  {

        sendMessageCommand = new ReSendImageCommand(MessagingFactory.getInstance().getController(),
                uploadImageTaskParams.getTargetId(),
                uploadImageTaskParams.getBrandId(),
                uploadImageTaskParams.getFileContentType(),
                thumbnailPath,
                fullImagePath,
                uploadImageTaskParams.getFileTypeExtension(),
                ((ReUploadImageTaskBundle) uploadImageTaskParams).getEventId(),
                uploadImageTaskParams.getMessage(),
                ((ReUploadImageTaskBundle) uploadImageTaskParams).getFileRowId());

        setSendMessageCommandCallback();
    }


}
