/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.background;

import android.app.Notification;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.IBinder;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.handler.NotificationHandler;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.messaging.MessagingFactory;

public class BackgroundActionsService
extends Service {
    private static final String TAG = "BackgroundActionsService";
    private static final String FOREGROUND_SERVICE_PERMISSION = "android.permission.FOREGROUND_SERVICE";
    public static final String EXTRA_ACTION_TYPE = "extra_action_type";
    public static final String EXTRA_FILE_TYPE = "extra_file_type";
    public static final int EXTRA_ACTION_TYPE_UPLOAD = 1;
    public static final int EXTRA_TYPE_ACTION_DOWNLOAD = 2;
    public static final int EXTRA_TYPE_ACTION_REUPLOAD = 3;
    private static final int ONGOING_NOTIFICATION_ID = 17;
    private ServiceActioner mServiceActioner;
    private final ServiceActionCallbackListener mServiceActionCallbackListener = new ServiceActionCallbackListener(){

        @Override
        public void onSuccess(String brandId) {
            if (BackgroundActionsService.this.mServiceActioner != null) {
                if (!BackgroundActionsService.this.mServiceActioner.isPendingActions()) {
                    LPLog.INSTANCE.d(BackgroundActionsService.TAG, "onSuccess: all service actions are done. Stop service");
                    BackgroundActionsService.this.stopSelf();
                    BackgroundActionsService.this.serviceIsOff(brandId);
                } else {
                    LPLog.INSTANCE.d(BackgroundActionsService.TAG, "onSuccess: there are still pending service actions. Service still running...");
                }
            }
        }

        @Override
        public void onFail(String brandId) {
            if (BackgroundActionsService.this.mServiceActioner != null) {
                if (!BackgroundActionsService.this.mServiceActioner.isPendingActions()) {
                    LPLog.INSTANCE.d(BackgroundActionsService.TAG, "onFail: all service actions are done. Stop service");
                    BackgroundActionsService.this.stopSelf();
                    BackgroundActionsService.this.serviceIsOff(brandId);
                } else {
                    LPLog.INSTANCE.d(BackgroundActionsService.TAG, "onFail: there are still pending service actions. Service still running...");
                }
            }
        }
    };

    public int onStartCommand(Intent intent, int flags, int startId) {
        int type = intent.getIntExtra(EXTRA_ACTION_TYPE, -1);
        if (type == -1) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000009D, "onStartCommand: Error getting type. aborting");
            return 2;
        }
        this.mServiceActioner = MessagingFactory.getInstance().getController().getFileSharingManager();
        if (!(this.mServiceActioner instanceof ServiceActioner)) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000009E, "onStartCommand: FileSharingManager does not implement ServiceActioner");
            return 2;
        }
        if (Build.VERSION.SDK_INT < 28 || ContextCompat.checkSelfPermission((Context)this.getApplicationContext(), (String)FOREGROUND_SERVICE_PERMISSION) == 0) {
            switch (type) {
                case 1: {
                    LPLog.INSTANCE.d(TAG, "onStartCommand: got new file upload command through service");
                    this.setForeground(true);
                    break;
                }
                case 2: {
                    LPLog.INSTANCE.d(TAG, "onStartCommand: got new file download command through service");
                    this.setForeground(false);
                    break;
                }
                case 3: {
                    LPLog.INSTANCE.d(TAG, "onStartCommand: got new file re-upload command through service");
                    this.setForeground(true);
                }
            }
        } else {
            LPLog.INSTANCE.w(TAG, "permission android.permission.FOREGROUND_SERVICE not granted.");
        }
        String brandId = intent.getStringExtra("service_extra_brand_id");
        this.serviceIsUp(brandId);
        this.mServiceActioner.actionFromService(intent, this.mServiceActionCallbackListener);
        return 2;
    }

    private void setForeground(boolean upload) {
        Notification.Builder builder = this.getNotificationBuilder(upload);
        Notification notification = builder.build();
        this.startForeground(17, notification);
    }

    private PendingIntent getPendingIntent() {
        return MessagingFactory.getInstance().getController().getImageServicePendingIntent();
    }

    private Notification.Builder getNotificationBuilder(boolean upload) {
        Notification.Builder builder;
        Notification.Builder builder2 = builder = upload ? MessagingFactory.getInstance().getController().getImageForegroundServiceUploadNotificationBuilder() : MessagingFactory.getInstance().getController().getImageForegroundServiceDownloadNotificationBuilder();
        if (builder == null) {
            builder = this.getDefaultNotificationBuilder(upload);
        }
        return builder;
    }

    private Notification.Builder getDefaultNotificationBuilder(boolean upload) {
        String title;
        int icon;
        if (upload) {
            icon = 0x1080088;
            title = this.getString(R.string.uploading_image);
        } else {
            icon = 0x1080081;
            title = this.getString(R.string.downloading_image);
        }
        return new NotificationHandler((Context)this, title, null).setIconResourceId(icon).setPendingIntent(this.getPendingIntent()).createForegroundServiceNotificationBuilder();
    }

    private void serviceIsUp(String brandId) {
        MessagingFactory.getInstance().getController().serviceStarted(brandId);
    }

    private void serviceIsOff(String brandId) {
        MessagingFactory.getInstance().getController().serviceStopped(brandId);
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        LPLog.INSTANCE.w(TAG, "onBind: Service onBind. Should not be used");
        return null;
    }

    public static interface ServiceActioner {
        public void actionFromService(Intent var1, ServiceActionCallbackListener var2);

        public boolean isPendingActions();
    }

    public static interface ServiceActionCallbackListener {
        public void onSuccess(String var1);

        public void onFail(String var1);
    }
}

