/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.background;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import android.util.SparseArray;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.LongSparseArray;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.infra.Infra;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.network.socket.SocketManager;
import com.liveperson.infra.network.socket.SocketState;
import com.liveperson.infra.utils.DateUtils;
import com.liveperson.infra.utils.DispatchQueue;
import com.liveperson.infra.utils.LocalBroadcast;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.BackgroundActionsService;
import com.liveperson.messaging.background.DownloadFileTask;
import com.liveperson.messaging.background.DownloadFileTaskCallback;
import com.liveperson.messaging.background.ReUploadImageTask;
import com.liveperson.messaging.background.UploadFileTaskCallback;
import com.liveperson.messaging.background.UploadImageTask;
import com.liveperson.messaging.background.filesharing.BaseUploadTask;
import com.liveperson.messaging.background.filesharing.DownloadFileTaskBundle;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import com.liveperson.messaging.background.filesharing.ReUploadFileTaskBundle;
import com.liveperson.messaging.background.filesharing.UploadFileTaskBundle;
import com.liveperson.messaging.background.filesharing.document.DownloadDocumentTask;
import com.liveperson.messaging.background.filesharing.document.UploadDocumentTask;
import com.liveperson.messaging.background.filesharing.document.UploadDocumentTaskBundle;
import com.liveperson.messaging.background.filesharing.image.DownloadImageTask;
import com.liveperson.messaging.background.filesharing.image.ReUploadImageTaskBundle;
import com.liveperson.messaging.background.filesharing.image.UploadImageTaskBundle;
import com.liveperson.messaging.background.filesharing.voice.DownloadVoiceTask;
import com.liveperson.messaging.background.filesharing.voice.ReUploadVoiceTask;
import com.liveperson.messaging.background.filesharing.voice.UploadVoiceTask;
import com.liveperson.messaging.exception.FileSharingException;
import com.liveperson.messaging.model.Conversation;
import com.liveperson.messaging.network.http.RestRequestParams;
import java.io.File;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;

public class FileSharingManager
extends DispatchQueue
implements BackgroundActionsService.ServiceActioner {
    private static final String TAG = "FileSharingManager";
    private static final String BRAND_ID = "brandId";
    private static final String TARGET_ID = "targetId";
    private static final String FILE_URI = "uri";
    private static final String FILE_URI_LIST = "uriList";
    private static final String RELATIVE_PATH = "relativePath";
    private static final String FILE_SHARING_TYPE = "fileSharingType";
    private static final String FILE_ROW_ID = "fileRowId";
    private static final String MESSAGE_ROW_ID = "messageRowId";
    private static final String CAPTION = "caption";
    private static final String FILE_FROM_CAMERA = "fileFromCamera";
    private static final String EVENT_ID = "EVENT_ID";
    private static final String THUMBNAIL_LOCAL_URI_PATH = "THUMBNAIL_LOCAL_URI_PATH";
    private static final String ORIGINAL_LOCAL_URI_PATH = "ORIGINAL_LOCAL_URI_PATH";
    private static final String ORIGINAL_MESSAGE_TIME = "ORIGINAL_MESSAGE_TIME";
    private static final String ORIGINAL_CONVERSATION_ID = "ORIGINAL_CONVERSATION_ID";
    private static final int TYPE_UPLOAD_MSG_NEW_FILE = 1;
    private static final int TYPE_RE_UPLOAD_MSG_NEW_FILE = 2;
    private static final int TYPE_DOWNLOAD_MSG_NEW_FILE = 3;
    private static final int TYPE_MSG_CONNECTION_TIMEOUT = 4;
    private static final int TYPE_REMOVE_DOWNLOADED_LOCAL_FILES = 5;
    private static int UPLOAD_TASK_ID = 0;
    public static final String SERVICE_EXTRA_BRAND_ID = "service_extra_brand_id";
    public static final String SERVICE_EXTRA_TARGET_ID = "service_extra_target_id";
    public static final String SERVICE_EXTRA_FILE_URI = "service_extra_file_uri";
    public static final String SERVICE_EXTRA_FILE_CAPTION = "service_extra_file_caption";
    public static final String SERVICE_EXTRA_FILE_ROW_ID = "service_extra_file_row_id";
    public static final String SERVICE_EXTRA_MESSAGE_ROW_ID = "service_extra_message_row_id";
    public static final String SERVICE_EXTRA_IMAGE_FROM_CAMERA = "service_extra_image_from_camera";
    public static final String SERVICE_EXTRA_MESSAGE = "service_extra_message";
    public static final String SERVICE_EXTRA_EVENT_ID = "service_extra_event_id";
    public static final String SERVICE_EXTRA_ORIGINAL_MESSAGE_TIME = "extra_original_message_time";
    public static final String SERVICE_EXTRA_CONVERSATION_ID = "extra_conversation_id";
    public static final String BROADCAST_FILE_UPLOAD_FAILED = "BROADCAST_FILE_UPLOAD_FAILED";
    public static final String KEY_FILE_UPLOAD_ERROR = "KEY_FILE_UPLOAD_ERROR";
    private final Context mContext;
    private final Messaging mController;
    private String mSwiftDomain;
    private RestRequestParams mRestParams = new RestRequestParams();
    private final int mDownloadTimeoutMs;
    private final int mUploadImageTimeoutMs;
    private final int mUploadVoiceTimeoutMs;
    private final int mUploadDocumentTimeoutMs;
    private LocalBroadcastReceiver mLocalBroadcastReceiver = null;
    private final LongSparseArray<FileDownloadProgressListener> mFileDownloadProgressListener = new LongSparseArray();
    private final SparseArray<FileUploadProgressListener> mFileUploadProgressListener = new SparseArray();
    private final CopyOnWriteArrayList<BaseUploadTask> mQueuedUploadFiles = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<DownloadFileTask> mQueuedDownloadFiles = new CopyOnWriteArrayList();

    public FileSharingManager(Messaging messaging, Context context) {
        super(TAG);
        this.mContext = context;
        this.mController = messaging;
        this.mDownloadTimeoutMs = Configuration.getInteger((int)R.integer.download_file_timeout_ms);
        this.mUploadImageTimeoutMs = Configuration.getInteger((int)R.integer.image_upload_timeout_ms);
        this.mUploadVoiceTimeoutMs = Configuration.getInteger((int)R.integer.voice_upload_timeout_ms);
        this.mUploadDocumentTimeoutMs = Configuration.getInteger((int)R.integer.document_upload_timeout_ms);
        this.setHandleMessageCallback(msg -> {
            LPLog.INSTANCE.d(TAG, "onHandleMessage");
            if (msg.what == 4) {
                if (!this.mQueuedUploadFiles.isEmpty() || !this.mQueuedDownloadFiles.isEmpty()) {
                    LPLog.INSTANCE.d(TAG, "Timeout for sending files. aborting.");
                    this.abortConnection();
                }
                return;
            }
            int fileType = msg.getData().getInt(FILE_SHARING_TYPE, -1);
            FileSharingType fileSharingType = fileType != -1 ? FileSharingType.values()[fileType] : FileSharingType.UNKNOWN;
            switch (msg.arg1) {
                case 1: {
                    this.handleNewUploadRequest(fileSharingType, msg);
                    break;
                }
                case 2: {
                    this.handleReUploadRequest(fileSharingType, msg);
                    break;
                }
                case 3: {
                    this.handleNewDownloadRequest(fileSharingType, msg);
                    break;
                }
                case 5: {
                    Bundle data = msg.getData();
                    ArrayList filePathList = data.getStringArrayList(FILE_URI_LIST);
                    if (filePathList == null) break;
                    this.removeLocalFilesFromDirectoryAndFilePathsFromDB(filePathList);
                    break;
                }
                default: {
                    LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000090, "Unknown message type " + msg.arg1 + " found");
                }
            }
        });
    }

    public void downloadFile(FileSharingType fileSharingType, String brandId, String targetId, String swiftFileRelativePath, long messageRowId, long fileRowId, String conversationID, FileDownloadProgressListener fileProgressListener) {
        Message msg = new Message();
        Bundle data = new Bundle();
        msg.arg1 = 3;
        data.putString(BRAND_ID, brandId);
        data.putString(TARGET_ID, targetId);
        data.putString(RELATIVE_PATH, swiftFileRelativePath);
        data.putLong(FILE_ROW_ID, fileRowId);
        data.putLong(MESSAGE_ROW_ID, messageRowId);
        data.putString(ORIGINAL_CONVERSATION_ID, conversationID);
        data.putInt(FILE_SHARING_TYPE, fileSharingType.ordinal());
        msg.setData(data);
        if (this.mFileDownloadProgressListener.get(fileRowId) == null) {
            LPLog.INSTANCE.d(TAG, "Adding download image task");
            this.mFileDownloadProgressListener.put(fileRowId, (Object)fileProgressListener);
            this.sendMessage(msg);
        } else {
            LPLog.INSTANCE.d(TAG, "Adding download file listener, task for this file is already exists.");
            this.mFileDownloadProgressListener.put(fileRowId, (Object)fileProgressListener);
        }
    }

    public void uploadFile(FileSharingType fileSharingType, String brandId, String targetId, String fileUri, String caption, boolean fileFromCamera, FileUploadProgressListener fileUploadProgressListener) {
        int taskId;
        Message msg = Message.obtain();
        Bundle data = new Bundle();
        msg.arg1 = 1;
        data.putString(BRAND_ID, brandId);
        data.putString(TARGET_ID, targetId);
        data.putString(FILE_URI, fileUri);
        data.putString(CAPTION, caption);
        data.putBoolean(FILE_FROM_CAMERA, fileFromCamera);
        data.putInt(FILE_SHARING_TYPE, fileSharingType.ordinal());
        msg.setData(data);
        msg.arg2 = taskId = UPLOAD_TASK_ID++;
        this.mFileUploadProgressListener.put(taskId, (Object)fileUploadProgressListener);
        this.sendMessage(msg);
    }

    public void reUploadFile(FileSharingType fileSharingType, String brandId, String targetId, String message, String eventId, long originalMessageTime, long fileRowId, FileUploadProgressListener fileProgressListener) {
        this.mController.amsFiles.getFileByFileRowId(fileRowId).setPostQueryOnBackground(fileMessage -> {
            int taskId;
            Message msg = Message.obtain();
            Bundle data = new Bundle();
            msg.arg1 = 2;
            data.putString(BRAND_ID, brandId);
            data.putString(TARGET_ID, targetId);
            data.putString(EVENT_ID, eventId);
            data.putLong(ORIGINAL_MESSAGE_TIME, originalMessageTime);
            data.putLong(FILE_ROW_ID, fileRowId);
            data.putString(ORIGINAL_LOCAL_URI_PATH, fileMessage.getLocalUrl());
            data.putString(THUMBNAIL_LOCAL_URI_PATH, fileMessage.getPreview());
            data.putInt(FILE_SHARING_TYPE, fileSharingType.ordinal());
            data.putString(CAPTION, message);
            msg.setData(data);
            msg.arg2 = taskId = UPLOAD_TASK_ID++;
            this.mFileUploadProgressListener.put(taskId, (Object)fileProgressListener);
            this.sendMessage(msg);
        }).execute();
    }

    public void removeMultipleOlderFiles(String targetId, int maxNumberOfStoredFiles, @Nullable String fileTypesString) {
        LPLog.INSTANCE.d(TAG, "removeMultipleOlderFiles: removing older files if greater than: " + maxNumberOfStoredFiles + ". fileTypeString: " + fileTypesString);
        MessagingFactory.getInstance().getController().amsFiles.getNumOfLocalPathFromDB(targetId, fileTypesString).setPostQueryOnBackground(count -> {
            LPLog.INSTANCE.d(TAG, "removeMultipleOlderFiles: number of localUrl exist in DB: " + count + " (fileTypeString = " + fileTypesString + ")");
            if (count > maxNumberOfStoredFiles) {
                ArrayList filesToRemove = (ArrayList)MessagingFactory.getInstance().getController().amsFiles.getMultipleOldestLocalPathFromDB(targetId, count - maxNumberOfStoredFiles, fileTypesString).executeSynchronously();
                if (filesToRemove != null) {
                    LPLog.INSTANCE.d(TAG, "removeMultipleOlderFiles: going to remove older files: " + filesToRemove);
                    Message msg = Message.obtain();
                    Bundle data = new Bundle();
                    msg.arg1 = 5;
                    data.putStringArrayList(FILE_URI_LIST, filesToRemove);
                    data.putString(TARGET_ID, targetId);
                    msg.setData(data);
                    this.sendMessage(msg);
                } else {
                    LPLog.INSTANCE.w(TAG, "onResult: received empty localUrl");
                }
            }
        }).execute();
    }

    public String getInProgressUploadMessageRowIdsString() {
        StringBuilder result = new StringBuilder();
        for (BaseUploadTask uploadFileTask : this.mQueuedUploadFiles) {
            result.append(uploadFileTask.getMessageRowId());
            result.append(",");
        }
        return result.length() > 0 ? result.substring(0, result.length() - 1) : "";
    }

    private void handleNewDownloadRequest(FileSharingType fileType, Message msg) {
        Bundle data = msg.getData();
        String brandId = data.getString(BRAND_ID);
        String targetId = data.getString(TARGET_ID);
        String relativePath = data.getString(RELATIVE_PATH);
        long fileRowId = data.getLong(FILE_ROW_ID);
        long messageRowId = data.getLong(MESSAGE_ROW_ID);
        String conversationId = data.getString(ORIGINAL_CONVERSATION_ID);
        LPLog.INSTANCE.d(TAG, "runNewDownloadFileTask: data.getString(RELATIVE_PATH) = " + relativePath + " fileRowId = " + fileRowId + " messageRowId = " + messageRowId + " conversationId = " + conversationId);
        this.updateServicesUrl(brandId);
        this.setTimeout(this.mDownloadTimeoutMs);
        this.runNewDownloadFileTask(fileType, brandId, targetId, relativePath, messageRowId, fileRowId, fileRowId, conversationId);
    }

    private void handleNewUploadRequest(FileSharingType fileType, Message msg) {
        Bundle data = msg.getData();
        String brandId = data.getString(BRAND_ID);
        String targetId = data.getString(TARGET_ID);
        Uri fileUri = Uri.parse((String)data.getString(FILE_URI));
        String caption = data.getString(CAPTION);
        boolean imageFromCamera = data.getBoolean(FILE_FROM_CAMERA, false);
        LPLog.INSTANCE.d(TAG, "runNewUploadFileTask: data.getString(FILE_URI) = " + data.getString(FILE_URI));
        this.updateServicesUrl(brandId);
        int taskId = msg.arg2;
        BaseUploadTask uploadFileTask = null;
        try {
            if (fileType.getCommonFileType() == FileSharingType.CommonFileType.IMAGE) {
                UploadImageTaskBundle params = new UploadImageTaskBundle();
                params.addMessage(this.mController.getMaskedMessage(brandId, caption)).addBrandId(brandId).addTargetId(targetId).addFileUri(fileUri).addSwiftDomain(this.mSwiftDomain).addRestDomain(this.mRestParams).addImageFromCamera(imageFromCamera).build(taskId, this.mContext);
                uploadFileTask = new UploadImageTask(params, this.mUploadImageTimeoutMs);
                this.setTimeout(this.mUploadImageTimeoutMs);
            } else if (fileType.getCommonFileType() == FileSharingType.CommonFileType.AUDIO) {
                UploadFileTaskBundle params = new UploadFileTaskBundle();
                params.addMessage(this.mController.getMaskedMessage(brandId, caption)).addBrandId(brandId).addTargetId(targetId).addFileUri(fileUri).addSwiftDomain(this.mSwiftDomain).addRestDomain(this.mRestParams).build(taskId, this.mContext);
                uploadFileTask = new UploadVoiceTask(params, this.mUploadVoiceTimeoutMs);
                this.setTimeout(this.mUploadVoiceTimeoutMs);
            } else if (fileType.getCommonFileType() == FileSharingType.CommonFileType.DOCUMENT) {
                UploadDocumentTaskBundle params = new UploadDocumentTaskBundle();
                params.addMessage(this.mController.getMaskedMessage(brandId, caption)).addBrandId(brandId).addTargetId(targetId).addFileUri(fileUri).addSwiftDomain(this.mSwiftDomain).addRestDomain(this.mRestParams).build(taskId, this.mContext);
                uploadFileTask = new UploadDocumentTask(this.mContext, params, this.mUploadDocumentTimeoutMs, false);
                this.setTimeout(this.mUploadDocumentTimeoutMs);
            }
            if (uploadFileTask == null) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000091, "handleNewUploadRequest: cannot crate UploadTask");
                return;
            }
            this.runNewUploadFileTask(uploadFileTask, brandId, taskId);
        }
        catch (FileSharingException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000092, "Exception while handling new upload request.", (Throwable)e);
            this.sendFileUploadFailedStatus(e);
            ((FileUploadProgressListener)this.mFileUploadProgressListener.get(taskId)).onFailedUpload(e);
            this.mFileUploadProgressListener.remove(taskId);
            this.checkNoMoreDownloadTasks();
        }
    }

    private void handleReUploadRequest(FileSharingType fileType, Message msg) {
        Bundle data = msg.getData();
        String eventId = data.getString(EVENT_ID);
        int taskId = msg.arg2;
        for (BaseUploadTask task : this.mQueuedUploadFiles) {
            String eventId1 = task.getEventId();
            LPLog.INSTANCE.d(TAG, "createNewReUploadImageTask: event id: " + eventId + " taskEventId =" + eventId1);
            if (!TextUtils.equals((CharSequence)eventId1, (CharSequence)eventId)) continue;
            LPLog.INSTANCE.d(TAG, "createNewReUploadImageTask: event id: " + eventId + " is already in progress. no need to resend.");
            return;
        }
        String brandId = data.getString(BRAND_ID);
        String targetId = data.getString(TARGET_ID);
        String caption = data.getString(CAPTION);
        String originalFilePath = data.getString(ORIGINAL_LOCAL_URI_PATH);
        String previewFileUri = data.getString(THUMBNAIL_LOCAL_URI_PATH);
        long originalMessageTime = data.getLong(ORIGINAL_MESSAGE_TIME);
        long fileRowId = data.getLong(FILE_ROW_ID);
        boolean imageFromCamera = data.getBoolean(FILE_FROM_CAMERA, false);
        LPLog.INSTANCE.d(TAG, "createNewReUploadImageTask: thumbnailLocalUriPath = " + previewFileUri);
        this.updateServicesUrl(brandId);
        BaseUploadTask uploadFileTask = null;
        try {
            if (fileType.getCommonFileType() == FileSharingType.CommonFileType.IMAGE) {
                ReUploadImageTaskBundle params = new ReUploadImageTaskBundle();
                params.addFileRowId(fileRowId).addOriginalLocalPath(originalFilePath).addThumbnailLocalPath(previewFileUri).addEventID(eventId).addOriginalMessageTime(originalMessageTime).addBrandId(brandId).addTargetId(targetId).addFileUri(Uri.parse((String)originalFilePath)).addSwiftDomain(this.mSwiftDomain).addRestDomain(this.mRestParams).addMessage(this.mController.getMaskedMessage(brandId, caption)).addImageFromCamera(imageFromCamera).build(taskId, this.mContext);
                uploadFileTask = new ReUploadImageTask(params, (Integer)this.mUploadImageTimeoutMs);
                this.setTimeout(this.mUploadImageTimeoutMs);
            } else if (fileType.getCommonFileType() == FileSharingType.CommonFileType.DOCUMENT) {
                UploadDocumentTaskBundle params = new UploadDocumentTaskBundle();
                params.addMessage(this.mController.getMaskedMessage(brandId, caption)).addBrandId(brandId).addTargetId(targetId).addFileUri(Uri.parse((String)originalFilePath)).addSwiftDomain(this.mSwiftDomain).addRestDomain(this.mRestParams).addEventID(eventId).addFileRowId(fileRowId).addOriginalMessageTime(originalMessageTime).build(taskId, this.mContext);
                uploadFileTask = new UploadDocumentTask(this.mContext, params, this.mUploadDocumentTimeoutMs, true);
                this.setTimeout(this.mUploadDocumentTimeoutMs);
            } else if (fileType.getCommonFileType() == FileSharingType.CommonFileType.AUDIO) {
                ReUploadFileTaskBundle params = new ReUploadFileTaskBundle();
                params.addFileRowId(fileRowId).addEventID(eventId).addOriginalMessageTime(originalMessageTime).addMessage(this.mController.getMaskedMessage(brandId, caption)).addBrandId(brandId).addTargetId(targetId).addFileUri(Uri.parse((String)originalFilePath)).addSwiftDomain(this.mSwiftDomain).addRestDomain(this.mRestParams).build(taskId, this.mContext);
                uploadFileTask = new ReUploadVoiceTask(params, (Integer)this.mUploadVoiceTimeoutMs);
                this.setTimeout(this.mUploadVoiceTimeoutMs);
            }
            if (uploadFileTask == null) {
                LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000093, "handleNewUploadRequest: uploadFileTask is null");
                return;
            }
            this.runNewUploadFileTask(uploadFileTask, brandId, taskId);
        }
        catch (FileSharingException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000094, "Exception while handling upload request.", (Throwable)e);
            ((FileUploadProgressListener)this.mFileUploadProgressListener.get(taskId)).onFailedUpload(e);
            this.mFileUploadProgressListener.remove(taskId);
            this.checkNoMoreDownloadTasks();
        }
    }

    private void updateServicesUrl(String brandId) {
        this.updateSwiftDomain(brandId);
        this.updateRestParams(brandId);
    }

    private void setTimeout(int timeout) {
        this.removeTimer();
        Message msg = new Message();
        msg.what = 4;
        this.sendMessage(msg, timeout);
    }

    private void removeTimer() {
        this.removeMessage(4);
    }

    private void updateSwiftDomain(String brandId) {
        if (TextUtils.isEmpty((CharSequence)this.mSwiftDomain)) {
            this.mSwiftDomain = this.mController.mAccountsController.getServiceUrl(brandId, "swift");
            if (TextUtils.isEmpty((CharSequence)this.mSwiftDomain)) {
                LPLog.INSTANCE.w(TAG, "No swift url from csds! can;t upload image.");
                this.abortConnection();
            }
        }
    }

    private void updateRestParams(String brandId) {
        if (this.mRestParams.isNotValid()) {
            this.mRestParams.setParams(brandId, this.mController.mAccountsController.getServiceUrl(brandId, "asyncMessagingEnt"), this.mController.mAccountsController.getToken(brandId), this.mController.mAccountsController.getCertificatePinningKeys(brandId));
            if (this.mRestParams.isNotValid()) {
                LPLog.INSTANCE.w(TAG, "No asyncMessagingEnt url from csds! can;t upload image.");
            }
        }
    }

    private void runNewUploadFileTask(BaseUploadTask uploadFileTask, final String brandId, final int taskId) {
        uploadFileTask.setCallBack(new UploadFileTaskCallback(){

            @Override
            public void onFileAddedToDB() {
                FileSharingManager.this.waitForConnection(brandId);
            }

            @Override
            public void onUploadFinishedSuccessfully(BaseUploadTask currentUploadFileTask) {
                FileSharingManager.this.postRunnable(() -> {
                    boolean sendViaRest = false;
                    if (InternetConnectionService.isNetworkAvailable() && FileSharingManager.this.isSocketClose(brandId)) {
                        LPLog.INSTANCE.w(FileSharingManager.TAG, "onUploadFinishedSuccessfully: Socket is closed, Failing Message. " + currentUploadFileTask.getEventId());
                        this.onUploadFailed(currentUploadFileTask, new Exception("No open socket"));
                        return;
                    }
                    for (BaseUploadTask uploadFileTask1 : FileSharingManager.this.mQueuedUploadFiles) {
                        if (uploadFileTask1.isUploadCompleted()) {
                            LPLog.INSTANCE.d(FileSharingManager.TAG, "onUploadFinishedSuccessfully: isUploadCompleted, sending message " + uploadFileTask1.getEventId());
                            uploadFileTask1.sendPublishFile(sendViaRest);
                            FileSharingManager.this.mQueuedUploadFiles.remove(uploadFileTask1);
                            int currentTaskId = uploadFileTask1.getTaskId();
                            LPLog.INSTANCE.d(FileSharingManager.TAG, "sending message " + uploadFileTask1.getEventId() + " currentTaskId = " + currentTaskId);
                            ((FileUploadProgressListener)FileSharingManager.this.mFileUploadProgressListener.get(currentTaskId)).onDoneUpload();
                            FileSharingManager.this.mFileUploadProgressListener.remove(currentTaskId);
                            continue;
                        }
                        LPLog.INSTANCE.d(FileSharingManager.TAG, "onUploadFinishedSuccessfully: isUploadCompleted, waiting for earlier messages... " + uploadFileTask1.getEventId());
                        return;
                    }
                    FileSharingManager.this.checkNoMoreUploadTasks();
                });
            }

            @Override
            public void onUploadFailed(BaseUploadTask uploadFileTask, Throwable exception) {
                LPLog.INSTANCE.d(FileSharingManager.TAG, "get: " + taskId);
                FileSharingManager.this.mQueuedUploadFiles.remove(uploadFileTask);
                if (FileSharingManager.this.mFileUploadProgressListener.get(taskId) != null) {
                    ((FileUploadProgressListener)FileSharingManager.this.mFileUploadProgressListener.get(taskId)).onFailedUpload(exception);
                    FileSharingManager.this.mFileUploadProgressListener.remove(taskId);
                }
                FileSharingManager.this.checkNoMoreDownloadTasks();
                LPLog.INSTANCE.w(FileSharingManager.TAG, "onUploadFailed: Upload Failed!. exception = " + exception.getMessage() + uploadFileTask.getEventId());
            }
        });
        this.mQueuedUploadFiles.add(uploadFileTask);
        uploadFileTask.startUpload();
    }

    private void runNewDownloadFileTask(FileSharingType fileType, final String brandId, String targetId, String relativePath, long messageRowId, long fileRowId, final long taskId, final String conversationId) {
        DownloadFileTask downloadFileTask;
        LPLog.INSTANCE.d(TAG, "runNewDownloadFileTask: relativePath = " + relativePath);
        try {
            DownloadFileTaskBundle params = new DownloadFileTaskBundle();
            params.addRelativePath(relativePath).addBrandId(brandId).addMessageRowId(messageRowId).addFileRowId(fileRowId).addTargetId(targetId).addSwiftDomain(this.mSwiftDomain).addRestDomain(this.mRestParams).addConversationId(conversationId).build(this.mContext);
            downloadFileTask = this.createDownloadFileTask(fileType, params);
        }
        catch (FileSharingException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000095, "runNewDownloadFileTask: cannot create downloadTask", (Throwable)e);
            return;
        }
        downloadFileTask.setCallBack(new DownloadFileTaskCallback(){

            @Override
            public void onReadyToGetUrl() {
                boolean getViaRest = false;
                if (InternetConnectionService.isNetworkAvailable() && FileSharingManager.this.isSocketClose(brandId)) {
                    LPLog.INSTANCE.w(FileSharingManager.TAG, "onReadyToGetUrl: Socket is closed, running via rest");
                    getViaRest = true;
                }
                LPLog.INSTANCE.w(FileSharingManager.TAG, "onReadyToGetUrl: running via rest = " + getViaRest);
                Conversation conversation = (Conversation)((FileSharingManager)FileSharingManager.this).mController.amsConversations.getConversationById(brandId, conversationId).executeSynchronously();
                boolean isFromInca = conversation.getState() == ConversationState.CLOSE && !DateUtils.isInTheLast24hours((long)conversation.getEndTimestamp());
                downloadFileTask.startDownload(isFromInca);
            }

            @Override
            public void onDownloadFinishedSuccessfully(String fileLocalPath) {
                FileSharingManager.this.mQueuedDownloadFiles.remove(downloadFileTask);
                ((FileDownloadProgressListener)FileSharingManager.this.mFileDownloadProgressListener.get(taskId)).onDoneDownload();
                FileSharingManager.this.mFileDownloadProgressListener.remove(taskId);
                LPLog.INSTANCE.d(FileSharingManager.TAG, "onDownloadFinishedSuccessfully: Download Completed. fullImageLocalPath = " + fileLocalPath);
                FileSharingManager.this.checkNoMoreDownloadTasks();
            }

            @Override
            public void onDownloadFailed(DownloadFileTask downloadFileTask2, Throwable exception) {
                FileSharingManager.this.mQueuedDownloadFiles.remove(downloadFileTask2);
                ((FileDownloadProgressListener)FileSharingManager.this.mFileDownloadProgressListener.get(taskId)).onFailedDownload(exception);
                FileSharingManager.this.mFileDownloadProgressListener.remove(taskId);
                FileSharingManager.this.checkNoMoreDownloadTasks();
                LPLog.INSTANCE.w(FileSharingManager.TAG, "onDownloadFailed: Download Failed!. exception = ", exception);
            }
        });
        this.mQueuedDownloadFiles.add(downloadFileTask);
        this.waitForConnection(brandId);
    }

    private void removeLocalFilesFromDirectoryAndFilePathsFromDB(ArrayList<String> imageFilePathList) {
        for (String filePath : imageFilePathList) {
            File fileToDelete = new File(filePath);
            if (fileToDelete.isFile()) {
                LPLog.INSTANCE.d(TAG, "removeLocalFilesFromDirectoryAndFilePathsFromDB: deleting file: " + filePath);
                if (fileToDelete.delete()) {
                    LPLog.INSTANCE.d(TAG, "removeLocalFilesFromDirectoryAndFilePathsFromDB: file " + filePath + "removed successfully");
                    MessagingFactory.getInstance().getController().amsFiles.removeLocalPathFromDB(filePath).setPostQueryOnBackground(numOfRowsRemoved -> {
                        if (numOfRowsRemoved == 1) {
                            LPLog.INSTANCE.d(TAG, "onResult: Image LocalUrl " + filePath + " was removed from DB");
                        } else if (numOfRowsRemoved == 0) {
                            LPLog.INSTANCE.w(TAG, "onResult: no localUrl was removed");
                        } else {
                            LPLog.INSTANCE.w(TAG, "onResult: number of rows removed: " + numOfRowsRemoved);
                        }
                    }).execute();
                    continue;
                }
                LPLog.INSTANCE.w(TAG, "removeLocalFilesFromDirectoryAndFilePathsFromDB: file was not removed (" + filePath + ")");
                continue;
            }
            LPLog.INSTANCE.w(TAG, "removeLocalFilesFromDirectoryAndFilePathsFromDB: File to remove is not a file (" + filePath + ")");
        }
    }

    private boolean isSocketClose(String brandId) {
        String connectionUrl = this.mController.mAccountsController.getConnectionUrl(brandId);
        SocketState state = SocketManager.getInstance().getSocketState(connectionUrl);
        LPLog.INSTANCE.i(TAG, "Current socket state: " + state);
        switch (state) {
            case CONNECTING: 
            case OPEN: {
                return false;
            }
        }
        return true;
    }

    private void checkNoMoreUploadTasks() {
        if (this.mQueuedUploadFiles.isEmpty()) {
            LPLog.INSTANCE.d(TAG, "Finished handling all the messages");
            this.removeTimer();
            this.unregisterReceiver();
        }
    }

    private void checkNoMoreDownloadTasks() {
        if (this.mQueuedDownloadFiles.isEmpty()) {
            LPLog.INSTANCE.d(TAG, "Finished handling all the messages");
            this.removeTimer();
            this.unregisterReceiver();
        }
    }

    private boolean isFilesInProgress() {
        return this.mQueuedUploadFiles.size() > 0 || this.mQueuedDownloadFiles.size() > 0;
    }

    @NonNull
    private DownloadFileTask createDownloadFileTask(FileSharingType fileType, DownloadFileTaskBundle params) throws FileSharingException {
        switch (fileType.getCommonFileType()) {
            case IMAGE: {
                return new DownloadImageTask(params);
            }
            case AUDIO: {
                return new DownloadVoiceTask(params);
            }
            case DOCUMENT: {
                return new DownloadDocumentTask(params, fileType);
            }
        }
        String msg = "createDownloadFileTask: cannot create DownloadFileTask. Received unknown file type: " + (Object)((Object)fileType);
        LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000096, msg);
        throw new FileSharingException(msg);
    }

    private void waitForConnection(String brandId) {
        LPLog.INSTANCE.d(TAG, "waiting for connection..................");
        if (MessagingFactory.getInstance().getController().mConnectionController.isSocketReady(brandId) && MessagingFactory.getInstance().getController().mConnectionController.isUpdated(brandId)) {
            this.updateConnectionAvailable();
            return;
        }
        if (!InternetConnectionService.isNetworkAvailable()) {
            this.abortConnection();
            return;
        }
        if (this.mLocalBroadcastReceiver == null) {
            this.mLocalBroadcastReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_AMS_CONNECTION_UPDATE_ACTION").addAction("BROADCAST_KEY_SOCKET_READY_ACTION").build((context, intent) -> {
                if (intent.getAction().equals("BROADCAST_KEY_SOCKET_READY_ACTION")) {
                    boolean isConnected;
                    String brand = intent.getStringExtra("BROADCAST_KEY_BRAND_ID");
                    if (brandId.equals(brand) && !(isConnected = intent.getBooleanExtra("BROADCAST_KEY_SOCKET_READY_EXTRA", false)) && !InternetConnectionService.isNetworkAvailable()) {
                        this.abortConnection();
                    }
                } else if (intent.getAction().equals("BROADCAST_AMS_CONNECTION_UPDATE_ACTION")) {
                    boolean isUpdated = intent.getBooleanExtra("BROADCAST_AMS_CONNECTION_UPDATE_EXTRA", false);
                    LPLog.INSTANCE.d(TAG, "waiting for connection - got update, connected = " + isUpdated);
                    if (isUpdated) {
                        this.updateConnectionAvailable();
                    } else if (!InternetConnectionService.isNetworkAvailable()) {
                        this.abortConnection();
                    }
                }
            });
        }
    }

    private void abortConnection() {
        LPLog.INSTANCE.d(TAG, "Connection unavailable. aborting waiting tasks..");
        this.unregisterReceiver();
        for (BaseUploadTask uploadFileTask : this.mQueuedUploadFiles) {
            uploadFileTask.onConnectionUnavailable();
        }
        for (DownloadFileTask downloadFileTask : this.mQueuedDownloadFiles) {
            downloadFileTask.onConnectionUnavailable();
        }
    }

    private void unregisterReceiver() {
        if (this.mLocalBroadcastReceiver != null) {
            this.mLocalBroadcastReceiver.unregister();
            this.mLocalBroadcastReceiver = null;
        }
    }

    private void updateConnectionAvailable() {
        for (BaseUploadTask uploadFileTask : this.mQueuedUploadFiles) {
            uploadFileTask.onConnectionAvailable();
        }
        for (DownloadFileTask downloadFileTask : this.mQueuedDownloadFiles) {
            downloadFileTask.onConnectionAvailable();
        }
    }

    @Override
    public void actionFromService(Intent intent, BackgroundActionsService.ServiceActionCallbackListener serviceActionCallbackListener) {
        int type = intent.getIntExtra("extra_action_type", -1);
        int fileType = intent.getIntExtra("extra_file_type", -1);
        LPLog.INSTANCE.d(TAG, "actionFromService: new action for service. Type = " + type);
        if (type == -1 || fileType == -1) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000097, "actionFromService: received type -1. Cannot proceed with action");
            String brandId = intent.getStringExtra(SERVICE_EXTRA_BRAND_ID);
            serviceActionCallbackListener.onFail(brandId);
            return;
        }
        FileSharingType fileSharingType = FileSharingType.values()[fileType];
        switch (type) {
            case 1: {
                this.uploadFileFromService(fileSharingType, intent, serviceActionCallbackListener);
                break;
            }
            case 2: {
                this.downloadFileFromService(fileSharingType, intent, serviceActionCallbackListener);
                break;
            }
            case 3: {
                this.reUploadFileFromService(fileSharingType, intent, serviceActionCallbackListener);
            }
        }
    }

    @Override
    public boolean isPendingActions() {
        return this.isFilesInProgress();
    }

    private void downloadFileFromService(FileSharingType fileSharingType, Intent intent, final BackgroundActionsService.ServiceActionCallbackListener serviceActionCallbackListener) {
        final String brandId = intent.getStringExtra(SERVICE_EXTRA_BRAND_ID);
        String targetId = intent.getStringExtra(SERVICE_EXTRA_TARGET_ID);
        String swiftUri = intent.getStringExtra(SERVICE_EXTRA_FILE_URI);
        long fileRowID = intent.getLongExtra(SERVICE_EXTRA_FILE_ROW_ID, -1L);
        long messageRowID = intent.getLongExtra(SERVICE_EXTRA_MESSAGE_ROW_ID, -1L);
        String conversationId = intent.getStringExtra(SERVICE_EXTRA_CONVERSATION_ID);
        if (TextUtils.isEmpty((CharSequence)swiftUri)) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_00000098, "downloadFile: Error getting one of the required params for uploading a file");
        }
        LPLog.INSTANCE.d(TAG, "downloadFile: starting a thread from the service. Download Params: swiftUri=" + swiftUri);
        this.downloadFile(fileSharingType, brandId, targetId, swiftUri, messageRowID, fileRowID, conversationId, new FileDownloadProgressListener(){

            @Override
            public void onDoneDownload() {
                serviceActionCallbackListener.onSuccess(brandId);
            }

            @Override
            public void onFailedDownload(Throwable e) {
                LPLog.INSTANCE.e(FileSharingManager.TAG, ErrorCode.ERR_00000099, "onFailedDownload", e);
                FileSharingManager.this.showToastMessage(R.string.lp_failed_download_toast_message);
                serviceActionCallbackListener.onFail(brandId);
            }
        });
    }

    private void uploadFileFromService(final FileSharingType fileSharingType, Intent intent, final BackgroundActionsService.ServiceActionCallbackListener serviceActionCallbackListener) {
        final String brandId = intent.getStringExtra(SERVICE_EXTRA_BRAND_ID);
        String targetId = intent.getStringExtra(SERVICE_EXTRA_TARGET_ID);
        String imageUriString = intent.getStringExtra(SERVICE_EXTRA_FILE_URI);
        String captionText = intent.getStringExtra(SERVICE_EXTRA_FILE_CAPTION);
        boolean imageFromCamera = intent.getBooleanExtra(SERVICE_EXTRA_IMAGE_FROM_CAMERA, false);
        if (TextUtils.isEmpty((CharSequence)imageUriString)) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000009A, "uploadImage: Error getting one of the required params for uploading an image");
        }
        LPLog.INSTANCE.d(TAG, "uploadImage: starting a thread from the service. Upload Params: imageUri=" + imageUriString);
        this.uploadFile(fileSharingType, brandId, targetId, imageUriString, captionText, imageFromCamera, new FileUploadProgressListener(){

            @Override
            public void onDoneUpload() {
                serviceActionCallbackListener.onSuccess(brandId);
                LPLog.INSTANCE.i(FileSharingManager.TAG, "Consumer successfully sent file. Type: " + (Object)((Object)fileSharingType));
                if (Infra.instance.isInitialized()) {
                    Infra.instance.getLoggos().reportFeatureStatistics();
                }
            }

            @Override
            public void onFailedUpload(Throwable e) {
                LPLog.INSTANCE.e(FileSharingManager.TAG, ErrorCode.ERR_0000009B, "Failed to send file. Type: " + (Object)((Object)fileSharingType) + ". Reason: ", e);
                if (e.getMessage().equals("This file type is not supported")) {
                    FileSharingManager.this.showToastMessage(R.string.lp_failed_file_type_not_supported);
                } else {
                    FileSharingManager.this.showToastMessage(R.string.lp_failed_upload_toast_message);
                }
                serviceActionCallbackListener.onFail(brandId);
            }
        });
    }

    private void reUploadFileFromService(final FileSharingType fileSharingType, Intent intent, final BackgroundActionsService.ServiceActionCallbackListener serviceActionCallbackListener) {
        final String brandId = intent.getStringExtra(SERVICE_EXTRA_BRAND_ID);
        String targetId = intent.getStringExtra(SERVICE_EXTRA_TARGET_ID);
        String message = intent.getStringExtra(SERVICE_EXTRA_MESSAGE);
        String eventId = intent.getStringExtra(SERVICE_EXTRA_EVENT_ID);
        long originalMessageTime = intent.getLongExtra(SERVICE_EXTRA_ORIGINAL_MESSAGE_TIME, -1L);
        long fileRowId = intent.getLongExtra(SERVICE_EXTRA_FILE_ROW_ID, -1L);
        LPLog.INSTANCE.d(TAG, "reUploadImage: starting a thread from the service. Upload Params: eventId = " + eventId + ", fileRowId = " + fileRowId + ", message = " + LPLog.INSTANCE.mask((Object)message));
        this.reUploadFile(fileSharingType, brandId, targetId, message, eventId, originalMessageTime, fileRowId, new FileUploadProgressListener(){

            @Override
            public void onDoneUpload() {
                serviceActionCallbackListener.onSuccess(brandId);
                LPLog.INSTANCE.i(FileSharingManager.TAG, "Consumer successfully sent file. Type: " + (Object)((Object)fileSharingType));
                if (Infra.instance.isInitialized()) {
                    Infra.instance.getLoggos().reportFeatureStatistics();
                }
            }

            @Override
            public void onFailedUpload(Throwable e) {
                LPLog.INSTANCE.e(FileSharingManager.TAG, ErrorCode.ERR_0000009C, "Failed to send file. Type: " + (Object)((Object)fileSharingType) + ". Reason: ", e);
                FileSharingManager.this.showToastMessage(R.string.lp_failed_upload_toast_message);
                serviceActionCallbackListener.onFail(brandId);
            }
        });
    }

    private void showToastMessage(int messageId) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(() -> Toast.makeText((Context)this.mContext, (int)messageId, (int)1).show());
    }

    private void sendFileUploadFailedStatus(Exception e) {
        if (e.getMessage() != null) {
            Bundle extras = new Bundle();
            extras.putString(KEY_FILE_UPLOAD_ERROR, e.getMessage());
            LocalBroadcast.sendBroadcast((String)BROADCAST_FILE_UPLOAD_FAILED, (Bundle)extras);
        }
    }

    public static interface FileDownloadProgressListener {
        public void onDoneDownload();

        public void onFailedDownload(Throwable var1);
    }

    public static interface FileUploadProgressListener {
        public void onDoneUpload();

        public void onFailedUpload(Throwable var1);
    }
}

