package com.liveperson.messaging;

import com.liveperson.api.LivePersonCallback;
import com.liveperson.api.LivePersonIntents;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.sdk.LPConversationData;
import com.liveperson.api.sdk.PermissionType;
import com.liveperson.infra.Infra;
import com.liveperson.infra.utils.LPDeprecated;
import com.liveperson.messaging.model.AgentData;

/**
 * Created by shiranr on 6/28/17.
 */

public class LivePersonEventsProxy implements LivePersonCallback {

    private LivePersonCallback mCallback;

    LivePersonEventsProxy(){
        mCallback = new LivePersonCallback.NullLivePersonCallback();
    }


    public void setCallback(LivePersonCallback mCallback) {
        this.mCallback = mCallback;
    }

    public void removeCallback() {
        mCallback = new LivePersonCallback.NullLivePersonCallback();
    }

    ///////// EVENTS ////////////

	/**
	 * @deprecated Since September 28, 2020
	 */
	@Override
	@Deprecated
	@LPDeprecated(since = 1601280000)
	//TODO: remove it when upgrade to v6.0.0, we should separate TaskType with Errors.
	public void onError(final TaskType type, final String message) {
		Infra.instance.getApplicationHandler().post(() -> {
			mCallback.onError(type, message);
			LivePersonIntents.sendOnErrorIntent(Infra.instance.getApplicationContext(), type, message);
		});
	}

	@Override
	public void onError(LpError lpError, String message) {
		Infra.instance.getApplicationHandler().post(() -> {
			mCallback.onError(lpError, message);
			LivePersonIntents.sendOnErrorIntent(Infra.instance.getApplicationContext(), lpError, message);
		});
	}

	@Override
    public void onTokenExpired() {
	    Infra.instance.postOnMainThread(() -> {
		    mCallback.onTokenExpired();
		    LivePersonIntents.sendOnTokenExpired(Infra.instance.getApplicationContext());
	    });
    }

    @Override
    public void onUnauthenticatedUserExpired() {
	    Infra.instance.postOnMainThread(() -> {
		    mCallback.onUnauthenticatedUserExpired();
		    LivePersonIntents.sendOnUserExpired(Infra.instance.getApplicationContext());

	    });
    }

    @Override
    public void onConversationStarted(final LPConversationData convData) {

        Infra.instance.getApplicationHandler().post(() -> {
            // Update the mCallback on new conversation
            mCallback.onConversationStarted();
            mCallback.onConversationStarted(convData);
            LivePersonIntents.sendOnConversationStarted(Infra.instance.getApplicationContext(), convData);
        });
    }

    @Deprecated
    @Override
    public void onConversationStarted() {
        mCallback.onConversationStarted();
    }
    @Override
    public void onConversationResolved(final LPConversationData convData) {
	    Infra.instance.postOnMainThread(() -> {
		    mCallback.onConversationResolved();
		    mCallback.onConversationResolved(convData.getCloseReason());
		    mCallback.onConversationResolved(convData);
		    LivePersonIntents.sendOnConversationResolved(Infra.instance.getApplicationContext(), convData);
	    });
    }

    @Deprecated
    @Override
    public void onConversationResolved() {
        mCallback.onConversationResolved();
    }

    @Deprecated
    @Override
    public void onConversationResolved(CloseReason reason) {
        mCallback.onConversationResolved(reason);

    }

    @Override
    public void onConversationFragmentClosed() {
        Infra.instance.postOnMainThread(() -> {
            mCallback.onConversationFragmentClosed();
            LivePersonIntents.sendOnConversationFragmentClosed(Infra.instance.getApplicationContext());
        });
    }

    @Override
    public void onConnectionChanged(final boolean isConnected) {
        Infra.instance.postOnMainThread(() -> {
            mCallback.onConnectionChanged(isConnected);
            LivePersonIntents.sendOnConnectionChanged(Infra.instance.getApplicationContext(), isConnected);
        });
    }

    @Override
    public void onAgentTyping(final boolean isTyping) {
        Infra.instance.postOnMainThread(() -> {
            mCallback.onAgentTyping(isTyping);
            LivePersonIntents.sendOnAgentTyping(Infra.instance.getApplicationContext(), isTyping);
        });
    }

    @Override
    public void onAgentDetailsChanged(final AgentData agentData) {
	    Infra.instance.postOnMainThread(() -> {
		    mCallback.onAgentDetailsChanged(agentData);
		    LivePersonIntents.sendOnAgentDetailsChanged(Infra.instance.getApplicationContext(), agentData);
	    });
    }

	@Override
	public void onCsatLaunched() {
		Infra.instance.postOnMainThread(() -> {
			mCallback.onCsatLaunched();
			LivePersonIntents.sendOnCsatLaunched(Infra.instance.getApplicationContext());
		});
	}

	@Override
	public void onCsatDismissed() {
		Infra.instance.postOnMainThread(() -> {
			mCallback.onCsatDismissed();
			LivePersonIntents.sendOnCsatDismissed(Infra.instance.getApplicationContext());
		});
	}

    @Deprecated
    @Override
    public void onCsatSubmitted(final String conversationId) {
	    mCallback.onCsatSubmitted(conversationId);
    }

	@Override
	public void onCsatSubmitted(String conversationId, int starRating) {
		Infra.instance.postOnMainThread(() -> {
			mCallback.onCsatSubmitted(conversationId);
			mCallback.onCsatSubmitted(conversationId, starRating);
			LivePersonIntents.sendOnCsatSubmitted(Infra.instance.getApplicationContext(), conversationId, starRating);
		});
	}

	@Override
	public void onCsatSkipped() {
		Infra.instance.postOnMainThread(() -> {
			mCallback.onCsatSkipped();
			LivePersonIntents.sendOnCsatSkipped(Infra.instance.getApplicationContext());
		});
	}

	@Override
    public void onConversationMarkedAsUrgent() {
		Infra.instance.postOnMainThread(() -> {
			mCallback.onConversationMarkedAsUrgent();
			LivePersonIntents.sendOnConversationMarkedAsUrgent(Infra.instance.getApplicationContext());
		});
	}

    @Override
    public void onConversationMarkedAsNormal() {
	    Infra.instance.postOnMainThread(() -> {
		    mCallback.onConversationMarkedAsNormal();
		    LivePersonIntents.sendOnConversationMarkedAsNormal(Infra.instance.getApplicationContext());
	    });
    }

    @Override
    public void onOfflineHoursChanges(final boolean isOfflineHoursOn) {
        Infra.instance.postOnMainThread(() -> {
            mCallback.onOfflineHoursChanges(isOfflineHoursOn);
            LivePersonIntents.sendOnOfflineHoursChanges(Infra.instance.getApplicationContext(), isOfflineHoursOn);
        });
    }

    @Override
    public void onAgentAvatarTapped(final AgentData agentData) {
        Infra.instance.postOnMainThread(() -> {
            mCallback.onAgentAvatarTapped(agentData);
            LivePersonIntents.sendOnAgentAvatarTapped(Infra.instance.getApplicationContext(), agentData);
        });
    }

	@Override
	public void onUserDeniedPermission(final PermissionType permissionType, final boolean doNotShowAgainMarked) {
		Infra.instance.postOnMainThread(() -> {
			mCallback.onUserDeniedPermission(permissionType, doNotShowAgainMarked);
			LivePersonIntents.sendOnUserDeniedPermission(Infra.instance.getApplicationContext(), permissionType, doNotShowAgainMarked);
		});
	}

	@Override
	public void onUserActionOnPreventedPermission(final PermissionType permissionType) {
		Infra.instance.postOnMainThread(() -> {
			mCallback.onUserActionOnPreventedPermission(permissionType);
			LivePersonIntents.sendOnUserActionOnPreventedPermission(Infra.instance.getApplicationContext(), permissionType);
		});
	}

	@Override
	public void onStructuredContentLinkClicked(final String uri) {
		Infra.instance.postOnMainThread(() -> {
			mCallback.onStructuredContentLinkClicked(uri);
			LivePersonIntents.sendOnStructuredContentLinkClicked(Infra.instance.getApplicationContext(), uri);
		});
	}
}
