package com.liveperson.messaging.background.filesharing;

import java.util.Arrays;
import java.util.List;

/**
 * A class that holds all the supported image file and voice file extensions
 */
public class FileExtensionTypes {

	static private String[] mImageExtensions = {"jpg", "jpeg", "png", "gif"}; // TODO NN: 5/28/18 check if can take from string array resource
	static private String[] mVoiceExtensions = {"m4a", "acc", "mp3"};
	static private String[] mDocumentExtensions = {"docx","pdf","xlsx","pptx"};


	public static List<String> getImageExtensions() {
		return Arrays.asList(mImageExtensions);
	}

	public static List<String> getDocumentExtensions() { return Arrays.asList(mDocumentExtensions); }

	public static List<String> getVoiceExtensions() {
		return Arrays.asList(mVoiceExtensions);
	}

	/**
	 * Get a string of all supported image extensions in the format of: 'jpg','jpeg','png'
	 * @return
	 */
	public static String getImageExtensionsAsSqlString(){

		return convertArrayToSqlString(mImageExtensions);
	}

	/**
	 * Get a string of all supported voice extensions in the format of: 'm4a','aac','mp3'
	 * @return
	 */
	public static String getVoiceExtensionsAsSqlString(){

		return convertArrayToSqlString(mVoiceExtensions);
	}

	/**
	 * Get a string of all supported Document extensions in the format of: 'docx','xlsx','pptx','pdf'
	 * @return
	 */
	public static String getDocumentExtensionsAsSqlString(){
		return convertArrayToSqlString(mDocumentExtensions);
	}


	private static String convertArrayToSqlString(String[] array){

		StringBuilder sb = new StringBuilder();

		for (int i = 0; i < array.length; i++) {
			String imageExtension = array[i];
			sb.append("'").append(imageExtension).append("'");
			if (i < (array.length - 1)) {
				sb.append(",");
			}
		}

		return sb.toString();

	}

}
