package com.liveperson.messaging.background.filesharing.document;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.webkit.MimeTypeMap;

import com.liveperson.infra.utils.MaskedMessage;
import com.liveperson.messaging.background.filesharing.UploadFileTaskBundle;
import com.liveperson.messaging.network.http.RestRequestParams;

public class UploadDocumentTaskBundle extends UploadFileTaskBundle {

    private String eventId;
    private long originalMessageTime;
    private long fileRowId;

    public String getEventId() {
        return eventId;
    }

    public long getOriginalMessageTime() {
        return originalMessageTime;
    }


    public long getFileRowId() {
        return fileRowId;
    }

    public UploadDocumentTaskBundle addBrandId(String brandId) {
        super.addBrandId(brandId);
        return this;
    }

    public UploadDocumentTaskBundle addTargetId(String targetId) {
        super.addTargetId(targetId);
        return this;
    }

    public UploadDocumentTaskBundle addSwiftDomain(String swiftDomain) {
        super.addSwiftDomain(swiftDomain);
        return this;
    }

    public UploadDocumentTaskBundle addRestDomain(RestRequestParams restRequestParams) {
        super.addRestDomain(restRequestParams);
        return this;
    }

    public UploadDocumentTaskBundle addFileUri(Uri fileUri) {
        super.addFileUri(fileUri);
        return this;
    }

    public UploadDocumentTaskBundle addMessage(MaskedMessage maskedMessage) {
        super.addMessage(maskedMessage);
        return this;
    }

    public UploadDocumentTaskBundle addEventID(String eventId) {
        this.eventId = eventId;
        return this;
    }

    public UploadDocumentTaskBundle addFileRowId(long fileRowId) {
        this.fileRowId = fileRowId;
        return this;
    }

    public UploadDocumentTaskBundle addOriginalMessageTime(long originalMessageTime) {
        this.originalMessageTime = originalMessageTime;
        return this;
    }


    public UploadDocumentTaskBundle build(int taskId, Context context) {
        setTaskID(taskId);
        mFilePath = mFileUri.toString();

        String fileScheme = mFileUri.getScheme();
        if (fileScheme != null && fileScheme.equals(ContentResolver.SCHEME_CONTENT)) {
            ContentResolver cR = context.getContentResolver();
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            mFileContentType = cR.getType(mFileUri);
            if (mFileContentType != null) {
                String extensionFromMimeType = mime.getExtensionFromMimeType(mFileContentType);
                if (extensionFromMimeType != null) {
                    mFileTypeExtension = extensionFromMimeType.toUpperCase();
                }
            }
        } else { // The scheme is NOT 'content'. It means we have a file:// scheme (usually from camera) so we get the info from the file

            String fileExtensionFromUrl = MimeTypeMap.getFileExtensionFromUrl(mFileUri.toString());
            if (fileExtensionFromUrl != null) {
                mFileTypeExtension = fileExtensionFromUrl.toUpperCase();
            }

            if (mFileTypeExtension != null) {
                mFileContentType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(mFileTypeExtension.toLowerCase());
            }
        }
        return this;
    }
}
