/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.commands;

import com.liveperson.infra.Command;
import com.liveperson.infra.ICallback;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.utils.ThreadPoolExecutor;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.SocketTaskType;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionCallback;
import com.liveperson.messaging.commands.tasks.BaseAmsSocketConnectionTask;
import com.liveperson.messaging.commands.tasks.GetAgentUserTask;
import com.liveperson.messaging.commands.tasks.GetClockTask;
import com.liveperson.messaging.commands.tasks.GetConsumerUserTask;
import com.liveperson.messaging.commands.tasks.HandlePendingMessagesTask;
import com.liveperson.messaging.commands.tasks.RefreshNotUpdatedConversationsTask;
import com.liveperson.messaging.commands.tasks.SubscribeExConversationsTask;
import java.util.LinkedList;

public class InitAmsSessionCommand
implements Command {
    private static final String TAG = "InitAmsSessionCommand";
    protected final Messaging mController;
    protected LinkedList<BaseAmsSocketConnectionTask> mTasks = new LinkedList();
    protected String mBrandId;
    protected ICallback<Object, Throwable> mCallback;

    public InitAmsSessionCommand(Messaging controller, String brandId, ICallback<Object, Throwable> callback) {
        this.mController = controller;
        this.mBrandId = brandId;
        this.mCallback = callback;
        this.initTasks();
    }

    protected void initTasks() {
        this.mTasks.add(new GetClockTask(this.mController));
        this.mTasks.add(new GetConsumerUserTask(this.mController));
        this.mTasks.add(new HandlePendingMessagesTask(this.mController.amsMessages, this.mController.amsConversations, this.mController.amsDialogs, this.mController.mConnectionController));
        this.mTasks.add(new RefreshNotUpdatedConversationsTask(this.mController));
        this.mTasks.add(new SubscribeExConversationsTask(this.mController));
        this.mTasks.add(new GetAgentUserTask(this.mController));
    }

    public void execute() {
        if (this.mTasks.size() != 0) {
            if (InternetConnectionService.isNetworkAvailable()) {
                ThreadPoolExecutor.execute(() -> {
                    BaseAmsSocketConnectionTask baseConnectionTask = this.mTasks.removeFirst();
                    baseConnectionTask.setBrandId(this.mBrandId);
                    baseConnectionTask.setCallback(new BaseAmsSocketConnectionCallback(){

                        @Override
                        public void onTaskSuccess() {
                            InitAmsSessionCommand.this.execute();
                        }

                        @Override
                        public void onTaskError(SocketTaskType type, Throwable exception) {
                            LPLog.INSTANCE.d(InitAmsSessionCommand.TAG, type.name() + " failed");
                            InitAmsSessionCommand.this.mCallback.onError(exception);
                        }
                    });
                    baseConnectionTask.execute();
                });
            }
        } else {
            this.mCallback.onSuccess(null);
        }
    }
}

