/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.concurrent.TimeUnit;

public class TimeBundle
implements Parcelable {
    public final int diffDays;
    public final int diffHours;
    public final int diffMinutes;
    private long mTimeToRespondMilliseconds;
    public static final Parcelable.Creator<TimeBundle> CREATOR = new Parcelable.Creator<TimeBundle>(){

        public TimeBundle createFromParcel(Parcel in) {
            return new TimeBundle(in);
        }

        public TimeBundle[] newArray(int size) {
            return new TimeBundle[size];
        }
    };

    public TimeBundle(long timeToRespondMilliseconds) {
        this.mTimeToRespondMilliseconds = timeToRespondMilliseconds;
        this.diffDays = (int)TimeUnit.MILLISECONDS.toDays(timeToRespondMilliseconds += 60000L);
        this.diffHours = (int)(TimeUnit.MILLISECONDS.toHours(timeToRespondMilliseconds) - (long)(this.diffDays * 24));
        this.diffMinutes = (int)(TimeUnit.MILLISECONDS.toMinutes(timeToRespondMilliseconds) - TimeUnit.MILLISECONDS.toHours(timeToRespondMilliseconds) * 60L);
    }

    protected TimeBundle(Parcel in) {
        this.diffDays = in.readInt();
        this.diffHours = in.readInt();
        this.diffMinutes = in.readInt();
        this.mTimeToRespondMilliseconds = in.readLong();
    }

    public boolean equals(Object o) {
        if (o instanceof Long) {
            return this.mTimeToRespondMilliseconds == (Long)o;
        }
        return super.equals(o);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.diffDays);
        dest.writeInt(this.diffHours);
        dest.writeInt(this.diffMinutes);
        dest.writeLong(this.mTimeToRespondMilliseconds);
    }

    public String toString() {
        return this.diffDays + " : " + this.diffHours + " : " + this.diffMinutes;
    }
}

