package com.liveperson.api.response.model;

import android.text.TextUtils;

import com.liveperson.api.exception.BadConversationException;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * Created by oferd on 8/10/15.
 */
public class Result {

    public String conversationId;
    public long effectiveTTR;
    public ConversationUMSDetails conversationDetails;

    public Result(JSONObject jsonObject) throws JSONException, BadConversationException {
        conversationId = jsonObject.optString("convId");

        if (TextUtils.isEmpty(conversationId)) {
            throw new BadConversationException("no conversation id");
        }

        conversationDetails = null;
        JSONObject conversationDetailsObj = jsonObject.optJSONObject("conversationDetails");
        if (conversationDetailsObj != null) {
            conversationDetails = new ConversationUMSDetails(conversationDetailsObj, conversationId);
            effectiveTTR = 0;
        }
    }

    @Override
    public String toString() {
        return "{ conversationId: " + conversationId + ", conversationDetails: " + conversationDetails + " }";
    }
}