/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.api.request;

import com.liveperson.api.request.AbstractRequest;
import com.liveperson.api.response.types.CloseReason;
import com.liveperson.api.response.types.ConversationState;
import com.liveperson.api.response.types.CsatStatus;
import com.liveperson.api.response.types.DialogState;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.messaging.model.AmsDialogs;
import org.json.JSONException;
import org.json.JSONObject;

public class UpdateConversationField
extends AbstractRequest {
    public static final String CONVERSATION_STAGE_FIELD = "Stage";
    @Deprecated
    private static final String CONVERSATION_STATE_FIELD = "ConversationStateField";
    public static final String CONVERSATION_CSAT_RATE = "CSATRate";
    public static final String TTR_FIELD = "TTRField";
    public static final String UPDATE_CONVERSATION_FIELD_TYPE = "cm.UpdateConversationField";
    private static final String UPDATE = "UPDATE";
    public static final String CONVERSATION_ID = "conversationId";
    public static final String FIELD = "field";
    @Deprecated
    public static final String CONVERSATION_STATE = "conversationState";
    public static final String CONVERSATION_STAGE = "stage";
    public static final String CONVERSATION_CSAT = "csatRate";
    public static final String CONVERSATION_CSAT_YESNO_VALUE = "csatResolutionConfirmation";
    public static final String CONVERSATION_CSAT_STATUS = "status";
    public static final String CONVERSATION_FIELD = "conversationField";
    public static final String PARTICIPANTS_CHANGE_FIELD = "ParticipantsChange";
    public static final String DIALOG_CHANGE_FIELD = "DialogChange";
    public static final String TTR = "ttrType";
    private static final String TTR_VALUE = "value";
    public String conversationId;
    public String dialogId;
    public String field;
    public ConversationState conversationState;
    public DialogState dialogState;
    public TTRType ttrType;
    public int ttrValue;
    public int csatNumberOfStars;
    public int csatYesNoValue;
    public CsatStatus csatStatus;
    public String type;
    private String closingCause;

    public static String CONVERSATION_STATE_FIELD() {
        return AmsDialogs.isUmsSupportingDialogs() ? CONVERSATION_STAGE_FIELD : CONVERSATION_STATE_FIELD;
    }

    public UpdateConversationField(String dialogId, String conversationId, String field, String closingCause, DialogState dialogState) {
        this.type = UPDATE;
        this.closingCause = closingCause;
        this.conversationId = conversationId;
        this.dialogId = dialogId;
        this.field = field;
        this.dialogState = dialogState;
    }

    public UpdateConversationField(String conversationId, String field, ConversationState conversationState) {
        this.conversationId = conversationId;
        this.field = field;
        this.conversationState = conversationState;
    }

    public UpdateConversationField(String convId, String field, int numberOfStars, int csatYesNoValue, CsatStatus status) {
        this.conversationId = convId;
        this.field = field;
        this.csatNumberOfStars = numberOfStars;
        this.csatYesNoValue = csatYesNoValue;
        this.csatStatus = status;
    }

    public UpdateConversationField(String convId, String field, TTRType ttrType, int value) {
        this.conversationId = convId;
        this.field = field;
        this.ttrType = ttrType;
        this.ttrValue = value;
    }

    @Override
    public String getMessageType() {
        return UPDATE_CONVERSATION_FIELD_TYPE;
    }

    @Override
    protected void toJson(JSONObject json) throws JSONException {
        this.body.put(CONVERSATION_ID, (Object)this.conversationId);
        JSONObject conversationField = new JSONObject();
        conversationField.put(FIELD, (Object)this.field);
        switch (this.field) {
            case "Stage": {
                conversationField.put(CONVERSATION_STAGE, (Object)this.conversationState.name());
                break;
            }
            case "ConversationStateField": {
                conversationField.put(CONVERSATION_STATE, (Object)this.conversationState.name());
                break;
            }
            case "CSATRate": {
                if (this.csatYesNoValue > -1) {
                    conversationField.put(CONVERSATION_CSAT_YESNO_VALUE, this.csatYesNoValue == 1);
                }
                if (this.csatNumberOfStars == -1) {
                    conversationField.put(CONVERSATION_CSAT, JSONObject.NULL);
                } else {
                    conversationField.put(CONVERSATION_CSAT, this.csatNumberOfStars);
                }
                conversationField.put(CONVERSATION_CSAT_STATUS, (Object)this.csatStatus.name());
                break;
            }
            case "TTRField": {
                conversationField.put(TTR, (Object)this.ttrType.name());
                conversationField.put(TTR_VALUE, this.ttrValue);
                break;
            }
            case "DialogChange": {
                JSONObject dialogObject = new JSONObject();
                dialogObject.put("dialogId", (Object)this.dialogId);
                dialogObject.put("state", (Object)this.dialogState.name());
                if (this.dialogState == DialogState.CLOSE) {
                    dialogObject.put("closedBy", (Object)CloseReason.CONSUMER.name());
                }
                conversationField.put(CONVERSATION_ID, (Object)this.conversationId);
                conversationField.put("type", (Object)this.type);
                conversationField.put("dialog", (Object)dialogObject);
                break;
            }
            case "ParticipantsChange": {
                conversationField.put("type", (Object)this.type);
                conversationField.put("userId", (Object)this.type);
                conversationField.put("role", (Object)this.type);
            }
        }
        this.body.put(CONVERSATION_FIELD, (Object)conversationField);
        json.put("body", (Object)this.body);
    }
}

