/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.model;

import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.liveperson.api.request.message.FilePublishMessage;
import com.liveperson.api.response.events.ContentEventNotification;
import com.liveperson.api.response.model.ContentType;
import com.liveperson.api.response.model.Event;
import com.liveperson.api.response.model.Participants;
import com.liveperson.infra.Infra;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging.R;
import com.liveperson.infra.model.Message;
import com.liveperson.infra.utils.EncryptionVersion;
import com.liveperson.messaging.background.filesharing.FileExtensionTypes;
import org.json.JSONException;
import org.json.JSONObject;

public class MessagingChatMessage
extends Message {
    private static final String TAG = "MessagingChatMessage";
    public static final String EXTRA_MESSAGE_STATE = "EXTRA_MESSAGE_STATE";
    public static final String EXTRA_SERVER_SEQUENCE = "EXTRA_SERVER_SEQUENCE";
    public static final String EXTRA_DIALOG_ID = "EXTRA_DIALOG_ID";
    private MessageType mMessageType;
    private MessageState mMessageState;

    public MessagingChatMessage(String originatorId, String message, long timeStamp, String dialogId, String eventId, MessageType messageType, MessageState messageState, EncryptionVersion encryptionVersion) {
        super(originatorId, message, timeStamp, dialogId, eventId, encryptionVersion);
        this.mMessageType = messageType;
        this.mMessageState = messageState;
    }

    public MessagingChatMessage(String originatorId, String message, long timeStamp, String dialogId, String eventId, MessageType mMessageType, MessageState mMessageState, int serverSequence, String contentType, EncryptionVersion encryptionVersion) {
        this(originatorId, message, timeStamp, dialogId, eventId, mMessageType, mMessageState, encryptionVersion);
        this.setContentType(contentType);
        this.setServerSequence(serverSequence);
    }

    public void setLocalId(long localId) {
        this.mId = localId;
    }

    public MessageType getMessageType() {
        return this.mMessageType;
    }

    public void setMessageType(MessageType messageType) {
        this.mMessageType = messageType;
    }

    public MessageState getMessageState() {
        return this.mMessageState;
    }

    public void setMessageState(MessageState messageState) {
        this.mMessageState = messageState;
    }

    public boolean isSystemMessageFromAgent(String myUserId) {
        return (this.getMessageType() == MessageType.SYSTEM_RESOLVED || this.getMessageType() == MessageType.SYSTEM_DIALOG_RESOLVED) && !TextUtils.equals((CharSequence)this.getOriginatorId(), (CharSequence)myUserId);
    }

    public boolean isFileType() {
        return this.mMessageType == MessageType.CONSUMER_IMAGE || this.mMessageType == MessageType.CONSUMER_DOCUMENT || this.mMessageType == MessageType.CONSUMER_IMAGE_MASKED || this.mMessageType == MessageType.CONSUMER_VOICE || this.mMessageType == MessageType.AGENT_IMAGE || this.mMessageType == MessageType.AGENT_DOCUMENT;
    }

    public Bundle update(MessagingChatMessage newChatMessage) {
        Bundle extras = new Bundle();
        if (this.mMessageState != newChatMessage.getMessageState()) {
            this.mMessageState = newChatMessage.getMessageState();
            extras.putInt(EXTRA_MESSAGE_STATE, this.mMessageState.ordinal());
        }
        if (this.getServerSequence() != newChatMessage.getServerSequence()) {
            this.setServerSequence(newChatMessage.getServerSequence());
            extras.putLong(EXTRA_SERVER_SEQUENCE, (long)this.getServerSequence());
        }
        if (!TextUtils.equals((CharSequence)this.getDialogId(), (CharSequence)newChatMessage.getDialogId())) {
            this.setDialogId(newChatMessage.getDialogId());
            extras.putString(EXTRA_DIALOG_ID, this.getDialogId());
        }
        if (!TextUtils.equals((CharSequence)this.getEventId(), (CharSequence)newChatMessage.getEventId())) {
            this.setEventId(newChatMessage.getEventId());
        }
        this.setMessageId(newChatMessage.getLocalId());
        this.setMessageType(newChatMessage.getMessageType());
        this.setContentType(newChatMessage.getContentType());
        return extras;
    }

    public String toString() {
        return "[MessageRowId " + this.getLocalId() + "\n" + super.toString() + "\nMessageType " + (Object)((Object)this.mMessageType) + "\nMessageState " + (Object)((Object)this.mMessageState) + "]";
    }

    public String getFormalMessage() {
        try {
            switch (this.mMessageType) {
                case AGENT_FORM: {
                    JSONObject jsonObject = new JSONObject(this.getMessage());
                    return jsonObject.getString("title");
                }
                case AGENT_STRUCTURED_CONTENT: {
                    return Infra.instance.getApplicationContext().getString(R.string.lp_new_message);
                }
                case AGENT_DOCUMENT: 
                case AGENT_IMAGE: {
                    return this.getMessage().isEmpty() ? Infra.instance.getApplicationContext().getString(R.string.lp_new_message) : this.getMessage();
                }
            }
            return this.getMessage();
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000A1, "JSONException while unpacking Agent Form.", (Throwable)e);
            return this.getMessage();
        }
    }

    public String getAccessibilityMessage(String accessibilityText) {
        try {
            switch (this.mMessageType) {
                case AGENT_FORM: {
                    JSONObject jsonObject = new JSONObject(this.getMessage());
                    return jsonObject.getString("title") + ". " + accessibilityText;
                }
                case AGENT_STRUCTURED_CONTENT: {
                    return "";
                }
                case AGENT_URL: {
                    return this.getMessage() + ". " + accessibilityText;
                }
                case AGENT_MARKDOWN_HYPERLINK: {
                    return accessibilityText;
                }
            }
            return this.getMessage();
        }
        catch (JSONException e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_000000A2, "JSONException while unpacking Agent Form.", (Throwable)e);
            return this.getMessage();
        }
    }

    public static enum MessageType {
        SYSTEM_RESOLVED,
        SYSTEM_DIALOG_RESOLVED,
        SYSTEM_MASKED,
        LOADING,
        UNREAD_INDICATOR,
        CONTROLLER_SYSTEM,
        BRAND,
        CONSUMER,
        CONSUMER_URL,
        CONSUMER_FORM,
        CONSUMER_MASKED,
        CONSUMER_IMAGE,
        CONSUMER_DOCUMENT,
        CONSUMER_IMAGE_MASKED,
        CONSUMER_URL_MASKED,
        CONSUMER_VOICE,
        AGENT,
        AGENT_URL,
        AGENT_IMAGE,
        AGENT_DOCUMENT,
        AGENT_FORM,
        AGENT_STRUCTURED_CONTENT,
        AGENT_IS_TYPING_INDICATOR,
        AGENT_QUICK_REPLIES,
        AGENT_MARKDOWN_HYPERLINK,
        COBROWSE;


        public static MessageType getMessageContentTypeForConsumer(ContentEventNotification event, ContentType messageContentType) {
            switch (messageContentType) {
                case hosted_file: {
                    MessageType fileMessageType = MessageType.getFileMessageType(event);
                    if (fileMessageType != null) {
                        return fileMessageType;
                    }
                    LPLog.INSTANCE.e(MessagingChatMessage.TAG, ErrorCode.ERR_0000009F, "getMessageContentTypeForConsumer: file extension not recognized. Return CONSUMER type");
                    return CONSUMER;
                }
                case forms_secure_submission: {
                    return CONSUMER_FORM;
                }
            }
            return CONSUMER;
        }

        @Nullable
        private static MessageType getFileMessageType(ContentEventNotification eventNotification) {
            Event event = eventNotification.event;
            if (event.message instanceof FilePublishMessage) {
                String relativePath = ((FilePublishMessage)event.message).getRelativePath();
                String extension = "";
                int i = relativePath.lastIndexOf(46);
                if (i >= 0) {
                    extension = relativePath.substring(i + 1).toLowerCase();
                }
                LPLog.INSTANCE.d(MessagingChatMessage.TAG, "getMessageContentTypeForConsumer: file extension: " + extension);
                if (FileExtensionTypes.getImageExtensions().contains(extension)) {
                    return eventNotification.originatorMetadata.mRole == Participants.ParticipantRole.CONSUMER ? CONSUMER_IMAGE : AGENT_IMAGE;
                }
                if (FileExtensionTypes.getDocumentExtensions().contains(extension)) {
                    return eventNotification.originatorMetadata.mRole == Participants.ParticipantRole.CONSUMER ? CONSUMER_DOCUMENT : AGENT_DOCUMENT;
                }
                if (FileExtensionTypes.getVoiceExtensions().contains(extension)) {
                    return CONSUMER_VOICE;
                }
            }
            return null;
        }

        public static MessageType getMessageContentTypeForAgent(ContentEventNotification notification, ContentType messageContentType) {
            switch (messageContentType) {
                case forms_secure_invitation: {
                    return AGENT_FORM;
                }
                case hosted_file: 
                case text_plain: 
                case text_html: {
                    if (messageContentType.isFile()) {
                        MessageType fileMessageType = MessageType.getFileMessageType(notification);
                        if (fileMessageType != null) {
                            return fileMessageType;
                        }
                        LPLog.INSTANCE.e(MessagingChatMessage.TAG, ErrorCode.ERR_000000A0, "getMessageContentTypeForAgent: file extension not recognized. Return Agent type");
                    }
                    return AGENT;
                }
            }
            return AGENT;
        }

        public static boolean isAgent(MessageType messageType) {
            return messageType == AGENT || messageType == AGENT_URL || messageType == AGENT_FORM || messageType == AGENT_STRUCTURED_CONTENT || messageType == AGENT_IS_TYPING_INDICATOR || messageType == AGENT_DOCUMENT || messageType == AGENT_IMAGE || messageType == AGENT_MARKDOWN_HYPERLINK;
        }

        public static boolean isConsumer(MessageType messageType) {
            return CONSUMER == messageType || CONSUMER_MASKED == messageType || LOADING == messageType || CONSUMER_IMAGE == messageType || CONSUMER_IMAGE_MASKED == messageType || CONSUMER_URL == messageType || CONSUMER_URL_MASKED == messageType || CONSUMER_FORM == messageType || CONSUMER_VOICE == messageType || CONSUMER_DOCUMENT == messageType;
        }

        public static boolean isConsumerMaskedMessage(MessageType messageType) {
            return messageType == CONSUMER_MASKED || messageType == CONSUMER_IMAGE_MASKED || messageType == CONSUMER_URL_MASKED;
        }

        public static boolean isSystem(MessageType messageType) {
            return messageType == SYSTEM_RESOLVED || messageType == SYSTEM_DIALOG_RESOLVED || messageType == SYSTEM_MASKED || messageType == BRAND || messageType == CONTROLLER_SYSTEM;
        }

        public static boolean isSystemResolved(MessageType messageType) {
            return messageType == SYSTEM_RESOLVED || messageType == SYSTEM_DIALOG_RESOLVED;
        }

        public static boolean isImage(MessageType messageType) {
            return messageType == CONSUMER_IMAGE || messageType == CONSUMER_IMAGE_MASKED || messageType == AGENT_IMAGE;
        }
    }

    public static enum MessageState {
        PENDING,
        SENT,
        RECEIVED,
        READ,
        ERROR,
        QUEUED,
        VIEWED,
        SUBMITTED,
        EXPIRED;


        public static boolean validChange(MessageState oldVal, MessageState newVal) {
            return oldVal == PENDING || oldVal == ERROR || oldVal == QUEUED && newVal != PENDING || newVal.ordinal() > oldVal.ordinal() && newVal != QUEUED;
        }

        public boolean isReceivedMessageNotRead() {
            return this == RECEIVED;
        }
    }
}

