/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.messaging.network.socket.requests;

import android.text.TextUtils;
import com.liveperson.api.request.BaseAMSSocketRequest;
import com.liveperson.api.request.ConsumerRequestConversation;
import com.liveperson.api.request.ReqBody;
import com.liveperson.api.request.RequestConversation;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.CampaignInfo;
import com.liveperson.infra.Infra;
import com.liveperson.infra.analytics.LPAnalytics;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.eventmanager.Event;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.network.socket.BaseResponseHandler;
import com.liveperson.infra.utils.LocaleUtils;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.model.ConversationData;
import com.liveperson.messaging.model.MessagingChatMessage;
import org.json.JSONException;
import org.json.JSONObject;

public class NewConversationRequest
extends BaseAMSSocketRequest<RequestConversation.Response, NewConversationRequest> {
    private static final String TAG = "NewConversationRequest";
    private final Messaging mController;
    private final String mBrandId;
    private final String mTargetId;
    private String appId = "";
    private TTRType ttrType = TTRType.NORMAL;
    private String mTempConversationId;
    private String mTempDialogId;
    private String mTransactionId;

    public NewConversationRequest(Messaging controller, String targetId, String brandId, String tempConversationId, String tempDialogId) {
        super(controller.mAccountsController.getConnectionUrl(brandId));
        this.mController = controller;
        this.mBrandId = brandId;
        this.mTargetId = targetId;
        this.mTempConversationId = tempConversationId;
        this.mTempDialogId = tempDialogId;
    }

    public NewConversationRequest setAppId(String appId) {
        this.appId = appId;
        return this;
    }

    public NewConversationRequest setTtrType(TTRType ttrType) {
        this.ttrType = ttrType;
        return this;
    }

    protected String getData() {
        CampaignInfo campaignInfo = this.mController.getConversationViewParams().getCampaignInfo();
        LPLog.INSTANCE.d(TAG, "getData: campaignInfo = " + campaignInfo);
        ConsumerRequestConversation requestConversation = new ConsumerRequestConversation(this.appId, this.ttrType, this.mBrandId, "", campaignInfo);
        String conversationJSON = requestConversation.toJsonString(this.getRequestId());
        this.mTransactionId = requestConversation.transactionId;
        LPAuthenticationParams params = this.mController.mAccountsController.getLPAuthenticationParams(this.mBrandId);
        if (params != null) {
            LPAnalytics.ConsumerAction.INSTANCE.trackRequestConversation(params.getAuthType(), LocaleUtils.getInstance().getLocaleCode(), requestConversation.isOutBoundCampaignConversation, requestConversation.isProactiveRichContent, this.mTransactionId);
        } else {
            LPLog.INSTANCE.d(TAG, "getLPAuthenticationParams: getLPAuthenticationParams returns null for brand with id: " + this.mBrandId);
        }
        return conversationJSON;
    }

    protected String getRequestName() {
        return TAG;
    }

    protected BaseResponseHandler<RequestConversation.Response, NewConversationRequest> getResponseHandler() {
        return new BaseResponseHandler<RequestConversation.Response, NewConversationRequest>(){

            public String getAPIResponseType() {
                return "cm.RequestConversationResponse";
            }

            protected RequestConversation.Response parse(JSONObject jsonObject) throws JSONException {
                return new RequestConversation.Response(jsonObject);
            }

            protected boolean handle(RequestConversation.Response data) {
                String conversationId = data.getBody().conversationId;
                if (data.code >= 200 && data.code < 300) {
                    LPLog.INSTANCE.d(NewConversationRequest.TAG, "Succeeded, create conversation response code: " + data.code);
                    NewConversationRequest.this.logNewConversationEvent(conversationId, true, null, null);
                } else {
                    LPLog.INSTANCE.e(NewConversationRequest.TAG, ErrorCode.ERR_000000AB, "Error, create conversation response code: " + data.code);
                    NewConversationRequest.this.logNewConversationEvent(conversationId, false, data.code, data.getBody().toString());
                }
                return true;
            }

            protected void giveUp() {
                super.giveUp();
                if (NewConversationRequest.this.isConversationWaitingForResponse()) {
                    LPLog.INSTANCE.e(NewConversationRequest.TAG, ErrorCode.ERR_000000AC, NewConversationRequest.this.getRequestId() + ": Request lost (socket closed) for newConversationRequest, Changing all messages of this conversation to error state");
                    NewConversationRequest.this.failConversationAnsMessages();
                }
            }

            public BaseResponseHandler getResponseByExpectedType(String expectedType) {
                BaseResponseHandler supportedResponseHandler = this.getSupportedResponseHandler(expectedType);
                if (supportedResponseHandler != null) {
                    return supportedResponseHandler;
                }
                return this;
            }

            protected BaseResponseHandler getSupportedResponseHandler(String messageType) {
                if (TextUtils.equals((CharSequence)messageType, (CharSequence)"StringResponse")) {
                    return new BaseResponseHandler<ReqBody.StringResp, NewConversationRequest>(){

                        protected ReqBody.StringResp parse(JSONObject jsonObject) throws JSONException {
                            return new ReqBody.StringResp(jsonObject);
                        }

                        public String getAPIResponseType() {
                            return "StringResponse";
                        }

                        protected boolean handle(ReqBody.StringResp response) {
                            LPLog.INSTANCE.i(NewConversationRequest.TAG, "Received String response (" + response.code + ").");
                            if (response.code >= 400) {
                                LPLog.INSTANCE.e(NewConversationRequest.TAG, ErrorCode.ERR_000000AD, "Bad response (" + response.code + ") for newConversationRequest, Changing all messages of this conversation to error state\nString response: " + LPLog.INSTANCE.mask((Object)response));
                                NewConversationRequest.this.failConversationAnsMessages();
                                return true;
                            }
                            return false;
                        }
                    };
                }
                return super.getSupportedResponseHandler(messageType);
            }
        };
    }

    private void failConversationAnsMessages() {
        ConversationData conversationData = new ConversationData();
        conversationData.requestId = this.getRequestId();
        conversationData.conversationId = this.mTempConversationId;
        conversationData.brandId = this.mBrandId;
        conversationData.targetId = this.mTargetId;
        this.mController.amsConversations.updateClosedConversation(conversationData, false).execute();
        this.mController.amsDialogs.updateClosedDialog(conversationData, false).execute();
        this.mController.amsMessages.updateAllMessagesStateByDialogId(this.mTempDialogId, MessagingChatMessage.MessageState.ERROR);
    }

    private boolean isConversationWaitingForResponse() {
        return this.mController.amsConversations.getConversation(this.mTargetId) != null && this.mController.amsConversations.getConversation(this.mTargetId).getConversationId().equals(this.mTempConversationId);
    }

    private void logNewConversationEvent(String conversationId, boolean isSuccess, Integer code, String error) {
        try {
            String errorCode = null;
            if (code != null) {
                errorCode = String.valueOf(code);
            }
            Infra.instance.getEventManagerService().setConversationId(conversationId).logEvent(this.mBrandId, this.mTransactionId, isSuccess, Event.CONVERSATION, errorCode, error, this.mController.getApplicationContext());
            LPAuthenticationParams params = this.mController.mAccountsController.getLPAuthenticationParams(this.mBrandId);
            if (params != null) {
                LPAnalytics.ConsumerAction.INSTANCE.trackStartNewConversation(params.getAuthType(), LocaleUtils.getInstance().getLocaleCode(), isSuccess, conversationId, this.mTransactionId, error);
            } else {
                LPLog.INSTANCE.i(TAG, "getLPAuthenticationParams: getLPAuthenticationParams returns null for brand with id: " + this.mBrandId);
            }
        }
        catch (Exception e) {
            LPLog.INSTANCE.i(TAG, "Failed to log new conversation event: " + e);
        }
    }
}

