/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import androidx.annotation.BoolRes;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.view.MenuItemCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransaction;
import com.liveperson.api.response.types.TTRType;
import com.liveperson.infra.ConversationViewParams;
import com.liveperson.infra.LPConversationsHistoryStateToDisplay;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.callbacks.InitLivePersonCallBack;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.MessagingUIFactory;
import com.liveperson.infra.messaging_ui.MessagingUiInitData;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.dialog.ClearHistoryConfirmationDialog;
import com.liveperson.infra.messaging_ui.dialog.ConversationIsActiveWarningDialog;
import com.liveperson.infra.messaging_ui.fragment.ConversationFragment;
import com.liveperson.infra.messaging_ui.fragment.ConversationFragmentCallbacks;
import com.liveperson.infra.messaging_ui.fragment.FullImageFragment;
import com.liveperson.infra.messaging_ui.fragment.IFeedbackActions;
import com.liveperson.infra.messaging_ui.toolbar.CaptionPreviewToolBar;
import com.liveperson.infra.messaging_ui.toolbar.CobrowseToolBar;
import com.liveperson.infra.messaging_ui.toolbar.ConversationToolBar;
import com.liveperson.infra.messaging_ui.toolbar.SecuredFormToolBar;
import com.liveperson.infra.messaging_ui.uicomponents.MessagingUIUtils;
import com.liveperson.infra.messaging_ui.utils.ConversationStateHandler;
import com.liveperson.infra.ui.view.uicomponents.IConnectionChangedCustomView;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.messaging.Messaging;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.model.Conversation;
import java.util.List;

public class ConversationActivity
extends AppCompatActivity
implements ConversationFragmentCallbacks,
IConnectionChangedCustomView {
    private static final String TAG = ConversationActivity.class.getSimpleName();
    public static final String INTENT_ACTION = "conversation action";
    public static final int TYPE_CLOSE_CHAT = 17771;
    private ConversationFragment mConversationFragment;
    private ConversationToolBar mToolBar;
    private SecuredFormToolBar mToolBarPCI;
    private CaptionPreviewToolBar mToolBarCaptionPreview;
    private CobrowseToolBar cobrowseToolBar;
    private MessagingUIUtils mMessagingUiUtils;
    private String brandId;
    private String mCurrentAgentId;
    private Boolean mClearHistoryMenuEnabled = true;
    private boolean mConversationConnected = false;
    private boolean mReadOnly = false;
    private LPConversationsHistoryStateToDisplay conversationsHistoryStateToDisplay;
    private View.OnClickListener mOnAvatarClickListener = v -> {
        String agentId = this.mCurrentAgentId;
        if (!TextUtils.isEmpty((CharSequence)agentId)) {
            MessagingUIFactory.getInstance().onAgentAvatarTapped(agentId);
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        int action;
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.lpmessaging_ui_activity_conversation);
        Intent startingIntent = this.getIntent();
        if (startingIntent != null && (action = startingIntent.getIntExtra(INTENT_ACTION, -1)) == 17771) {
            this.finish();
            return;
        }
        this.brandId = this.getIntent().getStringExtra("brand_id");
        final LPAuthenticationParams lpAuthenticationParams = (LPAuthenticationParams)this.getIntent().getParcelableExtra("auth_key");
        final ConversationViewParams conversationViewParams = (ConversationViewParams)this.getIntent().getParcelableExtra("view_params");
        this.mReadOnly = conversationViewParams.isViewOnlyMode();
        this.conversationsHistoryStateToDisplay = conversationViewParams.getHistoryConversationsStateToDisplay();
        this.initToolbar(this.brandId);
        LPLog.INSTANCE.w(TAG, "### DEVICE_FAMILY: DeviceFamily.MOBILE.name");
        LPLog.INSTANCE.w(TAG, "### OS_NAME: android");
        LPLog.INSTANCE.w(TAG, "### OS_VERSION: " + Build.VERSION.SDK_INT);
        LPLog.INSTANCE.w(TAG, "### INTEGRATION: Integration.MOBILE_SDK");
        LPLog.INSTANCE.w(TAG, "### OS_VERSION: " + Build.VERSION.CODENAME);
        MessagingUIFactory.getInstance().init(this.getApplicationContext(), new MessagingUiInitData(new InitLivePersonCallBack(){

            public void onInitSucceed() {
                ConversationActivity.this.runOnUiThread(() -> ConversationActivity.this.initFragment(ConversationActivity.this.brandId, lpAuthenticationParams, conversationViewParams));
            }

            public void onInitFailed(Exception e) {
            }
        }, this.brandId, null));
        MessagingFactory.getInstance().getController().setConversationViewParams(conversationViewParams);
    }

    protected void onPostCreate(@Nullable Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        this.changeBackground();
    }

    private void changeBackground() {
        Bitmap background = BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.drawable.conversation_background);
        if (null != background) {
            this.getWindow().setBackgroundDrawable(ImageUtils.createImageOnCanvas((Activity)this, (WindowManager)this.getWindowManager(), (Bitmap)background));
        }
    }

    private void initToolbar(String brandId) {
        this.mToolBar = (ConversationToolBar)this.findViewById(R.id.lpui_tool_bar);
        this.mToolBarPCI = (SecuredFormToolBar)this.findViewById(R.id.lpui_tool_bar_pci);
        this.mToolBarCaptionPreview = (CaptionPreviewToolBar)this.findViewById(R.id.lpui_tool_bar_caption_preview);
        this.cobrowseToolBar = (CobrowseToolBar)this.findViewById(R.id.lpui_tool_bar_cobrowse);
        this.mToolBarPCI.setVisibility(8);
        this.mToolBarCaptionPreview.setVisibility(8);
        this.cobrowseToolBar.setVisibility(8);
        this.mToolBar.setVisibility(0);
        this.mToolBar.setBrandId(brandId);
        this.mToolBar.setConversationsHistoryStateToDisplay(this.conversationsHistoryStateToDisplay);
        this.setTitle(this.getApplicationName());
        this.mToolBar.setTitle("");
        this.setSupportActionBar(this.mToolBar);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.mToolBar.setNavigationOnClickListener(v -> {
            InputMethodManager inputMethodManager = (InputMethodManager)this.getSystemService("input_method");
            inputMethodManager.hideSoftInputFromWindow(v.getWindowToken(), 0);
            this.onBackPressed();
        });
        this.mToolBar.onInitCompleted();
    }

    protected void setPCIToolbar(String formTitle) {
        this.runOnUiThread(() -> {
            this.mToolBar.setVisibility(8);
            this.mToolBarPCI.setVisibility(0);
            this.mToolBarPCI.setAgentName(formTitle);
            this.mToolBarPCI.sendAccessibilityEvent(8);
            this.setTitle(this.getApplicationName());
            this.mToolBarPCI.setTitle("");
            this.mToolBarPCI.setNavigationContentDescription(R.string.lp_tool_bar_close_button_description);
            this.mToolBarPCI.setNavigationIcon(this.getResources().getDrawable(R.drawable.lpinfra_close_btn));
            this.mToolBarPCI.setNavigationOnClickListener(v -> this.onBackPressed());
        });
    }

    protected void setCobrowseToolbar() {
        this.runOnUiThread(() -> {
            this.mToolBar.setVisibility(8);
            this.mToolBarPCI.setVisibility(8);
            this.cobrowseToolBar.setVisibility(0);
            this.cobrowseToolBar.sendAccessibilityEvent(8);
            this.cobrowseToolBar.setTitle("");
            this.cobrowseToolBar.setNavigationContentDescription(R.string.lp_accessibility_message_preview_close_description);
            this.cobrowseToolBar.setNavigationIcon(this.getResources().getDrawable(R.drawable.lpinfra_close_btn));
            this.cobrowseToolBar.setNavigationOnClickListener(v -> this.onBackPressed());
        });
    }

    private void setCaptionPreviewToolBar(String title) {
        this.runOnUiThread(() -> {
            this.mToolBar.setVisibility(8);
            this.mToolBarCaptionPreview.setVisibility(0);
            this.mToolBarCaptionPreview.setTitle(title);
            this.setSupportActionBar(this.mToolBarCaptionPreview);
            if (this.getSupportActionBar() != null) {
                this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
                this.getSupportActionBar().setDisplayShowTitleEnabled(true);
            }
            this.mToolBarCaptionPreview.setNavigationOnClickListener(v -> this.onBackPressed());
        });
    }

    public boolean onKeyDown(int keycode, KeyEvent e) {
        if (keycode == 82) {
            return true;
        }
        return super.onKeyDown(keycode, e);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        if (MessagingUIFactory.getInstance().isInitialized()) {
            MenuInflater inflater = this.getMenuInflater();
            inflater.inflate(R.menu.lpmessaging_ui_item_conversation_actions_menu, menu2);
        }
        this.setupMenu(menu2);
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu2) {
        if (this.mReadOnly) {
            this.disableOptionsMenu();
            return false;
        }
        if (this.getConversationChildFragmentVisibility(FullImageFragment.TAG) || this.getConversationChildFragmentVisibility("CaptionPreviewFragment")) {
            this.disableOptionsMenu();
            return false;
        }
        if (MessagingUIFactory.getInstance().isInitialized()) {
            Conversation conversation = MessagingFactory.getInstance().getController().amsConversations.getConversation(this.brandId);
            boolean conversationActive = MessagingFactory.getInstance().getController().amsConversations.isConversationActive(this.brandId);
            boolean canDialogChangeTTR = MessagingFactory.getInstance().getController().canActiveDialogChangeTTR();
            TTRType ttrType = conversation != null ? conversation.getConversationTTRType() : TTRType.NORMAL;
            this.updateTTRActionsInMenu(menu2, ttrType, this.mConversationConnected, conversationActive && canDialogChangeTTR);
            menu2.findItem(R.id.lp_menu_item_resolve).setEnabled(this.mConversationConnected && conversationActive);
            menu2.findItem(R.id.lp_menu_item_clear_history).setEnabled(this.mClearHistoryMenuEnabled.booleanValue());
        }
        return super.onPrepareOptionsMenu(menu2);
    }

    private void clearListeners() {
        if (this.mToolBar != null) {
            this.mToolBar.setNavigationOnClickListener(null);
        }
        if (this.mToolBarPCI != null) {
            this.mToolBarPCI.setNavigationOnClickListener(null);
        }
        if (this.mToolBarCaptionPreview != null) {
            this.mToolBarCaptionPreview.setNavigationOnClickListener(null);
        }
        if (this.cobrowseToolBar != null) {
            this.cobrowseToolBar.setNavigationOnClickListener(null);
        }
    }

    private void updateTTRActionsInMenu(Menu menu2, TTRType type, boolean connected, boolean conversationActive) {
        if (type == TTRType.URGENT) {
            this.setMenuItemVisibility(menu2, R.id.lp_menu_item_mark_urgent, false);
            this.setMenuItemVisibility(menu2, R.id.lp_menu_item_dismiss_urgent, R.bool.lp_urgency_menu_item_visible);
            this.setMenuItemEnable(menu2, R.id.lp_menu_item_dismiss_urgent, connected && conversationActive);
        } else {
            this.setMenuItemVisibility(menu2, R.id.lp_menu_item_dismiss_urgent, false);
            this.setMenuItemVisibility(menu2, R.id.lp_menu_item_mark_urgent, R.bool.lp_urgency_menu_item_visible);
            this.setMenuItemEnable(menu2, R.id.lp_menu_item_mark_urgent, connected && conversationActive);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == R.id.lp_menu_item_mark_urgent || itemId == R.id.lp_menu_item_dismiss_urgent) {
            this.onMarkAsUrgentClick(MessagingFactory.getInstance().getController());
        } else if (itemId == R.id.lp_menu_item_resolve) {
            this.onResolveConversationClick();
        } else if (itemId == R.id.lp_menu_item_clear_history) {
            this.onClearHistoryClicked();
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onResolveConversationClick() {
        this.getUiUtils().showResolveDialog((Context)this, this.brandId);
    }

    protected void onMarkAsUrgentClick(Messaging controller) {
        Conversation conversation = controller.amsConversations.getConversation(this.brandId);
        if (conversation.getConversationTTRType() == TTRType.URGENT) {
            this.getUiUtils().showMarkAsNormalDialog((Context)this, conversation.getTargetId(), this.brandId);
        } else {
            this.getUiUtils().showMarkAsUrgentDialog((Context)this, conversation.getTargetId(), this.brandId);
        }
    }

    protected void onClearHistoryClicked() {
        if (MessagingFactory.getInstance().getController().amsConversations.isConversationActive(this.brandId)) {
            ConversationIsActiveWarningDialog conversationIsActiveWarningDialog = ConversationIsActiveWarningDialog.getInstance();
            conversationIsActiveWarningDialog.show(this.getFragmentManager(), TAG);
        } else {
            boolean mShowClearHistoryConfirmation = Configuration.getBoolean((int)R.bool.clear_history_show_confirm_dialog);
            if (mShowClearHistoryConfirmation) {
                ClearHistoryConfirmationDialog clearHistoryConfirmationDialog = ClearHistoryConfirmationDialog.getInstance(this.brandId);
                clearHistoryConfirmationDialog.show(this.getFragmentManager(), TAG);
            } else {
                MessagingFactory.getInstance().getController().clearHistory(this.brandId);
            }
        }
    }

    private void initFragment(String brandId, LPAuthenticationParams lpAuthenticationParams, ConversationViewParams conversationViewParams) {
        this.mConversationFragment = (ConversationFragment)this.getSupportFragmentManager().findFragmentByTag("ConversationFragment");
        if (this.mConversationFragment == null) {
            this.mConversationFragment = ConversationFragment.newInstance(brandId, lpAuthenticationParams, conversationViewParams, true);
            if (this.isValidState()) {
                FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
                ft.add(R.id.lpui_fragment_container, (Fragment)this.mConversationFragment, "ConversationFragment").commitAllowingStateLoss();
            }
        } else {
            this.attachFragment();
        }
    }

    private void attachFragment() {
        if (this.mConversationFragment != null && this.mConversationFragment.isDetached()) {
            LPLog.INSTANCE.d(TAG, "initFragment. attaching fragment");
            if (this.isValidState()) {
                FragmentTransaction ft = this.getSupportFragmentManager().beginTransaction();
                ft.show((Fragment)this.mConversationFragment).commitAllowingStateLoss();
            }
        } else {
            LPLog.INSTANCE.i(TAG, "Is conversation fragment equals to null?: " + (this.mConversationFragment == null));
        }
    }

    private boolean isValidState() {
        return !this.isFinishing() && !this.isDestroyed();
    }

    protected void onStart() {
        super.onStart();
        if (ConversationStateHandler.isHideConversationCalledInBackground()) {
            ConversationStateHandler.setIsHideConversationCalledInBackground(false);
            this.finish();
        }
    }

    protected void onResume() {
        super.onResume();
        if (this.mConversationFragment != null) {
            this.attachFragment();
        }
        this.mToolBar.setOnAvatarIconClickListener(this.mOnAvatarClickListener);
    }

    protected void onPause() {
        this.mToolBar.setOnAvatarIconClickListener(null);
        super.onPause();
    }

    protected void onDestroy() {
        this.clearListeners();
        super.onDestroy();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        int action = intent.getIntExtra(INTENT_ACTION, -1);
        if (action == 17771) {
            this.mConversationFragment.onConversationFragmentClosed();
            this.finish();
        }
    }

    public void onBackPressed() {
        if (this.mConversationFragment == null || !this.mConversationFragment.onBackPressed()) {
            super.onBackPressed();
        }
    }

    private boolean getConversationChildFragmentVisibility(String tag) {
        List activityFragments = this.getSupportFragmentManager().getFragments();
        if (!activityFragments.isEmpty()) {
            Fragment childFragment = ((Fragment)activityFragments.get(0)).getChildFragmentManager().findFragmentByTag(tag);
            return childFragment != null && childFragment.isVisible();
        }
        return false;
    }

    @Override
    public void setFeedBackMode(boolean feedBackMode, IFeedbackActions actions) {
        this.mToolBar.setFeedBackMode(feedBackMode, actions);
        this.mClearHistoryMenuEnabled = !feedBackMode;
        this.invalidateOptionsMenu();
        if (this.getConversationChildFragmentVisibility(FullImageFragment.TAG) && !feedBackMode) {
            this.setFullImageMode(true);
        }
    }

    @Override
    public void setSecureFormMode(boolean on, String formTitle) {
        if (on) {
            this.setPCIToolbar(formTitle);
        } else {
            this.initToolbar(this.brandId);
        }
    }

    @Override
    public void setCaptionPreviewMode(boolean on, String title) {
        if (on) {
            this.setCaptionPreviewToolBar(title);
        } else {
            this.initToolbar(this.brandId);
        }
    }

    @Override
    public void setCobrowseMode(boolean on) {
        if (on) {
            this.setCobrowseToolbar();
        } else {
            this.initToolbar(this.brandId);
        }
    }

    private void disableOptionsMenu() {
        if (this.mToolBar.getMenu().hasVisibleItems()) {
            this.mToolBar.getMenu().findItem(R.id.lp_menu_item_mark_urgent).setVisible(false);
            this.mToolBar.getMenu().findItem(R.id.lp_menu_item_resolve).setVisible(false);
            this.mToolBar.getMenu().findItem(R.id.lp_menu_item_clear_history).setVisible(false);
            this.mToolBar.getMenu().findItem(R.id.lp_menu_item_dismiss_urgent).setVisible(false);
        }
    }

    @Override
    public void setFullImageMode(boolean fullImageMode) {
        this.mToolBar.setFullImageMode(fullImageMode);
        if (fullImageMode) {
            this.mToolBar.announceBackButtonForAccessibility();
        }
        this.invalidateOptionsMenu();
    }

    @Override
    public void onSurveySubmitted(IFeedbackActions actions) {
        this.mToolBar.onSurveySubmitted(actions);
    }

    public MessagingUIUtils getUiUtils() {
        if (this.mMessagingUiUtils == null) {
            this.mMessagingUiUtils = new MessagingUIUtils(MessagingFactory.getInstance().getController());
        }
        return this.mMessagingUiUtils;
    }

    public void onConnectionChanged(boolean isConnected) {
        this.mConversationConnected = isConnected;
        this.invalidateOptionsMenu();
    }

    @Override
    public void hideConversationToolBar(boolean shouldHide) {
        FrameLayout frameLayout = (FrameLayout)this.findViewById(R.id.lpui_fragment_container);
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)frameLayout.getLayoutParams();
        if (shouldHide) {
            this.mToolBar.setVisibility(8);
            params.setMargins(0, 0, 0, 0);
        } else if (this.mToolBar.getVisibility() == 8) {
            this.initToolbar(this.brandId);
            params.setMargins(0, this.mToolBar.getHeight(), 0, 0);
        }
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    @Override
    public void updateAgentDetails(String nickName, String avatarUrl) {
        if (this.mToolBar != null) {
            this.mToolBar.updateAgentDetails(nickName, avatarUrl);
        }
    }

    @Override
    public void updateAgentTypingIndication(boolean isTyping) {
        if (this.mToolBar != null) {
            this.mToolBar.setIsTyping(isTyping);
        }
    }

    @Override
    public void updateCurrentConversationAgentId(String agentId) {
        this.mCurrentAgentId = agentId;
    }

    @NonNull
    private String getApplicationName() {
        ApplicationInfo applicationInfo = this.getApplicationInfo();
        int stringId = applicationInfo.labelRes;
        return stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : this.getString(stringId);
    }

    private void setupMenu(@NonNull Menu menu2) {
        this.setMenuItemVisibility(menu2, R.id.lp_menu_item_mark_urgent, R.bool.lp_urgency_menu_item_visible);
        this.setMenuItemVisibility(menu2, R.id.lp_menu_item_dismiss_urgent, R.bool.lp_urgency_menu_item_visible);
        this.setMenuItemVisibility(menu2, R.id.lp_menu_item_clear_history, R.bool.clear_history_menu_item_visible);
        this.setMenuItemVisibility(menu2, R.id.lp_menu_item_resolve, R.bool.lp_resolve_conversation_menu_item_visible);
    }

    private void setMenuItemVisibility(@NonNull Menu menu2, @IdRes int menuItemId, @BoolRes int configurationId) {
        this.setMenuItemVisibility(menu2, menuItemId, Configuration.getBoolean((int)configurationId));
    }

    private void setMenuItemVisibility(@NonNull Menu menu2, @IdRes int menuItemId, boolean isVisible) {
        MenuItem item = menu2.findItem(menuItemId);
        if (item != null) {
            item.setVisible(isVisible);
            if (isVisible) {
                String description = this.getString(R.string.lp_menu_item_content_description, new Object[]{item.getTitle(), this.getString(R.string.lp_accessibility_sc_button)});
                MenuItemCompat.setContentDescription((MenuItem)item, (CharSequence)description);
            }
        }
    }

    private void setMenuItemEnable(@NonNull Menu menu2, @IdRes int menuItemId, boolean isEnabled) {
        MenuItem item = menu2.findItem(menuItemId);
        if (item != null) {
            item.setEnabled(isEnabled);
        }
    }
}

