/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.fragment.app.Fragment;
import com.liveperson.infra.Clearable;
import com.liveperson.infra.ConversationViewParams;
import com.liveperson.infra.ForegroundService;
import com.liveperson.infra.PushUnregisterType;
import com.liveperson.infra.auth.LPAuthenticationParams;
import com.liveperson.infra.callbacks.InitLivePersonCallBack;
import com.liveperson.infra.callbacks.LogoutLivePersonCallBack;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.ConversationActivity;
import com.liveperson.infra.messaging_ui.IMessagingUi;
import com.liveperson.infra.messaging_ui.MessagingUiInitData;
import com.liveperson.infra.messaging_ui.fragment.ConversationFragment;
import com.liveperson.infra.messaging_ui.notification.NotificationController;
import com.liveperson.infra.messaging_ui.utils.ConversationStateHandler;
import com.liveperson.infra.sdkstatemachine.logout.PreLogoutCompletionListener;
import com.liveperson.infra.sdkstatemachine.shutdown.ShutDownCompletionListener;
import com.liveperson.infra.statemachine.InitProcess;
import com.liveperson.infra.statemachine.LogoutProcess;
import com.liveperson.infra.statemachine.ShutDownProcess;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.MessagingInitData;
import com.liveperson.messaging.model.AgentData;

public class MessagingUi
implements IMessagingUi,
Clearable {
    protected static final String TAG = "MessagingUi";
    private String mInitBrandId;

    @Override
    public void init(Context context, final MessagingUiInitData initData) {
        LPLog.INSTANCE.d(TAG, "init: Infra module version = 5.21.0");
        LPLog.INSTANCE.d(TAG, "init: UI module version = 5.21.0");
        LPLog.INSTANCE.d(TAG, "init: Messaging module version = 5.21.0");
        LPLog.INSTANCE.d(TAG, "init: MessagingUi module version = 5.21.0");
        MessagingFactory.getInstance().init(context, (MessagingInitData)initData, new InitProcess(){

            public InitLivePersonCallBack getInitCallback() {
                return initData.getInitCallBack();
            }

            public void init() {
                LPLog.INSTANCE.d(MessagingUi.TAG, "Initializing...");
                MessagingUi.this.mInitBrandId = initData.getBrandId();
            }
        });
    }

    public String getInitBrandId() {
        return this.mInitBrandId;
    }

    @Override
    public void shutDown(final ShutDownCompletionListener shutDownCompletionListener) {
        if (ForegroundService.getInstance().isBrandForeground()) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000010C, "shutDown: messaging is in the foreground. Cannot shutdown");
            if (shutDownCompletionListener != null) {
                shutDownCompletionListener.shutDownFailed();
            }
            return;
        }
        MessagingFactory.getInstance().shutDown(new ShutDownProcess(){

            public void shutDown(ShutDownCompletionListener listener) {
                LPLog.INSTANCE.d(MessagingUi.TAG, "Shutting down...");
                listener.shutDownCompleted();
                if (shutDownCompletionListener != null) {
                    shutDownCompletionListener.shutDownCompleted();
                }
            }
        });
    }

    public void clear() {
        NotificationController.instance.clear();
    }

    @Override
    public Fragment getConversationFragment(String brandId, LPAuthenticationParams lpAuthenticationParams, ConversationViewParams params) {
        MessagingFactory.getInstance().getController().setConversationViewParams(params);
        return ConversationFragment.newInstance(brandId, lpAuthenticationParams, params, false);
    }

    @Override
    public boolean showConversation(Activity activity, String brandId, LPAuthenticationParams lpAuthenticationParams, ConversationViewParams params) {
        Intent showIntent = new Intent((Context)activity, ConversationActivity.class);
        showIntent.putExtra("brand_id", brandId);
        showIntent.putExtra("auth_key", (Parcelable)lpAuthenticationParams);
        showIntent.putExtra("view_params", (Parcelable)params);
        if (MessagingFactory.getInstance().getController().getImageServicePendingIntent() == null) {
            Intent notificationIntent = new Intent((Context)activity, ConversationActivity.class);
            notificationIntent.putExtra("brand_id", brandId);
            notificationIntent.putExtra("auth_key", (Parcelable)lpAuthenticationParams);
            notificationIntent.putExtra("view_params", (Parcelable)params);
            notificationIntent.setFlags(0x10000000);
            int intentFlags = 0;
            if (Build.VERSION.SDK_INT >= 31) {
                intentFlags = 0x4000000;
            }
            PendingIntent pendingIntent = PendingIntent.getActivity((Context)activity, (int)0, (Intent)notificationIntent, (int)intentFlags);
            MessagingFactory.getInstance().getController().setImageServicePendingIntent(pendingIntent);
        }
        activity.startActivity(showIntent);
        return true;
    }

    @Override
    public void hideConversation(Activity activity) {
        if (!ConversationStateHandler.isConversationInBackground()) {
            Intent hideIntent = new Intent((Context)activity, ConversationActivity.class);
            hideIntent.putExtra("conversation action", 17771);
            activity.startActivity(hideIntent);
        } else if (ConversationStateHandler.isConversationFragmentRunning()) {
            ConversationStateHandler.setIsHideConversationCalledInBackground(true);
        }
    }

    @Override
    public void onAgentAvatarTapped(String agentOriginatorId) {
        if (TextUtils.isEmpty((CharSequence)agentOriginatorId)) {
            return;
        }
        MessagingFactory.getInstance().getController().amsUsers.getUserById(agentOriginatorId).setPostQueryOnBackground(data -> {
            AgentData agentData = new AgentData();
            if (data != null) {
                agentData.mFirstName = data.getFirstName();
                agentData.mLastName = data.getLastName();
                agentData.mAvatarURL = data.getAvatarUrl();
                agentData.mEmployeeId = data.getDescription();
                agentData.mNickName = data.getNickname();
                agentData.mAgentId = agentOriginatorId;
            }
            MessagingFactory.getInstance().getController().mEventsProxy.onAgentAvatarTapped(agentData);
        }).execute();
    }

    @Override
    public void logout(Context context, MessagingUiInitData initData, boolean forceLogOut, PushUnregisterType type, final LogoutLivePersonCallBack logoutLivePersonCallBack) {
        MessagingFactory.getInstance().logout(context, (MessagingInitData)initData, forceLogOut, type, new LogoutProcess(){

            public void initForLogout() {
                LPLog.INSTANCE.d(MessagingUi.TAG, "initForLogout...");
            }

            public void preLogout(PreLogoutCompletionListener listener) {
                listener.preLogoutCompleted();
            }

            public void shutDownForLogout(ShutDownCompletionListener listener) {
                listener.shutDownCompleted();
            }

            public void logout() {
                MessagingUi.this.clear();
            }

            public LogoutLivePersonCallBack getLogoutCallback() {
                return logoutLivePersonCallBack;
            }
        });
    }

    @Override
    public boolean isInitialized() {
        return MessagingFactory.getInstance().isInitialized();
    }
}

