/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.fragment;

import android.content.Context;
import android.graphics.PorterDuff;
import android.net.Uri;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ImageSwitcher;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.fragment.NestedFragmentsContainerCallbacks;
import com.liveperson.infra.utils.DocumentUtils;
import com.liveperson.infra.utils.ImageUtils;
import com.liveperson.infra.utils.PicassoUtils;
import com.liveperson.messaging.MessagingFactory;
import com.liveperson.messaging.background.filesharing.FileSharingType;
import com.liveperson.messaging.utils.FileSharingUtils;
import com.squareup.picasso.MemoryPolicy;
import com.squareup.picasso.NetworkPolicy;
import java.io.File;

public class CaptionPreviewFragment
extends Fragment {
    public static final String TAG = "CaptionPreviewFragment";
    public static final String BRAND_ID = "BRAND_ID";
    public static final String IMAGE_URI = "IMAGE_URI";
    public static final String IMAGE_ORIENTATION = "IMAGE_ORIENTATION";
    public static final String IMAGE_FROM_CAMERA = "IMAGE_FROM_CAMERA";
    private String mBrandId;
    private EditText mCaptionEditText;
    private Button mTextSendButton;
    private ImageButton mImageSendButton;
    private TextView mLabelTextView;
    private TextView mFileNameTextView;
    private ImageView mPreviewImage;
    private String mImageUriString;
    private boolean mImageFromCamera;
    private int mOrientation;
    private FileSharingType mFileType;
    private String formTitle;
    private boolean isFileUploaded;
    private NestedFragmentsContainerCallbacks mNestedFragmentsContainerCallbacks;

    public static CaptionPreviewFragment newInstance(String brandId, String imageUri, int orientation, boolean imageFromCamera) {
        Bundle args = new Bundle();
        args.putString(BRAND_ID, brandId);
        args.putString(IMAGE_URI, imageUri);
        args.putInt(IMAGE_ORIENTATION, orientation);
        args.putBoolean(IMAGE_FROM_CAMERA, imageFromCamera);
        CaptionPreviewFragment fragment = new CaptionPreviewFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mBrandId = this.getArguments().getString(BRAND_ID);
            this.mImageUriString = this.getArguments().getString(IMAGE_URI);
            this.mOrientation = this.getArguments().getInt(IMAGE_ORIENTATION, 0);
            this.mImageFromCamera = this.getArguments().getBoolean(IMAGE_FROM_CAMERA, false);
            LPLog.INSTANCE.d(TAG, "onCreate: Displaying preview image with URI: " + this.mImageUriString);
        }
        this.mFileType = FileSharingUtils.getFileSharingTypeFromUri((String)this.mImageUriString, (Context)this.getActivity());
        this.formTitle = FileSharingUtils.isDocumentType((FileSharingType)this.mFileType) ? this.getString(R.string.lp_send_document) : this.getString(R.string.lp_send_photo);
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.lpmessaging_ui_fragment_caption_preview, container, false);
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mPreviewImage = (ImageView)view.findViewById(R.id.lpui_caption_preview_image);
        this.mFileNameTextView = (TextView)view.findViewById(R.id.lpui_caption_preview_text);
        this.mCaptionEditText = (EditText)view.findViewById(R.id.lpui_enter_message_text);
        ImageSwitcher attachmentMenu = (ImageSwitcher)view.findViewById(R.id.lpui_attach_file);
        attachmentMenu.setVisibility(8);
        this.mTextSendButton = (Button)view.findViewById(R.id.lpui_enter_message_send);
        this.mImageSendButton = (ImageButton)view.findViewById(R.id.lpui_enter_message_send_button);
        this.mLabelTextView = (TextView)view.findViewById(R.id.lpui_id_for_enter_text);
        this.setControlsPreferences();
        this.displayFilePreview();
    }

    private void setControlsPreferences() {
        this.mTextSendButton.setEnabled(true);
        this.mImageSendButton.setEnabled(true);
        this.mTextSendButton.setTextColor(ContextCompat.getColor((Context)this.requireContext(), (int)R.color.lp_send_button_text_enable));
        this.mImageSendButton.getDrawable().setColorFilter(ContextCompat.getColor((Context)this.requireContext(), (int)R.color.lp_send_button_text_enable), PorterDuff.Mode.SRC_IN);
        View.OnClickListener sendButtonClickListener = view -> {
            view.performAccessibilityAction(128, null);
            this.startFileUpload();
        };
        if (Configuration.getBoolean((int)R.bool.use_send_image_button)) {
            this.mImageSendButton.setVisibility(0);
            this.mTextSendButton.setVisibility(8);
            this.mImageSendButton.setOnClickListener(sendButtonClickListener);
        } else {
            this.mImageSendButton.setVisibility(8);
            this.mTextSendButton.setVisibility(0);
            this.mTextSendButton.setOnClickListener(sendButtonClickListener);
        }
        this.mCaptionEditText.setHint(R.string.lp_add_a_caption);
        if (Configuration.getBoolean((int)R.bool.enable_ime_options_action_send)) {
            this.mCaptionEditText.setInputType(278529);
            this.mCaptionEditText.setImeOptions(4);
            this.mCaptionEditText.setOnEditorActionListener((v, actionId, event) -> {
                boolean handled = false;
                if (actionId == 4) {
                    this.startFileUpload();
                    handled = true;
                }
                return handled;
            });
        } else {
            this.mCaptionEditText.setInputType(147457);
        }
        this.mCaptionEditText.setTextColor(ContextCompat.getColor((Context)this.requireContext(), (int)R.color.lp_enter_msg_text));
        this.mCaptionEditText.setHintTextColor(ContextCompat.getColor((Context)this.requireContext(), (int)R.color.lp_enter_msg_hint));
        this.mLabelTextView.setText(R.string.lp_accessibility_image_caption);
        if (this.getView() != null) {
            this.getView().getRootView().clearFocus();
        }
        this.setEnterTextMinWidth();
    }

    private void displayFilePreview() {
        if (FileSharingUtils.isDocumentType((FileSharingType)this.mFileType)) {
            int fileResource;
            switch (this.mFileType) {
                case PDF: {
                    fileResource = R.drawable.lp_pdf_thumbnail;
                    break;
                }
                case DOCX: {
                    fileResource = R.drawable.lp_docx_thumbnail;
                    break;
                }
                case XLSX: {
                    fileResource = R.drawable.lp_xlsx_thumbnail;
                    break;
                }
                case PPTX: {
                    fileResource = R.drawable.lp_pptx_thumbnail;
                    break;
                }
                default: {
                    fileResource = R.drawable.lp_messaging_ui_icon_image_broken;
                }
            }
            this.mPreviewImage.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2));
            this.mPreviewImage.setImageResource(fileResource);
            this.mPreviewImage.setContentDescription((CharSequence)this.getResources().getString(R.string.lp_accessibility_file_icon));
            Uri fileUri = Uri.parse((String)this.mImageUriString);
            String fileName = DocumentUtils.getDocumentName((Uri)fileUri, (Context)this.getActivity());
            if (fileName != null) {
                this.mFileNameTextView.setVisibility(0);
                this.mFileNameTextView.setText((CharSequence)fileName);
            }
        } else {
            PicassoUtils.get((Context)this.requireContext()).load(this.mImageUriString).error(R.drawable.lp_messaging_ui_icon_image_broken).rotate((float)this.mOrientation).fit().centerInside().memoryPolicy(MemoryPolicy.NO_STORE, new MemoryPolicy[]{MemoryPolicy.NO_CACHE}).networkPolicy(NetworkPolicy.NO_STORE, new NetworkPolicy[]{NetworkPolicy.NO_CACHE}).into(this.mPreviewImage);
        }
    }

    private void setEnterTextMinWidth() {
        DisplayMetrics metrics = new DisplayMetrics();
        WindowManager wm = (WindowManager)this.getActivity().getSystemService("window");
        wm.getDefaultDisplay().getMetrics(metrics);
        this.mTextSendButton.setMaxWidth(metrics.widthPixels / 2);
    }

    private void startFileUpload() {
        LPLog.INSTANCE.d(TAG, "startFileUpload: uploading file...");
        MessagingFactory.getInstance().getController().sendFileMessage(this.mFileType, this.mBrandId, this.mBrandId, this.mImageUriString, this.mCaptionEditText.getText().toString(), this.mImageFromCamera);
        this.isFileUploaded = true;
        if (this.mNestedFragmentsContainerCallbacks != null) {
            this.mNestedFragmentsContainerCallbacks.slideOutFragment();
        }
    }

    public void onResume() {
        super.onResume();
        Fragment fragment = this.getParentFragment();
        if (fragment instanceof NestedFragmentsContainerCallbacks) {
            this.mNestedFragmentsContainerCallbacks = (NestedFragmentsContainerCallbacks)fragment;
        }
        if (this.mNestedFragmentsContainerCallbacks != null) {
            this.mNestedFragmentsContainerCallbacks.setCaptionPreviewMode(true, this.formTitle);
        }
    }

    public void onPause() {
        if (this.mNestedFragmentsContainerCallbacks != null) {
            this.mNestedFragmentsContainerCallbacks.setCaptionPreviewMode(false, this.formTitle);
            this.mNestedFragmentsContainerCallbacks = null;
        }
        super.onPause();
    }

    public void onDestroyView() {
        this.mImageSendButton.setOnClickListener(null);
        this.mCaptionEditText.setOnEditorActionListener(null);
        super.onDestroyView();
    }

    public void onDestroy() {
        if (this.mNestedFragmentsContainerCallbacks != null) {
            this.mNestedFragmentsContainerCallbacks.setCaptionPreviewMode(false, this.formTitle);
            this.mNestedFragmentsContainerCallbacks = null;
        }
        if (this.mImageFromCamera && !this.isFileUploaded) {
            this.deleteImageFile();
        }
        super.onDestroy();
    }

    private void deleteImageFile() {
        String imagePath = ImageUtils.getImagePath((Context)this.getActivity().getApplicationContext(), (Uri)Uri.parse((String)this.mImageUriString));
        File fileToDelete = new File(imagePath);
        if (fileToDelete.isFile()) {
            if (fileToDelete.delete()) {
                LPLog.INSTANCE.d(TAG, "deleteImageFile: File deleted successfully (" + imagePath + ")");
            } else {
                LPLog.INSTANCE.w(TAG, "deleteImageFile: Error deleting file (" + imagePath + ")");
            }
        }
    }
}

