/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.fragment;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import com.liveperson.infra.InternetConnectionService;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.accessibility.AccessibilityAnnouncer;
import com.liveperson.infra.messaging_ui.fragment.IConnectable;
import com.liveperson.infra.ui.view.ui.CustomTextView;

public class ConnectionStatusController
extends CustomTextView {
    public static final String TAG = "ConnectionStatusController";
    public static final int TRYING_TO_CONNECT_DELAY = 8000;
    public static final int CONNECTING_DELAY = 2000;
    private final int CONNECTING_HIDE = 1;
    private final int CONNECTING_SHOW = 2;
    private final int TRYING_TO_CONNECT_SHOW = 3;
    private final int NO_INTERNET_CONNECTION = 4;
    private final int CONNECTION_FAILED = 5;
    private final int CONNECTED = 6;
    private int mState = -1;
    private LocalBroadcastReceiver mLocalBroadcastReceiver;
    private IConnectable mConnectionProvider;
    private Runnable mActionTimerToShowConnecting;
    private Runnable mActionTimerToShowTryingToConnect;
    private AccessibilityAnnouncer mAnnouncer;
    @Nullable
    private OnVisibilityChangedListener mOnVisibilityChangedListener;

    public ConnectionStatusController(Context context) {
        this(context, null);
    }

    public ConnectionStatusController(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ConnectionStatusController(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void registerToChanges(IConnectable connectable) {
        this.mConnectionProvider = connectable;
        if (this.mLocalBroadcastReceiver != null) {
            this.mLocalBroadcastReceiver.register();
            return;
        }
        this.mLocalBroadcastReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_START_CONNECTING").addAction("BROADCAST_KEY_SOCKET_READY_ACTION").addAction("CONNECTION_DISCONNECTED").addAction("BROADCAST_CONNECTING_TO_SERVER_ERROR").addAction("BROADCAST_SOCKET_OPEN_ACTION").build((context, intent) -> {
            LPLog.INSTANCE.d(TAG, "onConnectionChanged - action = " + intent.getAction());
            if (intent.getAction().equals("BROADCAST_SOCKET_OPEN_ACTION")) {
                this.onConnected();
                return;
            }
            if (intent.getAction().equals("BROADCAST_START_CONNECTING")) {
                this.onConnecting(true);
            }
            if (intent.getAction().equals("BROADCAST_KEY_SOCKET_READY_ACTION")) {
                boolean isSocketReady = intent.getBooleanExtra("BROADCAST_KEY_SOCKET_READY_EXTRA", false);
                if (isSocketReady) {
                    this.onConnected();
                } else {
                    this.onConnecting(false);
                }
                return;
            }
            if (intent.getAction().equals("BROADCAST_CONNECTING_TO_SERVER_ERROR")) {
                this.onError();
            }
            if (intent.getAction().equals("CONNECTION_DISCONNECTED")) {
                this.onConnecting(false);
            }
        });
    }

    public void unregister() {
        this.mConnectionProvider = null;
        if (this.mLocalBroadcastReceiver != null) {
            this.mLocalBroadcastReceiver.unregister();
            this.mLocalBroadcastReceiver = null;
            this.removeCallbacks(this.mActionTimerToShowConnecting);
            this.removeCallbacks(this.mActionTimerToShowTryingToConnect);
        }
    }

    public void initState(boolean isSocketReady, boolean isConnecting) {
        if (isSocketReady) {
            this.onConnected();
        } else {
            this.onConnecting(isConnecting);
        }
    }

    public void setAnnouncer(AccessibilityAnnouncer mAnnouncer) {
        this.mAnnouncer = mAnnouncer;
    }

    private void onConnected() {
        LPLog.INSTANCE.d(TAG, "onConnected - current state = " + this.mState);
        this.mState = 6;
        this.applyState();
    }

    private void onError() {
        LPLog.INSTANCE.d(TAG, "onError - current state = " + this.mState);
        this.mState = 5;
        this.applyState();
    }

    private void onConnecting(boolean isConnecting) {
        LPLog.INSTANCE.d(TAG, "onConnectionChanged - isConnecting = " + isConnecting + " current state = " + this.mState);
        if (InternetConnectionService.isNetworkAvailable()) {
            if (isConnecting && this.mState != 2) {
                this.mState = 2;
                this.setTimerToShowConnecting();
            } else {
                LPLog.INSTANCE.d(TAG, "onConnectionChanged - not starting to connect. keeping current state. ");
            }
        } else {
            this.mState = 4;
        }
        this.applyState();
    }

    private void setTimerToShowConnecting() {
        this.postDelayed(this.getTimerToShowConnecting(), 2000L);
    }

    private void setTimerToShowTryingToConnect() {
        this.postDelayed(this.getTimerToShowTryingToConnect(), 8000L);
    }

    private Runnable getTimerToShowConnecting() {
        if (this.mActionTimerToShowConnecting == null) {
            this.mActionTimerToShowConnecting = () -> {
                if (this.mState == 1) {
                    this.mState = 2;
                    this.applyState();
                    this.setTimerToShowTryingToConnect();
                }
            };
        }
        return this.mActionTimerToShowConnecting;
    }

    private Runnable getTimerToShowTryingToConnect() {
        if (this.mActionTimerToShowTryingToConnect == null) {
            this.mActionTimerToShowTryingToConnect = () -> {
                if (this.mState == 2) {
                    this.mState = 3;
                    this.applyState();
                }
            };
        }
        return this.mActionTimerToShowTryingToConnect;
    }

    private void applyState() {
        LPLog.INSTANCE.d(TAG, "apply state = " + this.mState + " getHeight() = " + this.getHeight());
        this.setOnClickListener(null);
        String accessibilityAnnouncement = null;
        if (Configuration.getBoolean((int)R.bool.lp_is_offline_messaging_enabled)) {
            if (this.mState != 4 && this.mState != 5) {
                this.hide();
                this.notifyVisibilityChanged(8);
                return;
            }
            this.notifyVisibilityChanged(0);
        }
        switch (this.mState) {
            case 1: 
            case 6: {
                int height = this.getHeight();
                if (height == 0) {
                    this.setVisibility(4);
                } else {
                    this.animate().translationY((float)(-height));
                    this.setVisibility(0);
                }
                accessibilityAnnouncement = this.getResources().getString(R.string.lp_accessibility_connection_status_connected);
                break;
            }
            case 3: {
                this.setText(R.string.lp_connection_status_trying_to_connect);
                accessibilityAnnouncement = this.getResources().getString(R.string.lp_accessibility_connection_status_trying_to_connect);
                this.setConnectingStatusColor();
                this.show();
                break;
            }
            case 2: {
                this.setText(R.string.lp_connection_status_connecting);
                accessibilityAnnouncement = this.getResources().getString(R.string.lp_accessibility_connection_status_connecting);
                this.setConnectingStatusColor();
                this.show();
                break;
            }
            case 5: {
                this.setText(R.string.lp_connection_status_failed_to_connect);
                accessibilityAnnouncement = this.getResources().getString(R.string.lp_accessibility_connection_status_failed_to_connect);
                this.setOnClickListener(v -> {
                    if (this.mConnectionProvider != null) {
                        this.mConnectionProvider.connect();
                    }
                    this.mState = 2;
                    this.applyState();
                    this.setTimerToShowTryingToConnect();
                });
                this.setConnectedStatusColor();
                this.show();
                break;
            }
            case 4: {
                this.setText(R.string.lp_connection_status_no_connection);
                accessibilityAnnouncement = this.getResources().getString(R.string.lp_accessibility_connection_status_no_internet_connection);
                this.setConnectedStatusColor();
                this.show();
            }
        }
        if (accessibilityAnnouncement != null && this.mAnnouncer != null) {
            this.mAnnouncer.announce(accessibilityAnnouncement);
        }
    }

    private void setConnectedStatusColor() {
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.connection_status_not_connected_bg_color));
        this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.connection_status_not_connected_text_color));
    }

    private void setConnectingStatusColor() {
        this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.connection_status_connecting_bg_color));
        this.setTextColor(ContextCompat.getColor((Context)this.getContext(), (int)R.color.connection_status_connecting_text_color));
    }

    private void show() {
        if (this.getVisibility() != 0) {
            this.setTranslationY(-this.getHeight());
        }
        this.setVisibility(0);
        this.animate().translationY(0.0f).start();
    }

    private void hide() {
        int height = this.getHeight();
        if (height == 0) {
            this.setVisibility(8);
        } else if (this.getTranslationY() == 0.0f) {
            this.animate().translationY((float)(-this.getHeight())).withEndAction(() -> this.setVisibility(8)).start();
        } else {
            this.setVisibility(8);
        }
    }

    private void notifyVisibilityChanged(int visibility) {
        OnVisibilityChangedListener listener = this.mOnVisibilityChangedListener;
        if (listener != null) {
            listener.onVisibilityChanged(visibility);
        }
    }

    public OnVisibilityChangedListener getOnVisibilityChangedListener() {
        return this.mOnVisibilityChangedListener;
    }

    public void setOnVisibilityChangedListener(OnVisibilityChangedListener mOnVisibilityChangedListener) {
        this.mOnVisibilityChangedListener = mOnVisibilityChangedListener;
    }

    static interface OnVisibilityChangedListener {
        public void onVisibilityChanged(int var1);
    }
}

