/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.fragment;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.Fragment;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.fragment.NestedFragmentsContainerCallbacks;
import com.liveperson.infra.messaging_ui.view.adapter.copybehavior.ContextualItemAction;
import com.liveperson.infra.utils.PicassoUtils;
import com.squareup.picasso.Callback;
import java.io.File;

public class FullImageFragment
extends Fragment
implements MenuItem.OnMenuItemClickListener {
    public static final String TAG = FullImageFragment.class.getSimpleName();
    public static String KEY_IMAGE_URI_STRING = "imageUri";
    private String mImageUriString;
    private ContextualItemAction mContextualItemAction;
    private ImageView mFullImageView;
    private NestedFragmentsContainerCallbacks mNestedFragmentsContainerCallbacks;
    private Menu mContextMenu;

    public static FullImageFragment newInstance(String imageUriString) {
        Bundle args = new Bundle();
        args.putString(KEY_IMAGE_URI_STRING, imageUriString);
        FullImageFragment fragment = new FullImageFragment();
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mImageUriString = this.getArguments().getString(KEY_IMAGE_URI_STRING);
        }
    }

    public View onCreateView(@NonNull LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.lpmessaging_ui_fragment_full_image, container, false);
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.getActivity() == null) {
            return;
        }
        LPLog.INSTANCE.d(TAG, "onViewCreated: ImageUriString: " + this.mImageUriString);
        InputMethodManager imm = (InputMethodManager)this.getActivity().getSystemService("input_method");
        if (imm != null) {
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        }
        this.mFullImageView = (ImageView)view.findViewById(R.id.lpui_full_image_view);
        this.mFullImageView.setOnCreateContextMenuListener((menu2, v, menuInfo) -> {
            MenuInflater inflater = this.getActivity().getMenuInflater();
            inflater.inflate(R.menu.lpmessaging_ui_item_copy_menu, (Menu)menu2);
            if (!TextUtils.isEmpty((CharSequence)this.mImageUriString)) {
                menu2.findItem(R.id.context_menu_share).setVisible(true);
                menu2.findItem(R.id.context_menu_share).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)this);
                menu2.findItem(R.id.context_menu_save).setVisible(true);
                menu2.findItem(R.id.context_menu_save).setOnMenuItemClickListener((MenuItem.OnMenuItemClickListener)this);
                menu2.findItem(R.id.context_menu_copy).setVisible(false);
            }
            this.mContextMenu = menu2;
        });
        ViewCompat.setAccessibilityDelegate((View)this.mFullImageView, (AccessibilityDelegateCompat)new AccessibilityDelegateCompat(){

            public void onPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
                super.onPopulateAccessibilityEvent(host, event);
                host.setClickable(false);
                host.setLongClickable(true);
            }
        });
        PicassoUtils.get((Context)this.requireContext()).load(new File(this.mImageUriString)).tag((Object)TAG).into(this.mFullImageView, new Callback(){

            public void onSuccess() {
                View rootView = FullImageFragment.this.getView();
                if (rootView != null) {
                    rootView.findViewById(R.id.lpui_full_image_progress_bar).setVisibility(8);
                    rootView.findViewById(R.id.lpui_full_image_view).setVisibility(0);
                }
            }

            public void onError(Exception e) {
            }
        });
    }

    public boolean onMenuItemClick(MenuItem item) {
        ContextualItemAction action = this.mContextualItemAction;
        if (action == null) {
            return false;
        }
        if (item.getItemId() == R.id.context_menu_share) {
            action.performFileAction(this.mImageUriString, ContextualItemAction.Action.SHARE);
            return true;
        }
        if (item.getItemId() == R.id.context_menu_save) {
            action.performSaveFile(this.mImageUriString);
            return true;
        }
        return false;
    }

    public void onDestroyView() {
        if (this.mFullImageView != null) {
            if (this.mContextMenu != null) {
                int itemsCount = this.mContextMenu.size();
                for (int i = 0; i < itemsCount; ++i) {
                    MenuItem item = this.mContextMenu.getItem(i);
                    LPLog.INSTANCE.w(TAG, "Nullify item " + item);
                    if (item == null) continue;
                    item.setOnMenuItemClickListener(null);
                }
                this.mContextMenu = null;
            }
            this.mFullImageView.setOnCreateContextMenuListener(null);
            ViewCompat.setAccessibilityDelegate((View)this.mFullImageView, null);
            this.mFullImageView = null;
        }
        PicassoUtils.get((Context)this.requireContext()).cancelTag((Object)TAG);
        super.onDestroyView();
    }

    public void onResume() {
        super.onResume();
        this.setCallbacks();
        if (this.mNestedFragmentsContainerCallbacks != null) {
            this.mNestedFragmentsContainerCallbacks.setFullImageMode(true);
        }
    }

    public void onPause() {
        if (this.mNestedFragmentsContainerCallbacks != null) {
            this.mNestedFragmentsContainerCallbacks.setFullImageMode(false);
        }
        this.mNestedFragmentsContainerCallbacks = null;
        this.mContextualItemAction = null;
        super.onPause();
    }

    public void onDestroy() {
        this.mNestedFragmentsContainerCallbacks = null;
        this.mContextualItemAction = null;
        super.onDestroy();
    }

    private void setCallbacks() {
        Fragment fragment = this.getParentFragment();
        if (fragment instanceof ContextualItemAction) {
            this.mContextualItemAction = (ContextualItemAction)this.getParentFragment();
        }
        if (fragment instanceof NestedFragmentsContainerCallbacks) {
            this.mNestedFragmentsContainerCallbacks = (NestedFragmentsContainerCallbacks)this.getParentFragment();
        }
    }
}

