/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.toolbar;

import android.content.Context;
import android.graphics.PorterDuff;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.widget.Toolbar;
import androidx.core.content.ContextCompat;
import com.liveperson.infra.LPConversationsHistoryStateToDisplay;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.fragment.IFeedbackActions;
import com.liveperson.infra.messaging_ui.toolbar.LPToolBar;
import com.liveperson.infra.ui.view.utils.picasso.CircleTransform;
import com.liveperson.infra.utils.PicassoUtils;
import com.squareup.picasso.Transformation;

public class ConversationToolBar
extends LPToolBar {
    private String mAvatarUrl;
    private TextView mToolbarTitle;
    private Button mToolbarFeedBackAction;
    private TextView mToolbarIsTyping;
    private ImageView mToolbarAgentAvatar;
    private LinearLayout mAgentDetailsContainer;

    public ConversationToolBar(Context context) {
        super(context);
    }

    public ConversationToolBar(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ConversationToolBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mToolbarFeedBackAction = (Button)this.findViewById(R.id.lpui_toolbar_feedback_action);
    }

    @Override
    public void onInitCompleted() {
        RelativeLayout titleContainer = (RelativeLayout)this.findViewById(R.id.lpmessaging_ui_toolbar_avatar_title_container);
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        inflater.inflate(R.layout.lpmessaging_ui_toolbar_avatar_title, (ViewGroup)titleContainer, true);
        this.mAgentDetailsContainer = (LinearLayout)this.findViewById(R.id.lpui_avatar_layout);
        this.mToolbarTitle = (TextView)this.findViewById(R.id.lpui_toolbar_title);
        this.setTitleAsAccessibilityHeading((View)this.mToolbarTitle);
        this.mToolbarIsTyping = (TextView)this.findViewById(R.id.lpui_toolbar_typing);
        this.mToolbarIsTyping.setVisibility(4);
        this.mToolbarAgentAvatar = (ImageView)this.findViewById(R.id.lpui_toolbar_agent_avatar);
    }

    public void updateAgentDetails(String nickname, String avatarUrl) {
        this.mAgentDetailsContainer.setVisibility(4);
        String agentNickName = TextUtils.isEmpty((CharSequence)nickname) ? this.getContext().getString(R.string.brand_name) : nickname;
        this.setAgentName(agentNickName);
        this.setAgentAvatarURI(avatarUrl);
        this.mAgentDetailsContainer.setVisibility(0);
    }

    public void setIsTyping(boolean isTyping) {
        if (this.mToolbarIsTyping != null) {
            if (isTyping && this.conversationsHistoryStateToDisplay != LPConversationsHistoryStateToDisplay.CLOSE && !this.isConversationInBackground) {
                this.mToolbarIsTyping.setVisibility(0);
            } else {
                this.mToolbarIsTyping.setVisibility(4);
            }
        }
    }

    @Override
    public void setAgentName(String agentName) {
        this.mToolbarTitle.setText((CharSequence)agentName);
    }

    private void setAgentAvatarURI(String agentAvatarUrl) {
        if (agentAvatarUrl == null) {
            this.mToolbarAgentAvatar.setColorFilter(null);
            this.mToolbarAgentAvatar.setImageResource(R.drawable.lp_messaging_ui_brand_logo);
        } else if (TextUtils.isEmpty((CharSequence)agentAvatarUrl)) {
            this.mToolbarAgentAvatar.setImageResource(R.drawable.lp_messaging_ui_ic_agent_avatar);
            this.mToolbarAgentAvatar.setColorFilter(ContextCompat.getColor((Context)this.getContext(), (int)R.color.agent_avatar_icon_color), PorterDuff.Mode.MULTIPLY);
        } else {
            this.mToolbarAgentAvatar.setColorFilter(null);
            this.mToolbarAgentAvatar.setImageResource(R.drawable.lp_messaging_ui_brand_logo);
            PicassoUtils.get((Context)this.getContext()).load(agentAvatarUrl).noPlaceholder().transform((Transformation)new CircleTransform()).into(this.mToolbarAgentAvatar);
        }
        this.mAvatarUrl = agentAvatarUrl;
    }

    @Override
    public void setFeedBackMode(boolean feedBackMode, IFeedbackActions actions) {
        this.mToolbarIsTyping.setVisibility(4);
        if (feedBackMode) {
            this.setBackgroundColor(this.getResources().getColor(R.color.feedback_toolbar_background));
            this.mToolbarAgentAvatar.setVisibility(0);
            this.mToolbarTitle.setVisibility(0);
            this.mToolbarFeedBackAction.setVisibility(0);
            this.mToolbarFeedBackAction.setText(R.string.lp_skip);
            this.mToolbarFeedBackAction.setTextColor(this.getResources().getColor(R.color.feedback_toolbar_textColor));
            this.mToolbarFeedBackAction.setOnClickListener(v -> actions.skipFeedBackScreen());
            this.isConversationInBackground = true;
        } else {
            this.mToolbarFeedBackAction.setVisibility(8);
            this.isConversationInBackground = false;
        }
    }

    @Override
    public void setFullImageMode(boolean fullImageMode) {
        this.mToolbarIsTyping.setVisibility(4);
        if (fullImageMode) {
            this.mToolbarAgentAvatar.setVisibility(8);
            this.mToolbarTitle.setVisibility(8);
            this.isConversationInBackground = true;
            this.setBackgroundColor(this.getResources().getColor(R.color.lp_transparent));
        } else {
            this.mToolbarAgentAvatar.setVisibility(0);
            this.mToolbarTitle.setVisibility(0);
            this.isConversationInBackground = false;
            this.setBackgroundColor(this.getResources().getColor(R.color.conversation_toolbar_color));
        }
    }

    @Override
    public void onSurveySubmitted(IFeedbackActions actions) {
        this.mToolbarFeedBackAction.setText(R.string.lp_done);
        this.mToolbarFeedBackAction.setTextColor(this.getResources().getColor(R.color.feedback_toolbar_textColor));
        this.mToolbarFeedBackAction.setOnClickListener(v -> actions.closeFeedBackScreen());
    }

    @Override
    public void setBrandId(String brandId) {
        this.mBrandId = brandId;
    }

    public void setOnAvatarIconClickListener(View.OnClickListener onAgentIconClickListener) {
        if (this.mToolbarAgentAvatar != null) {
            this.mToolbarAgentAvatar.setOnClickListener(onAgentIconClickListener);
        }
    }

    protected Parcelable onSaveInstanceState() {
        ToolbarState state = new ToolbarState(super.onSaveInstanceState());
        state.setTitle(this.mToolbarTitle.getText().toString());
        state.setAvatarUrl(this.mAvatarUrl);
        return state;
    }

    protected void onRestoreInstanceState(Parcelable state) {
        if (state instanceof ToolbarState) {
            ToolbarState currentState = (ToolbarState)state;
            String title = currentState.getTitle();
            String avatarUrl = currentState.getAvatarUrl();
            this.updateAgentDetails(title, avatarUrl);
            super.onRestoreInstanceState(currentState.getSuperState());
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    public static class ToolbarState
    extends Toolbar.SavedState {
        private String mTitle;
        private String mAvatarUrl;
        public static final Parcelable.Creator<ToolbarState> CREATOR = new Parcelable.ClassLoaderCreator<ToolbarState>(){

            public ToolbarState createFromParcel(Parcel in, ClassLoader loader) {
                return new ToolbarState(in, loader);
            }

            public ToolbarState createFromParcel(Parcel in) {
                return new ToolbarState(in, null);
            }

            public ToolbarState[] newArray(int size) {
                return new ToolbarState[size];
            }
        };

        public ToolbarState(Parcel source) {
            super(source);
        }

        public ToolbarState(Parcel source, ClassLoader loader) {
            super(source, loader);
            this.mTitle = source.readString();
            this.mAvatarUrl = source.readString();
        }

        public ToolbarState(Parcelable superState) {
            super(superState);
        }

        public String getTitle() {
            return this.mTitle;
        }

        public void setTitle(String title) {
            this.mTitle = title;
        }

        public String getAvatarUrl() {
            return this.mAvatarUrl;
        }

        public void setAvatarUrl(String avatarUrl) {
            this.mAvatarUrl = avatarUrl;
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeString(this.mTitle);
            out.writeString(this.mAvatarUrl);
        }
    }
}

