/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.toolbar;

import android.content.Context;
import android.content.res.Resources;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import androidx.appcompat.R;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.appcompat.widget.Toolbar;
import com.liveperson.infra.LPConversationsHistoryStateToDisplay;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.fragment.IFeedbackActions;
import com.liveperson.infra.messaging_ui.utils.AccessbilityUtilsKt;

public abstract class LPToolBar
extends Toolbar {
    protected String mBrandId;
    protected LPConversationsHistoryStateToDisplay conversationsHistoryStateToDisplay;
    protected boolean isConversationInBackground;

    public LPToolBar(Context context) {
        super(context);
        this.applyNavigateUpDescription();
    }

    public LPToolBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.applyNavigateUpDescription();
    }

    public LPToolBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.applyNavigateUpDescription();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
    }

    public void onResume() {
    }

    public void onPause() {
    }

    public void onInitCompleted() {
    }

    public void setAgentName(String agentName) {
    }

    public void setBrandId(String brandId) {
        this.mBrandId = brandId;
    }

    public void setConversationsHistoryStateToDisplay(LPConversationsHistoryStateToDisplay stateToDisplay) {
        this.conversationsHistoryStateToDisplay = stateToDisplay;
    }

    public void setFeedBackMode(boolean feedBackMode, IFeedbackActions actions) {
    }

    public void setFullImageMode(boolean fullImageMode) {
    }

    public void onSurveySubmitted(IFeedbackActions actions) {
    }

    public void announceBackButtonForAccessibility() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (!(child instanceof AppCompatImageButton)) continue;
            child.sendAccessibilityEvent(8);
            break;
        }
    }

    private void applyNavigateUpDescription() {
        Resources resources = this.getContext().getResources();
        String navigateUpButtonDescription = Configuration.getString((int)R.string.lp_accessibility_back_button);
        if (TextUtils.isEmpty((CharSequence)navigateUpButtonDescription)) {
            navigateUpButtonDescription = resources.getString(R.string.abc_action_bar_up_description);
        }
        this.setNavigationContentDescription(navigateUpButtonDescription);
    }

    protected void setTitleAsAccessibilityHeading(View view) {
        if (view != null) {
            AccessbilityUtilsKt.markAsAccessibilityHeading(view, true);
        }
    }
}

