/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.uicomponents;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.liveperson.infra.CampaignInfo;
import com.liveperson.infra.Infra;
import com.liveperson.infra.errors.ErrorCode;
import com.liveperson.infra.eventmanager.Event;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.utils.markdownlink.HyperLinkUtils;
import com.liveperson.infra.model.PushMessage;
import com.liveperson.infra.preferences.PushMessagePreferences;
import com.liveperson.infra.utils.LinkUtils;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class PushMessageParser {
    private static final String TAG = PushMessageParser.class.getSimpleName();
    private static final String KEY_PAYLOAD = "payload";
    private static final String KEY_MESSAGE = "message";
    private static final String KEY_TITLE = "title";
    private static final String KEY_BACKEND_SERVICE = "backendService";
    private static final String KEY_COLLAPSE = "collapse_key";
    private static final String KEY_CONVERSATION_ID = "conversationId";
    private static final String KEY_LE_ENGAGEMENT_ID = "leEngagementId";
    private static final String KEY_LE_CAMPAIGN_ID = "leCampaignId";
    private static final String KEY_IS_OUTBOUND_PUSH = "isProactivePush";
    private static final String KEY_LOOK_BACK_PERIOD = "lookBackPeriod";
    private static final String KEY_AGENT_PID = "agentPid";
    private static final String KEY_TRANSACTION_ID = "transactionId";
    private static final String KEY_BADGE_UNREAD_COUNTER = "badge";
    private static final String KEY_C2M_BACKEND = "c2m";
    private static final String KEY_EVENT = "event";
    private static final String DELIMITER = ":";

    @Nullable
    public static PushMessage parse(String brandId, Context context, Map<String, String> remoteMessage) {
        try {
            Bundle pushMessageBundle = PushMessageParser.convertDataToBundle(remoteMessage);
            return PushMessageParser.parsePushMessage(brandId, context, pushMessageBundle);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000010A, "Push message parsing error", (Throwable)e);
            return null;
        }
    }

    @NonNull
    private static PushMessage parsePushMessage(String brandId, Context context, Bundle pushMessageBundle) throws JSONException {
        String collapseKey = pushMessageBundle.getString(KEY_COLLAPSE);
        String originMessage = pushMessageBundle.getString(KEY_MESSAGE);
        String splitMessage = "";
        String title = pushMessageBundle.getString(KEY_TITLE);
        String from = "";
        if (!TextUtils.isEmpty((CharSequence)originMessage)) {
            int splitPoint = originMessage.indexOf(DELIMITER);
            if (splitPoint != -1) {
                from = originMessage.substring(0, splitPoint).trim();
                splitMessage = originMessage.substring(splitPoint + DELIMITER.length()).trim();
                if (LinkUtils.containsMarkdownHyperlink((String)splitMessage)) {
                    splitMessage = HyperLinkUtils.INSTANCE.buildMessageString(splitMessage);
                }
            } else {
                splitMessage = originMessage;
            }
        }
        PushMessage pushMessage = new PushMessage(brandId, from, splitMessage);
        String payLoadString = pushMessageBundle.getString(KEY_PAYLOAD);
        String conversationId = "";
        String backendService = "";
        String engagementId = "";
        String campaignId = "";
        boolean isOutboundPush = false;
        String lookBackPeriod = "";
        String agentPid = "";
        String transactionId = "";
        if (!TextUtils.isEmpty((CharSequence)title)) {
            pushMessage.setTitle(title);
        }
        if (!TextUtils.isEmpty((CharSequence)payLoadString)) {
            JSONObject payLoadJson = new JSONObject(payLoadString);
            conversationId = payLoadJson.optString(KEY_CONVERSATION_ID);
            backendService = payLoadJson.optString(KEY_BACKEND_SERVICE);
            engagementId = payLoadJson.optString(KEY_LE_ENGAGEMENT_ID);
            campaignId = payLoadJson.optString(KEY_LE_CAMPAIGN_ID);
            isOutboundPush = payLoadJson.optBoolean(KEY_IS_OUTBOUND_PUSH);
            if (!isOutboundPush && backendService.equals(KEY_C2M_BACKEND)) {
                isOutboundPush = true;
            }
            lookBackPeriod = payLoadJson.optString(KEY_LOOK_BACK_PERIOD);
            agentPid = payLoadJson.optString(KEY_AGENT_PID);
            transactionId = payLoadJson.optString(KEY_TRANSACTION_ID);
            String messageEvent = payLoadJson.optString(KEY_EVENT);
            String unreadCounter = payLoadJson.optString(KEY_BADGE_UNREAD_COUNTER);
            if (!TextUtils.isEmpty((CharSequence)unreadCounter) && TextUtils.isDigitsOnly((CharSequence)unreadCounter)) {
                pushMessage.setCurrentUnreadMessagesCounter(Integer.parseInt(unreadCounter));
            }
            if (!TextUtils.isEmpty((CharSequence)messageEvent)) {
                pushMessage.setMessageEvent(messageEvent);
            }
        }
        pushMessage.setConversationId(conversationId);
        pushMessage.setCollapseKey(collapseKey);
        pushMessage.setBackendService(backendService);
        pushMessage.setTransactionId(transactionId);
        if (!TextUtils.isEmpty((CharSequence)engagementId) && !TextUtils.isEmpty((CharSequence)campaignId)) {
            pushMessage.setMessage(originMessage);
            pushMessage.setCampaignInfo(new CampaignInfo(Long.valueOf(campaignId), Long.valueOf(engagementId), isOutboundPush));
            if (!TextUtils.isEmpty((CharSequence)lookBackPeriod)) {
                pushMessage.setLookBackPeriod(Long.valueOf(lookBackPeriod));
            }
            pushMessage.setAgentPid(agentPid);
            if (context != null) {
                PushMessagePreferences.INSTANCE.init(context.getApplicationContext());
                PushMessagePreferences.INSTANCE.setCachedPushMessage(brandId, pushMessage);
                Infra.instance.getEventManagerService().logEvent(brandId, transactionId, true, Event.DELIVERY, null, null, context.getApplicationContext());
            }
        }
        return pushMessage;
    }

    public static Bundle convertDataToBundle(Map<String, String> data) {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return bundle;
    }

    public static PushMessage parseBundle(String brandId, Context context, Bundle data) {
        try {
            return PushMessageParser.parsePushMessage(brandId, context, data);
        }
        catch (Exception e) {
            LPLog.INSTANCE.e(TAG, ErrorCode.ERR_0000010B, "Push message parsing error", (Throwable)e);
            return null;
        }
    }
}

