/*
 * Decompiled with CFR 0.152.
 */
package com.liveperson.infra.messaging_ui.uicomponents.inlinemessages;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.view.View;
import android.widget.TextView;
import com.liveperson.infra.LocalBroadcastReceiver;
import com.liveperson.infra.configuration.Configuration;
import com.liveperson.infra.log.LPLog;
import com.liveperson.infra.messaging_ui.R;
import com.liveperson.infra.messaging_ui.uicomponents.inlinemessages.IInlineMessage;
import com.liveperson.infra.messaging_ui.uicomponents.inlinemessages.OffHours;
import com.liveperson.infra.messaging_ui.uicomponents.inlinemessages.TTRSnackBar;
import com.liveperson.infra.ui.view.uicomponents.IConversationProvider;
import com.liveperson.messaging.MessagingFactory;
import java.lang.ref.WeakReference;

public class InlineMessagesController {
    private static final String TAG = "InlineMessagesController";
    private final IConversationProvider mConversationProvider;
    private IInlineMessage mTTRSnackBar;
    private IInlineMessage mOffHours;
    protected LocalBroadcastReceiver mTTRReceiver;
    private LocalBroadcastReceiver mOffHoursTTRReceiver;
    private WeakReference<Context> mContext;
    private boolean mTTRNotificationEnabled;
    private boolean mOffHoursNotificationEnabled;

    public InlineMessagesController(Context context, Resources res, View rootView, IConversationProvider conversationProvider) {
        this.mConversationProvider = conversationProvider;
        this.mOffHoursNotificationEnabled = Configuration.getBoolean((int)R.bool.ttr_message_off_hours_enabled);
        this.mTTRNotificationEnabled = !Configuration.getBoolean((int)R.bool.disableTTRPopup);
        this.mTTRSnackBar = new TTRSnackBar(res, rootView.findViewById(R.id.lpui_recycler_view));
        this.mOffHours = new OffHours(res, (TextView)rootView.findViewById(R.id.lpmessaging_ui_off_hours_view));
        this.mContext = new WeakReference<Context>(context);
    }

    public void onConversationResolved() {
        this.mTTRSnackBar.hide();
    }

    protected void registerTTRReceiver() {
        if (this.mTTRNotificationEnabled) {
            if (this.mTTRReceiver == null) {
                this.mTTRReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_UPDATE_CONVERSATION_TTR").build((context, intent) -> {
                    Context activityContext;
                    LPLog.INSTANCE.d(TAG, "TTR broadcast");
                    if (this.isTargetIdMatch(intent) && (activityContext = (Context)this.mContext.get()) != null) {
                        this.showTTR(activityContext, intent);
                    }
                });
            } else {
                this.mTTRReceiver.register();
            }
        }
    }

    private void registerOffHoursTTRReceiver() {
        if (this.mOffHoursNotificationEnabled) {
            if (this.mOffHoursTTRReceiver == null) {
                this.mOffHoursTTRReceiver = new LocalBroadcastReceiver.Builder().addAction("BROADCAST_UPDATE_CONVERSATION_OFF_HOURS").build((context, intent) -> {
                    LPLog.INSTANCE.d(TAG, "Off hours broadcast");
                    if (this.isTargetIdMatch(intent)) {
                        this.showOffHours(context, intent);
                    }
                });
            } else {
                this.mOffHoursTTRReceiver.register();
            }
        }
    }

    private boolean isTargetIdMatch(Intent intent) {
        String targetId = intent.getStringExtra("CONVERSATION_TARGET_ID");
        return this.mConversationProvider.getTargetId().equals(targetId);
    }

    private void showTTR(Context context, Intent intent) {
        this.mOffHours.hide();
        this.mTTRSnackBar.show(context, intent);
    }

    private void showOffHours(Context context, Intent intent) {
        this.mTTRSnackBar.hide();
        this.mOffHours.show(context, intent);
    }

    public void register(String brandID) {
        this.registerTTRReceiver();
        this.registerOffHoursTTRReceiver();
        MessagingFactory.getInstance().getController().amsConversations.notifyOffHoursStatus(brandID);
    }

    public void unregister() {
        if (this.mOffHoursTTRReceiver != null) {
            this.mOffHoursTTRReceiver.unregister();
        }
        if (this.mTTRReceiver != null) {
            this.mTTRReceiver.unregister();
        }
    }

    public void hideAll() {
        this.mOffHours.hide();
        this.mTTRSnackBar.hide();
    }
}

